/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.rlm.RunLengthMatrix;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import processing.reducer.ColorReducer;

public class MultiRLM
implements ComputableFeatures {
    private final RunLengthMatrix rlm = new RunLengthMatrix();
    private int GrayLevelMax = -1;
    private int Width = -1;
    private double[][] matrix = null;
    private double[] Coefficients = null;
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"MultiRLM_SZE", "MultiRLM_LZE", "MultiRLM_LGZE", "MultiRLM_HGZE", "MultiRLM_SZLGE", "MultiRLM_SZHGE", "MultiRLM_LZLGE", "MultiRLM_LZHGE", "MultiRLM_GLNU", "MultiRLM_SZNU", "MultiRLM_ZPC", "MultiRLM_BARYGL", "MultiRLM_BARYS", "MultiRLM_VARGL", "MultiRLM_VARS", "MultiRLM_ORIE"};
    private ColorReducer reducer = null;
    private int ForbiddenValue = -1;

    @Override
    public synchronized void Kill() {
        this.rlm.Kill();
        this.matrix = null;
        this.Coefficients = null;
        this.Features = null;
        this.FeaturesNames = null;
        this.reducer = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        double[][] m = null;
        switch (image.getType()) {
            case 10: {
                int nbCoefs;
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                int nbCoefs;
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.rlm.FillMatrix(image, mask, n, reducer, ForbiddenValue, nbCPU);
            m = this.rlm.matrix;
            if (this.matrix == null) {
                this.Width = m[0].length;
                this.matrix = new double[this.GrayLevelMax][this.Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            int step = this.GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n <<= 1;
            ++nb;
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.reducer, ForbiddenValue, nbCPU);
    }

    public void ComputeFromStack(BufferedImage[] images, BufferedImage[] masks, int nbSizes, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.Compute(images[i2], masks[i2], reducer, ForbiddenValue, nbCPU);
            for (int j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (int j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    public void Compute(DV dv, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        double[][] m = null;
        switch (dv.Type) {
            case 8: {
                int nbCoefs;
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 16: {
                int nbCoefs;
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            int i2;
            this.rlm.FillMatrix(dv, n, reducer, ForbiddenValue, nbCPU);
            m = this.rlm.matrix;
            if (this.matrix == null) {
                this.Width = m[0].length;
                this.matrix = new double[this.GrayLevelMax][this.Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            if (this.matrix[0].length < m[0].length) {
                double[][] mat = this.matrix;
                this.matrix = null;
                this.Width = m[0].length;
                this.matrix = new double[this.GrayLevelMax][this.Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
                for (i2 = 0; i2 < this.matrix.length; ++i2) {
                    System.arraycopy(mat[i2], 0, this.matrix[i2], 0, mat[i2].length);
                }
                mat = null;
            }
            int step = this.GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n <<= 1;
            ++nb;
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Compute(dv, this.reducer, this.ForbiddenValue, nbCPU);
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void AllocCoefficients(int size) {
        this.AllocCoefficients(size, 2.0, 0.0);
    }

    private void AllocCoefficients(int size, double sigma, double decalage) {
        int x;
        double middle = (double)(size - 1) / 2.0 + decalage;
        if (this.Coefficients == null || this.Coefficients.length != size) {
            this.Coefficients = null;
            this.Coefficients = new double[size];
        }
        double sum = 0.0;
        for (x = 0; x < size; ++x) {
            double val;
            double d2 = Math.pow(middle - (double)x, 2.0) / (2.0 * Math.pow(sigma, 2.0));
            this.Coefficients[x] = val = Math.exp(-d2);
            sum += val;
        }
        x = 0;
        while (x < size) {
            int n = x++;
            this.Coefficients[n] = this.Coefficients[n] / sum;
        }
    }

    public void AllocCoefficients(double[] weights) {
        this.Coefficients = Arrays.copyOf(weights, weights.length);
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("2 parameters required.");
        }
        this.reducer = (ColorReducer)parameters[0];
        this.ForbiddenValue = (Integer)parameters[1];
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.GrayLevelMax; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SZE();
        this.Features[1] = this.LZE();
        this.Features[2] = this.LGZE();
        this.Features[3] = this.HGZE();
        this.Features[4] = this.SZLGE();
        this.Features[5] = this.SZHGE();
        this.Features[6] = this.LZLGE();
        this.Features[7] = this.LZHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.SZNU();
        this.Features[10] = this.ZPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYS();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARS(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private double SZE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LZE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LGZE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2;
            }
        }
        return val / this.Sum;
    }

    private double HGZE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * n2;
            }
        }
        return val / this.Sum;
    }

    private double SZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2 / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double SZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) / (double)(s + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(s + 1) / (double)(n + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * n2 * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SZNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.GrayLevelMax; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double ZPC() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYS() {
        double mean = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double v = (double)(n + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARS(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double v = (double)(s + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                if (Double.compare(m, 0.0) == 0) continue;
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)(n + 1) * (double)(n + 1) * m;
                m20 += (double)(s + 1) * (double)(s + 1) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = m11 / this.Sum - bgl * bs;
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String glr = this.reducer.getClass().getSimpleName();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + glr;
        }
        glr = null;
        return names;
    }

    public void Coefficients(double[] Coefficients) {
        this.Coefficients = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public double[] Coefficients() {
        return this.Coefficients;
    }
}

