/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLM;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import mathematics.functions.Function;
import mathematics.functions.LinearFunctions;
import processing.reducer.FuzzyGLR;

public class MultiFuzzyRLM
implements ComputableFeatures {
    private FuzzyRLM frlm = new FuzzyRLM();
    private FuzzyGLR glr = null;
    private double[][] matrix = null;
    private double[] Coefficients = null;
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"MultiFuzzyRLM_SRE", "MultiFuzzyRLM_LRE", "MultiFuzzyRLM_LGRE", "MultiFuzzyRLM_HGRE", "MultiFuzzyRLM_SRLGE", "MultiFuzzyRLM_SRHGE", "MultiFuzzyRLM_LRLGE", "MultiFuzzyRLM_LRHGE", "MultiFuzzyRLM_GLNU", "MultiFuzzyRLM_SRNU", "MultiFuzzyRLM_RPC", "MultiFuzzyRLM_BARYGL", "MultiFuzzyRLM_BARYR", "MultiFuzzyRLM_VARGL", "MultiFuzzyRLM_VARR", "MultiFuzzyRLM_ORIE"};
    private int mode = -1;
    private int ForbiddenValue = -1;
    private int fuzzystart = 1;
    private int fuzzyend = 5;
    private int step = 2;
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public synchronized void Kill() {
        this.Features = null;
        this.FeaturesNames = null;
        this.matrix = null;
        this.Coefficients = null;
        this.frlm.Kill();
        this.frlm = null;
        this.glr = null;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.mode, ForbiddenValue, this.fuzzystart, this.fuzzyend, this.step, nbCPU);
    }

    public void Compute(BufferedImage image, BufferedImage mask, int mode, int ForbiddenValue, int fuzzystart, int fuzzyend, int step, int nbCPU) {
        if (mode == -3) {
            throw new IllegalArgumentException("Mode not supported (yet).");
        }
        if (this.Coefficients == null) {
            this.AllocCoefficients((fuzzyend - fuzzystart) / step + 1);
        }
        this.mode = mode;
        this.ForbiddenValue = ForbiddenValue;
        this.fuzzystart = fuzzystart;
        this.fuzzyend = fuzzyend;
        this.step = step;
        this.matrix = null;
        int fuzzy = fuzzyend;
        int n = this.Coefficients.length - 1;
        while (fuzzystart <= fuzzy) {
            this.glr = new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy));
            this.frlm.FillMatrix(image, mask, mode, this.glr, ForbiddenValue, nbCPU);
            double[][] mat = this.frlm.matrix;
            this.glr.Kill();
            this.glr = null;
            if (this.matrix == null) {
                this.matrix = ArrayNew.Clone((double[][])mat);
            } else {
                if (this.matrix[0].length < mat[0].length) {
                    double[][] m = new double[this.matrix.length][mat[0].length];
                    ArrayNew.CopyRough((double[][])this.matrix, (double[][])m);
                    this.matrix = m;
                    m = null;
                }
                double c = this.Coefficients[n];
                for (int y = 0; y < mat.length; ++y) {
                    for (int x = 0; x < mat[0].length; ++x) {
                        double[] dArray = this.matrix[y];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + c * mat[y][x];
                    }
                }
                mat = null;
            }
            fuzzy -= step;
            --n;
        }
        this.ComputeFeatures();
    }

    public void Compute(BufferedImage image, boolean FixedSize, int nbSizes, FuzzyGLR reducer, int ForbiddenValue, Function function, int radius, boolean EightConnex, int nbCPU) {
        int GrayLevelMax;
        double[][] m = null;
        switch (image.getType()) {
            case 10: {
                int nbCoefs;
                GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                int nbCoefs;
                GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= GrayLevelMax) {
            this.frlm.FillMatrix(image, reducer, n, ForbiddenValue, function, radius, nbCPU);
            m = this.frlm.matrix;
            if (this.matrix == null) {
                int Width = m[0].length;
                this.matrix = new double[GrayLevelMax][Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            this.step = GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < this.step; ++i2) {
                        double[] dArray = this.matrix[this.step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n <<= 1;
            ++nb;
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Compute(dv, this.mode, this.ForbiddenValue, this.fuzzystart, this.fuzzyend, this.step, nbCPU);
    }

    public void Compute(DV dv, int mode, int ForbiddenValue, int fuzzystart, int fuzzyend, int step, int nbCPU) {
        if (mode == -3) {
            throw new IllegalArgumentException("Mode not supported (yet).");
        }
        double[][] mat = null;
        if (this.Coefficients == null) {
            this.AllocCoefficients((fuzzyend - fuzzystart) / step + 1);
        }
        this.mode = mode;
        this.ForbiddenValue = ForbiddenValue;
        this.fuzzystart = fuzzystart;
        this.fuzzyend = fuzzyend;
        this.step = step;
        this.matrix = null;
        int fuzzy = fuzzyend;
        int n = this.Coefficients.length - 1;
        while (fuzzystart <= fuzzy) {
            this.glr = new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy));
            this.frlm.FillMatrix(dv, mode, this.glr, ForbiddenValue, nbCPU);
            mat = this.frlm.matrix;
            this.glr.Kill();
            this.glr = null;
            if (this.matrix == null) {
                this.matrix = ArrayNew.Clone((double[][])mat);
            } else {
                if (this.matrix[0].length < mat[0].length) {
                    double[][] m = new double[this.matrix.length][mat[0].length];
                    ArrayNew.CopyRough((double[][])this.matrix, (double[][])m);
                    this.matrix = m;
                    m = null;
                }
                double c = this.Coefficients[n];
                for (int y = 0; y < mat.length; ++y) {
                    for (int x = 0; x < mat[0].length; ++x) {
                        double[] dArray = this.matrix[y];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + c * mat[y][x];
                    }
                }
                mat = null;
            }
            fuzzy -= step;
            --n;
        }
        this.ComputeFeatures();
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    public void AllocCoefficients(int size) {
        this.Coefficients = new double[size];
        Arrays.fill(this.Coefficients, 1.0);
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 6) {
            throw new IllegalArgumentException("6 parameters required.");
        }
        this.fuzzystart = (Integer)parameters[0];
        this.fuzzyend = (Integer)parameters[1];
        this.step = (Integer)parameters[2];
        this.mode = (Integer)parameters[3];
        this.ForbiddenValue = (Integer)parameters[4];
        this.Coefficients = Arrays.copyOf((double[])parameters[5], ((double[])parameters[5]).length);
    }

    private void ComputeFeatures() {
        this.Sum = this.AF.Sum(this.matrix);
        this.Features[0] = this.SZE();
        this.Features[1] = this.LZE();
        this.Features[2] = this.LGZE();
        this.Features[3] = this.HGZE();
        this.Features[4] = this.SZLGE();
        this.Features[5] = this.SZHGE();
        this.Features[6] = this.LZLGE();
        this.Features[7] = this.LZHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.SZNU();
        this.Features[10] = this.ZPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYS();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARS(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private double SZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2;
            }
        }
        return val / this.Sum;
    }

    private double HGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                val += this.matrix[n][s] * n2;
            }
        }
        return val / this.Sum;
    }

    private double SZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2 / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double SZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) / (double)(s + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(s + 1) / (double)(n + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * n2 * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            double v = 0.0;
            for (int s = 0; s < matrix1.length; ++s) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SZNU() {
        double val = 0.0;
        for (int s = 0; s < this.matrix[0].length; ++s) {
            double v = 0.0;
            for (double[] matrix1 : this.matrix) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double ZPC() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                val += (double)(s + 1) * matrix1[s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYS() {
        double mean = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                mean += (double)(s + 1) * matrix1[s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                double v = (double)(n + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARS(double mean) {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                double v = (double)(s + 1) * matrix1[s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                double m = this.matrix[n][s];
                if (Double.compare(m, 0.0) == 0) continue;
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)(n + 1) * (double)(n + 1) * m;
                m20 += (double)(s + 1) * (double)(s + 1) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = m11 / this.Sum - bgl * bs;
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + this.glr + "_FuzzyGLR_" + this.fuzzystart + "_" + this.fuzzyend + "_" + this.step;
        }
        this.glr = null;
        return names;
    }

    public void Coefficients(double[] Coefficients) {
        this.Coefficients = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public double[] Coefficients() {
        return this.Coefficients;
    }
}

