/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLM;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import mathematics.functions.Function;
import processing.reducer.FuzzyGLR;

public class FuzzyRLMfeatures
extends FuzzyRLM
implements ComputableFeatures {
    private double[] Features = new double[13];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"FuzzyRLM_SRE", "FuzzyRLM_LRE", "FuzzyRLM_GLNU", "FuzzyRLM_RLNU", "FuzzyRLM_RP", "FuzzyRLM_LGLRE", "FuzzyRLM_HGLRE", "FuzzyRLM_SRLGLE", "FuzzyRLM_SRHLGE", "FuzzyRLM_LRLGLE", "FuzzyRLM_LRHGLE", "FuzzyRLM_VAR1", "FuzzyRLM_VAR2"};

    @Override
    public synchronized void Kill() {
        super.Kill();
        this.Features = null;
        this.FeaturesNames = null;
    }

    public void Compute(BufferedImage image, int mode, FuzzyGLR reducer, int ForbiddenValue, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        this.FillMatrix(image, null, mode, reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(BufferedImage image, FuzzyGLR reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        this.FillMatrix(image, reducer, nbGrayLevel, ForbiddenValue, function, radius, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.reducer == null) {
            throw new IllegalArgumentException("Parameters must be set before the call to this method.");
        }
        if (!(this.reducer instanceof FuzzyGLR)) {
            throw new IllegalArgumentException("The last color reducer used or given in parameter is null or FuzzyGLR");
        }
        this.FillMatrix(image, mask, this.mode, this.reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(DV dv, int mode, FuzzyGLR reducer, int ForbiddenValue, int nbCPU) {
        this.FillMatrix(dv, mode, reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.reducer == null) {
            throw new IllegalArgumentException("Parameters must be set before the call to this method.");
        }
        if (!(this.reducer instanceof FuzzyGLR)) {
            throw new IllegalArgumentException("The last color reducer used or given in parameter is null or FuzzyGLR");
        }
        this.FillMatrix(dv, this.mode, this.reducer, this.ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.nbGrayLevel; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SRE();
        this.Features[1] = this.LRE();
        this.Features[2] = this.GLNU();
        this.Features[3] = this.RLNU();
        this.Features[4] = this.RP();
        this.Features[5] = this.LGLRE();
        this.Features[6] = this.HGLRE();
        this.Features[7] = this.SRLGLE();
        this.Features[8] = this.SRHGLE();
        this.Features[9] = this.LRLGLE();
        this.Features[10] = this.LRHGLE();
        this.Features[11] = this.VAR1();
        this.Features[12] = this.VAR2();
    }

    private double SRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            for (int l = 0; l < this.Width; ++l) {
                v += this.matrix[n][l];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double RLNU() {
        double val = 0.0;
        for (int l = 0; l < this.Width; ++l) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][l];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double RP() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += (double)(l + 1) * this.matrix[n][l];
            }
        }
        return this.Sum / val;
    }

    private double LGLRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGLRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SRLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / (Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SRHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow((double)(n + 1) / (double)(l + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow((double)(l + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double VAR1() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)n * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)n * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VAR2() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)l * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)l * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String glr = this.reducer.getClass().getSimpleName();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + glr + "_" + this.reducer.Bins();
        }
        glr = null;
        return names;
    }
}

