/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayOperations;
import characterization.textures.statisticalmatrices.FuzzyZone;
import characterization.textures.statisticalmatrices.FuzzyZone3D;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.functions.Function;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import processing.reducer.FuzzyGLR;

public class FuzzyRLM {
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;
    protected int nbGrayLevel = -1;
    protected int Width = -1;
    protected double[][] matrix = null;
    protected double[][] roughmatrix = null;
    protected int[] dx = new int[]{1, 1, 0, -1};
    protected int[] dy = new int[]{0, 1, 1, 1};
    protected FuzzyGLR reducer = null;
    protected int mode = -1;
    protected BufferedImage reduced = null;
    protected int[] dx3 = new int[]{-1, 0, 1, 1, -1, 0, 1, 1};
    protected int[] dy3 = new int[]{1, 1, 1, 0, 1, 1, 1, 0};
    protected int[] dz3 = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
    protected DV reduced3d = null;
    protected Function function = null;
    private int radius = -1;
    protected List<CoordinatesWeighted> se = null;
    public static final int AllPossibleFuzzyZones = -1;
    public static final int AllUniqueFuzzyZones = -2;
    public static final int BestFuzzyTexture = -3;
    public boolean AggressiveMemoryRelease = false;

    public synchronized void Kill() {
        if (this.matrix != null && this.matrix[0] != null) {
            Arrays.fill((Object[])this.matrix, null);
        }
        if (this.roughmatrix != null && this.roughmatrix[0] != null) {
            Arrays.fill((Object[])this.roughmatrix, null);
        }
        this.roughmatrix = null;
        this.matrix = null;
        if (this.reducer != null) {
            this.reducer.Kill();
        }
        this.reducer = null;
        this.dy = null;
        this.dx = null;
        this.reduced = null;
        this.dz3 = null;
        this.dy3 = null;
        this.dx3 = null;
        if (this.reduced3d != null) {
            this.reduced3d.Kill();
        }
        this.reduced3d = null;
        this.function = null;
        if (this.se != null) {
            this.se.clear();
        }
        this.se = null;
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, int mode, FuzzyGLR reducer, int ForbiddenValue, int nbCPU) {
        int x;
        int y;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.reducer = reducer;
        this.reduced = null;
        reducer.FullZoneComputation = true;
        reducer.AggressiveMemoryRelease = this.AggressiveMemoryRelease;
        this.ForbiddenValue = ForbiddenValue;
        this.Width = Math.max(image.getWidth(), image.getHeight()) + 1;
        int dim = -1;
        switch (image.getType()) {
            case 10: {
                dim = 256;
                break;
            }
            case 11: {
                dim = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.nbGrayLevel = dim;
        if (this.matrix == null || this.roughmatrix.length != dim || this.roughmatrix[0].length != this.Width) {
            this.roughmatrix = null;
            this.roughmatrix = new double[dim][this.Width];
        } else {
            ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        }
        switch (mode) {
            case -2: 
            case -1: {
                this.reduced = null;
                break;
            }
            case -3: {
                if (this.reduced != null && ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.reduced)) break;
                this.reduced = null;
                this.reduced = ImageNew.Same((BufferedImage)image);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        reducer.Reduce(image, this.reduced, ForbiddenValue, nbCPU);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.reduced, (int)0, (BufferedImage)this.reduced);
        }
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.FillMatrix(reducer.FuzzyZones(), ForbiddenValue, mode, this.dx[i2], this.dy[i2]);
        }
        int max = 0;
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        ArrayArithmetic.Divide((double[][])this.roughmatrix, (double)this.dx.length);
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.roughmatrix.length][this.Width];
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    protected void FillMatrix(List<FuzzyZone> zones, int fv, int mode, int dx, int dy) {
        int x;
        int y;
        int c;
        double[][] tampon = new double[this.roughmatrix.length][this.roughmatrix[0].length];
        ArrayOperations.Fill((double[][])tampon, (double)0.0);
        this.mode = mode;
        switch (mode) {
            case -1: {
                c = 0;
                break;
            }
            case -3: 
            case -2: {
                c = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        for (FuzzyZone fz : zones) {
            BufferedImage im = fz.Zone;
            int height = im.getHeight();
            int width = im.getWidth();
            WritableRaster wr = im.getRaster();
            if (mode == -1) {
                c = fz.Counter;
            }
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (wr.getSample(x, y, 0) == fv) continue;
                    int v0 = wr.getSample(x, y, 0);
                    int nb = 1;
                    boolean Fin = false;
                    int x1 = x;
                    int y1 = y;
                    do {
                        if ((x1 += dx) < 0 || x1 >= width) {
                            Fin = true;
                        }
                        if ((y1 += dy) < 0 || y1 >= height) {
                            Fin = true;
                        }
                        if (!Fin && wr.getSample(x1, y1, 0) != fv && wr.getSample(x1, y1, 0) == v0) {
                            ++nb;
                            continue;
                        }
                        Fin = true;
                    } while (!Fin);
                    double[] dArray = tampon[v0 - 1];
                    int n = nb;
                    dArray[n] = dArray[n] + (double)c * fz.Probability;
                }
            }
            wr = null;
            im = null;
            fz = null;
        }
        Iterator<FuzzyZone> iter = null;
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = tampon[y];
                int n = x - 1;
                dArray[n] = dArray[n] - tampon[y][x];
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = this.roughmatrix[y];
                int n = x - 1;
                dArray[n] = dArray[n] + tampon[y][x];
            }
        }
        tampon = null;
    }

    public void FillMatrix(DV dv, int mode, FuzzyGLR reducer, int ForbiddenValue, int nbCPU) {
        int x;
        int y;
        this.reducer = reducer;
        this.reduced = null;
        reducer.FullZoneComputation = true;
        reducer.AggressiveMemoryRelease = this.AggressiveMemoryRelease;
        this.ForbiddenValue = ForbiddenValue;
        this.Width = Math.max(Math.max(dv.SizeX, dv.SizeY), dv.SizeZ) + 1;
        int dim = -1;
        switch (dv.Type) {
            case 8: {
                dim = 256;
                break;
            }
            case 16: {
                dim = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Dv type not supported (yet).");
            }
        }
        this.nbGrayLevel = dim;
        if (this.matrix == null || this.roughmatrix.length != dim || this.roughmatrix[0].length != this.Width) {
            this.roughmatrix = null;
            this.roughmatrix = new double[dim][this.Width];
        } else {
            ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        }
        switch (mode) {
            case -2: 
            case -1: {
                this.reduced = null;
                break;
            }
            case -3: {
                if (this.reduced3d != null && DvTools.areDimensionsAndTypeEqual((DV)dv, (DV)this.reduced3d)) break;
                this.reduced3d = null;
                this.reduced3d = DvNew.Same((DV)dv);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        reducer.Reduce(dv, this.reduced3d, ForbiddenValue, nbCPU);
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.FillMatrix(reducer.FuzzyZones3D(), ForbiddenValue, mode, this.dx3[i2], this.dy3[i2], this.dz3[i2]);
        }
        int max = 0;
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        ArrayArithmetic.Divide((double[][])this.roughmatrix, (double)this.dx3.length);
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.roughmatrix.length][this.Width];
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    protected void FillMatrix(List<FuzzyZone3D> zones, int fv, int mode, int dx, int dy, int dz) {
        int x;
        int y;
        int c;
        double[][] tampon = new double[this.roughmatrix.length][this.roughmatrix[0].length];
        ArrayOperations.Fill((double[][])tampon, (double)0.0);
        this.mode = mode;
        switch (mode) {
            case -1: {
                c = 0;
                break;
            }
            case -3: 
            case -2: {
                c = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        for (FuzzyZone3D fz : zones) {
            DV dv = fz.Zone;
            int width = dv.SizeX;
            int height = dv.SizeY;
            int depth = dv.SizeZ;
            int offset = dx + dy * dv.SizeX + dz * dv.LayerSize;
            if (mode == -1) {
                c = fz.Counter;
            }
            switch (dv.Type) {
                case 8: {
                    byte[] bb = dv.getDataBufferByte(0);
                    int pos = 0;
                    for (int z = 0; z < depth; ++z) {
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                int v0 = bb[pos] & 0xFF;
                                if (v0 != fv) {
                                    int nb = 1;
                                    boolean Fin = false;
                                    int x1 = x;
                                    int y1 = y;
                                    int z1 = z;
                                    int p = pos;
                                    do {
                                        if ((x1 += dx) < 0 || x1 >= width) {
                                            Fin = true;
                                        }
                                        if ((y1 += dy) < 0 || y1 >= height) {
                                            Fin = true;
                                        }
                                        if ((z1 += dz) < 0 || z1 >= depth) {
                                            Fin = true;
                                        }
                                        if (!Fin && (bb[p += offset] & 0xFF) != fv && (bb[p] & 0xFF) == v0) {
                                            ++nb;
                                            continue;
                                        }
                                        Fin = true;
                                    } while (!Fin);
                                    double[] dArray = tampon[v0 - 1];
                                    int n = nb;
                                    dArray[n] = dArray[n] + (double)c * fz.Probability;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    bb = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
            fz = null;
        }
        Iterator<FuzzyZone3D> iter = null;
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = tampon[y];
                int n = x - 1;
                dArray[n] = dArray[n] - tampon[y][x];
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = this.roughmatrix[y];
                int n = x - 1;
                dArray[n] = dArray[n] + tampon[y][x];
            }
        }
        tampon = null;
    }

    public void FillMatrix(BufferedImage image, FuzzyGLR reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, int nbCPU) {
        int x;
        int y;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.CreateSE(function, radius);
        this.reducer = reducer;
        this.reduced = null;
        this.reduced = reducer.Reduce(image, nbGrayLevel, ForbiddenValue);
        this.Width = Math.max(image.getWidth(), image.getHeight()) + 1;
        this.nbGrayLevel = nbGrayLevel;
        if (this.matrix == null || this.roughmatrix.length != nbGrayLevel + 1 || this.roughmatrix[0].length != this.Width) {
            this.roughmatrix = null;
            this.roughmatrix = new double[nbGrayLevel + 1][this.Width];
        } else {
            ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        }
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.FillMatrix(0, 0, image.getWidth() - 1, image.getHeight() - 1, this.dx[i2], this.dy[i2]);
        }
        int max = 0;
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        ArrayArithmetic.Divide((double[][])this.roughmatrix, (double)this.dx.length);
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.roughmatrix.length][this.Width];
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    protected void FillMatrix(int startx, int starty, int endx, int endy, int dx, int dy) {
        int x;
        int y;
        int height = this.reduced.getHeight();
        int width = this.reduced.getWidth();
        int[][] tampon = new int[this.roughmatrix.length][this.roughmatrix[0].length];
        ArrayOperations.Fill((int[][])tampon, (int)0);
        WritableRaster wr = this.reduced.getRaster();
        CoordinatesWeighted c = null;
        for (y = starty; y <= endy; ++y) {
            for (x = startx; x <= endx; ++x) {
                if (wr.getSample(x, y, 0) == 0) continue;
                int v0 = wr.getSample(x, y, 0);
                int nb = 1;
                boolean Fin = false;
                int x1 = x;
                int y1 = y;
                do {
                    if ((x1 += dx) < 0 || x1 >= width) {
                        Fin = true;
                    }
                    if ((y1 += dy) < 0 || y1 >= height) {
                        Fin = true;
                    }
                    if (!Fin && wr.getSample(x1, y1, 0) != 0 && wr.getSample(x1, y1, 0) == v0) {
                        ++nb;
                        continue;
                    }
                    Fin = true;
                } while (!Fin);
                for (int s = 0; s < this.se.size(); ++s) {
                    c = this.se.get(s);
                    int X = nb + c.X;
                    int Y = v0 - 1 + c.Y;
                    if (0 > X || X >= tampon[0].length || 0 > Y || Y >= tampon.length) continue;
                    int[] nArray = tampon[Y];
                    int n = X;
                    nArray[n] = (int)((double)nArray[n] + c.Wd);
                }
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                int[] nArray = tampon[y];
                int n = x - 1;
                nArray[n] = nArray[n] - tampon[y][x];
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = this.roughmatrix[y];
                int n = x - 1;
                dArray[n] = dArray[n] + (double)tampon[y][x];
            }
        }
        tampon = null;
        wr = null;
    }

    private void CreateSE(Function function, int radius) {
        if (this.function != null && this.function.equals(function) && this.radius == radius) {
            return;
        }
        double[] arg = new double[1];
        Euclidian metric = new Euclidian();
        this.se = new ArrayList<CoordinatesWeighted>((radius + 1) * (radius + 1));
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                arg[0] = metric.Distance((double)x, (double)y, 0.0, 0.0, 0.0, 0.0);
                double v = function.Compute(arg);
                if (Double.compare(0.0, v) == 0) continue;
                this.se.add(new CoordinatesWeighted(x, y, 0, -1, v));
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.mode = (Integer)parameters[0];
        this.reducer = (FuzzyGLR)parameters[1];
        this.ForbiddenValue = (Integer)parameters[2];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.matrix.length * this.matrix[0].length * 3);
        for (int j = 0; j < this.matrix.length; ++j) {
            for (int i2 = 0; i2 < this.matrix[0].length; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

