/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.glm;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.Maths;
import processing.reducer.ColorReducer;

public class GrayLevelGapLengthMatrix {
    protected int nbGrayLevel = -1;
    protected double[][] matrix = null;
    protected double[][] roughmatrix = null;
    protected int[] dx;
    protected int[] dy;
    private final ArrayFeatures AF = new ArrayFeatures();

    public void setDirection(int DX, int DY) {
        if (this.dx == null || this.dx.length != 1) {
            this.dy = null;
            this.dx = null;
            this.dx = new int[1];
            this.dy = new int[1];
        }
        this.dx[0] = DX;
        this.dy[0] = DY;
    }

    public void setDirections(int[] dx, int[] dy) {
        if (dx.length != dy.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (this.AF.Minimum(dx) < -1 || 1 < this.AF.Maximum(dx)) {
            throw new IllegalArgumentException("Displacements must be in [-1,1].");
        }
        if (this.AF.Minimum(dy) < -1 || 1 < this.AF.Maximum(dy)) {
            throw new IllegalArgumentException("Displacements must be in [-1,1].");
        }
        this.dx = null;
        this.dy = null;
        this.dx = Arrays.copyOf(dx, dx.length);
        this.dy = Arrays.copyOf(dy, dy.length);
    }

    public void Fill(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy) {
        this.setDirections(dx, dy);
        this.Fill(image, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy) {
        this.setDirection(dx, dy);
        this.Fill(image, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue) {
        int x;
        int y;
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("nbGrayLevel is not diadic.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacement given.");
        }
        int roughwidth = Math.max(image.getWidth(), image.getHeight());
        if (this.roughmatrix == null || nbGrayLevel != this.nbGrayLevel) {
            this.roughmatrix = null;
            this.roughmatrix = new double[nbGrayLevel + 1][roughwidth];
        }
        ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        BufferedImage reduced = reducer.Reduce(image, nbGrayLevel, ForbiddenValue);
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.computeMatrix(reduced, this.dx[i2], this.dy[i2], ForbiddenValue);
        }
        int max = 0;
        int width = 0;
        for (y = 0; y < nbGrayLevel; ++y) {
            for (x = 0; x < roughwidth; ++x) {
                if (!(0.0 < this.roughmatrix[y][x]) || max >= x) continue;
                max = x;
            }
        }
        if (this.matrix == null || nbGrayLevel != this.nbGrayLevel || this.roughmatrix[0].length != max + 1) {
            this.nbGrayLevel = nbGrayLevel;
            width = max + 1;
            this.matrix = null;
            this.matrix = new double[nbGrayLevel + 1][max + 1];
        }
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        for (y = 0; y < nbGrayLevel; ++y) {
            for (x = 0; x < width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
        if (1 < this.dx.length) {
            ArrayArithmetic.Divide((double[][])this.matrix, (double)this.dx.length);
        }
        reduced = null;
    }

    private void computeMatrix(BufferedImage reduced, int dx, int dy, int ForbiddenValue) {
        int height = reduced.getHeight();
        int width = reduced.getWidth();
        WritableRaster wr = reduced.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int v0 = wr.getSample(x, y, 0);
                if (v0 == ForbiddenValue) continue;
                int nb = 1;
                boolean end = false;
                int x1 = x;
                int y1 = y;
                do {
                    if ((x1 += dx) < 0 || width <= x1) {
                        end = true;
                        nb = 0;
                    }
                    if ((y1 += dy) < 0 || height <= y1) {
                        end = true;
                        nb = 0;
                    }
                    if (!end && wr.getSample(x1, y1, 0) != v0) {
                        ++nb;
                        continue;
                    }
                    end = true;
                } while (!end);
                if (true >= nb) continue;
                double[] dArray = this.roughmatrix[v0];
                int n = nb;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        wr = null;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public int[] getDx() {
        return this.dx;
    }

    public int[] getDy() {
        return this.dy;
    }
}

