/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.glm;

import arrayTiTi.ArrayFeatures;
import characterization.textures.statisticalmatrices.glm.GrayLevelGapLengthMatrix;
import java.awt.image.BufferedImage;
import processing.reducer.ColorReducer;

public class GlglmFeatures
extends GrayLevelGapLengthMatrix {
    private final double[] Features = new double[13];
    private double Sum = 0.0;
    private double Width;
    private final String[] FeaturesNames = new String[]{"SGE", "LGE", "GLNU", "GNU", "GP", "LGLGE", "HGLGE", "SGLGLE", "SGHLGE", "LGLGLE", "LGHGLE", "VAR1", "VAR2"};
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Compute(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy) {
        this.Fill(image, reducer, nbGrayLevel, ForbiddenValue, dx, dy);
        this.ComputeFeatures();
    }

    public void Compute(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy) {
        this.Fill(image, reducer, nbGrayLevel, ForbiddenValue, dx, dy);
        this.ComputeFeatures();
    }

    public void ComputeFromStack(BufferedImage[] images, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy, int nbCPU) {
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (BufferedImage image : images) {
            this.Compute(image, reducer, nbGrayLevel, ForbiddenValue, dx, dy);
            for (int j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (int j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    private void ComputeFeatures() {
        this.Sum = this.AF.Sum(this.matrix);
        this.Width = this.matrix[0].length;
        this.Features[0] = this.SGE();
        this.Features[1] = this.LGE();
        this.Features[2] = this.GLNU();
        this.Features[3] = this.GNU();
        this.Features[4] = this.GP();
        this.Features[5] = this.LGLGE();
        this.Features[6] = this.HGLGE();
        this.Features[7] = this.SGLGLE();
        this.Features[8] = this.SGHGLE();
        this.Features[9] = this.LGLGLE();
        this.Features[10] = this.LGHGLE();
        this.Features[11] = this.VAR1();
        this.Features[12] = this.VAR2();
    }

    private double SGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] / Math.pow(l + 1, 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double LGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] * Math.pow(l + 1, 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            int l = 0;
            while ((double)l < this.Width) {
                v += this.matrix[n][l];
                ++l;
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double GNU() {
        double val = 0.0;
        int l = 0;
        while ((double)l < this.Width) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][l];
            }
            val += v * v;
            ++l;
        }
        return val / this.Sum;
    }

    private double GP() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += (double)(l + 1) * this.matrix[n][l];
                ++l;
            }
        }
        return this.Sum / val;
    }

    private double LGLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] / Math.pow(n + 1, 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double HGLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double SGLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] / (Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0));
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double SGHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] * Math.pow((double)(n + 1) / (double)(l + 1), 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double LGLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] * Math.pow((double)(l + 1) / (double)(n + 1), 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double LGHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            int l = 0;
            while ((double)l < this.Width) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0);
                ++l;
            }
        }
        return val / this.Sum;
    }

    private double VAR1() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            l = 0;
            while ((double)l < this.Width) {
                mean += (double)n * this.matrix[n][l];
                ++l;
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            l = 0;
            while ((double)l < this.Width) {
                val += Math.pow((double)n * this.matrix[n][l] - mean, 2.0);
                ++l;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VAR2() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            l = 0;
            while ((double)l < this.Width) {
                mean += (double)l * this.matrix[n][l];
                ++l;
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            l = 0;
            while ((double)l < this.Width) {
                val += Math.pow((double)l * this.matrix[n][l] - mean, 2.0);
                ++l;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    public double[] Features() {
        return this.Features;
    }

    public double Feature(int i2) {
        if (i2 < 0 || i2 >= this.Features.length) {
            throw new Error("Numero de RLM's Features incorrect : " + i2 + ", attendu [0.." + (this.Features.length - 1) + "].");
        }
        return this.Features[i2];
    }

    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }
}

