/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.com;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.com.CooccurrenceMatrix;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import mathematics.functions.Function;
import processing.reducer.ColorReducer;

public class Haralick
extends CooccurrenceMatrix
implements ComputableFeatures {
    private double[] px = null;
    private double[] py = null;
    private double[] px_y = null;
    private double[] pxy = null;
    private double HX;
    private double HY;
    private double HXY;
    private double HXY1;
    private double HXY2;
    private double[] features = new double[17];
    private String[] FeaturesNames = new String[]{"Haralick_F0_Mean", "Haralick_F1_Second_Angular_Momentum", "Haralick_F2_Contrast", "Haralick_F3_Correlation", "Haralick_F4_Variance", "Haralick_F5_Inverse_Differences_Momentum", "Haralick_F6_Average_Sums", "Haralick_F7_Variances_Sums", "Haralick_F8_Entropy_Sums", "Haralick_F9_Entropy", "Haralick_F10_Variances_Differences", "Haralick_F11_Entropy_Differences", "Haralick_F12", "Haralick_F13", "Haralick_F14_Dissimilarity", "Haralick_F15_Homogeneity", "Haralick_F16_Inertia"};

    @Override
    public synchronized void Kill() {
        this.px_y = null;
        this.pxy = null;
        this.py = null;
        this.px = null;
        this.matrix = null;
        this.dy = null;
        this.dx = null;
        this.reducer = null;
        this.reduced = null;
        if (this.reduced3d != null) {
            this.reduced3d.Kill();
        }
        this.reduced3d = null;
        this.dz3 = null;
        this.dy3 = null;
        this.dx3 = null;
        this.features = null;
        this.FeaturesNames = null;
        if (this.se != null) {
            this.se.clear();
        }
        this.se = null;
        this.function = null;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.reducer == null) {
            throw new IllegalArgumentException("Any color reducer defined.");
        }
        if (this.nbGrayLevel <= 0) {
            throw new IllegalArgumentException("nbGrayLevel not defined.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacements/delta defined.");
        }
        this.Compute(image, mask, this.reducer, this.nbGrayLevel, ForbiddenValue, this.dx, this.dy);
    }

    public void Compute(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy) {
        this.setDirections(dx, dy);
        this.Compute(image, mask, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Compute(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy) {
        this.setDirection(dx, dy);
        this.Compute(image, mask, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Compute(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue) {
        this.Fill(image, mask, reducer, nbGrayLevel, ForbiddenValue);
        Arrays.fill(this.features, 0.0);
        this.precomputation();
        this.features[0] = this.features[0] + this.Moyenne();
        this.features[1] = this.features[1] + this.getF1();
        this.features[2] = this.features[2] + this.getF2();
        this.features[3] = this.features[3] + this.getF3();
        this.features[4] = this.features[4] + this.getF4(this.features[0]);
        this.features[5] = this.features[5] + this.getF5();
        this.features[6] = this.features[6] + this.getF6();
        this.features[7] = this.features[7] + this.getF7(this.features[6]);
        this.features[8] = this.features[8] + this.getF8();
        this.features[9] = this.features[9] + this.getF9();
        this.features[10] = this.features[10] + this.getF10();
        this.features[11] = this.features[11] + this.getF11();
        this.features[12] = this.features[12] + this.getF12();
        this.features[13] = this.features[13] + this.getF13();
        this.features[14] = this.features[14] + this.Dissimilarite();
        this.features[15] = this.features[15] + this.Homogeneite();
        this.features[16] = this.features[16] + this.Inertie();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.reducer == null) {
            throw new IllegalArgumentException("Any color reducer defined.");
        }
        if (this.nbGrayLevel <= 0) {
            throw new IllegalArgumentException("nbGrayLevel not defined.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacements/delta defined.");
        }
        this.Compute(dv, this.reducer, this.nbGrayLevel, this.ForbiddenValue, this.dx3, this.dy3, this.dz3);
    }

    public void Compute(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy, int[] dz) {
        this.setDirections(dx, dy, dz);
        this.Compute(dv, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Compute(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy, int dz) {
        this.setDirection(dx, dy, dz);
        this.Compute(dv, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Compute(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue) {
        this.Fill(dv, reducer, nbGrayLevel, ForbiddenValue);
        Arrays.fill(this.features, 0.0);
        this.precomputation();
        this.features[0] = this.features[0] + this.Moyenne();
        this.features[1] = this.features[1] + this.getF1();
        this.features[2] = this.features[2] + this.getF2();
        this.features[3] = this.features[3] + this.getF3();
        this.features[4] = this.features[4] + this.getF4(this.features[0]);
        this.features[5] = this.features[5] + this.getF5();
        this.features[6] = this.features[6] + this.getF6();
        this.features[7] = this.features[7] + this.getF7(this.features[6]);
        this.features[8] = this.features[8] + this.getF8();
        this.features[9] = this.features[9] + this.getF9();
        this.features[10] = this.features[10] + this.getF10();
        this.features[11] = this.features[11] + this.getF11();
        this.features[12] = this.features[12] + this.getF12();
        this.features[13] = this.features[13] + this.getF13();
        this.features[14] = this.features[14] + this.Dissimilarite();
        this.features[15] = this.features[15] + this.Homogeneite();
        this.features[16] = this.features[16] + this.Inertie();
    }

    public void Compute(BufferedImage image, Function function, int radius, int nbCPU) {
        if (this.reducer == null) {
            throw new IllegalArgumentException("Any color reducer defined.");
        }
        if (this.nbGrayLevel <= 0) {
            throw new IllegalArgumentException("nbGrayLevel not defined.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacements/delta defined.");
        }
        this.Compute(image, this.reducer, this.nbGrayLevel, this.ForbiddenValue, this.dx, this.dy, function, radius);
    }

    public void Compute(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy, Function function, int radius) {
        this.setDirections(dx, dy);
        this.Compute(image, reducer, nbGrayLevel, ForbiddenValue, function, radius);
    }

    public void Compute(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy, Function function, int radius) {
        this.setDirection(dx, dy);
        this.Compute(image, reducer, nbGrayLevel, ForbiddenValue, function, radius);
    }

    public void Compute(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius) {
        this.Fill(image, reducer, nbGrayLevel, ForbiddenValue, function, radius);
        Arrays.fill(this.features, 0.0);
        this.precomputation();
        this.features[0] = this.features[0] + this.Moyenne();
        this.features[1] = this.features[1] + this.getF1();
        this.features[2] = this.features[2] + this.getF2();
        this.features[3] = this.features[3] + this.getF3();
        this.features[4] = this.features[4] + this.getF4(this.features[0]);
        this.features[5] = this.features[5] + this.getF5();
        this.features[6] = this.features[6] + this.getF6();
        this.features[7] = this.features[7] + this.getF7(this.features[6]);
        this.features[8] = this.features[8] + this.getF8();
        this.features[9] = this.features[9] + this.getF9();
        this.features[10] = this.features[10] + this.getF10();
        this.features[11] = this.features[11] + this.getF11();
        this.features[12] = this.features[12] + this.getF12();
        this.features[13] = this.features[13] + this.getF13();
        this.features[14] = this.features[14] + this.Dissimilarite();
        this.features[15] = this.features[15] + this.Homogeneite();
        this.features[16] = this.features[16] + this.Inertie();
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void precomputation() {
        int i2;
        if (this.px == null || this.px.length != this.MSIZE) {
            this.px = new double[this.MSIZE];
            this.py = new double[this.MSIZE];
            this.px_y = new double[this.MSIZE];
            this.pxy = new double[2 * this.MSIZE];
        }
        Arrays.fill(this.px, 0.0);
        Arrays.fill(this.py, 0.0);
        Arrays.fill(this.px_y, 0.0);
        Arrays.fill(this.pxy, 0.0);
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i3 = 0; i3 < this.MSIZE; ++i3) {
                double pij = this.matrix[i3][j];
                int n = i3 + j;
                this.pxy[n] = this.pxy[n] + pij;
                int n2 = Math.abs(i3 - j);
                this.px_y[n2] = this.px_y[n2] + pij;
                int n3 = j;
                this.py[n3] = this.py[n3] + pij;
            }
        }
        for (i2 = 0; i2 < this.MSIZE; ++i2) {
            for (int j = 0; j < this.MSIZE; ++j) {
                int n = i2;
                this.px[n] = this.px[n] + this.matrix[i2][j];
            }
        }
        this.HY = 0.0;
        this.HX = 0.0;
        for (i2 = 0; i2 < this.MSIZE; ++i2) {
            double xp = this.px[i2];
            double logxp = Double.compare(xp, 0.0) == 0 ? 0.0 : Math.log(xp);
            this.HX -= xp * logxp;
            double yp = this.py[i2];
            double logyp = Double.compare(yp, 0.0) == 0 ? 0.0 : Math.log(yp);
            this.HY -= yp * logyp;
        }
        this.HXY2 = 0.0;
        this.HXY1 = 0.0;
        this.HXY = 0.0;
        for (i2 = 0; i2 < this.MSIZE; ++i2) {
            for (int j = 0; j < this.MSIZE; ++j) {
                double m = this.matrix[i2][j];
                double logm = Double.compare(m, 0.0) == 0 ? 0.0 : Math.log(m);
                this.HXY -= m * logm;
                double pxpy = this.px[i2] * this.py[j];
                double logpxpy = Double.compare(pxpy, 0.0) == 0 ? 0.0 : Math.log(pxpy);
                this.HXY1 -= m * logpxpy;
                this.HXY2 -= pxpy * logpxpy;
            }
        }
    }

    private double Moyenne() {
        int nb = 0;
        double mean = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                if (!(this.matrix[i2][j] > 0.0)) continue;
                mean += this.matrix[i2][j];
                ++nb;
            }
        }
        return mean / (double)nb;
    }

    private double getF1() {
        double h = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                h += Math.pow(this.matrix[i2][j], 2.0);
            }
        }
        return h;
    }

    private double getF2() {
        double contrast = 0.0;
        for (int n = 0; n < this.MSIZE; ++n) {
            for (int j = 0; j < this.MSIZE; ++j) {
                for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                    if (Math.abs(i2 - j) != n) continue;
                    contrast += Math.pow(n, 2.0) * this.matrix[i2][j];
                }
            }
        }
        return contrast;
    }

    private double getF3() {
        int j;
        int i2;
        double md_mean = 0.0;
        for (i2 = 0; i2 < this.MSIZE; ++i2) {
            for (j = 0; j < this.MSIZE; ++j) {
                md_mean += (double)i2 * this.matrix[i2][j];
            }
        }
        double md_var = 0.0;
        for (i2 = 0; i2 < this.MSIZE; ++i2) {
            for (j = 0; j < this.MSIZE; ++j) {
                md_var += this.matrix[i2][j] * ((double)i2 - md_mean) * ((double)i2 - md_mean);
            }
        }
        if (md_var <= 0.0) {
            return 1.0;
        }
        double summ = 0.0;
        for (j = 0; j < this.MSIZE; ++j) {
            for (i2 = 0; i2 < this.MSIZE; ++i2) {
                summ += this.matrix[i2][j] * ((double)i2 - md_mean) * ((double)j - md_mean);
            }
        }
        return summ / (md_var * md_var);
    }

    private double getF4(double mean) {
        double variance = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                variance += Math.pow((double)i2 - mean, 2.0) * this.matrix[i2][j];
            }
        }
        return variance;
    }

    private double getF5() {
        double invdiff = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                double coef = 1.0 / (1.0 + Math.pow(i2 - j, 2.0));
                invdiff += coef * this.matrix[i2][j];
            }
        }
        return invdiff;
    }

    private double getF6() {
        double sumavg = 0.0;
        for (int k = 0; k <= 2 * (this.MSIZE - 1); ++k) {
            sumavg += (double)k * this.pxy[k];
        }
        return sumavg;
    }

    private double getF7(double f6) {
        double sumvar = 0.0;
        for (int k = 0; k <= 2 * (this.MSIZE - 1); ++k) {
            sumvar += Math.pow((double)k - f6, 2.0) * this.pxy[k];
        }
        return sumvar;
    }

    private double getF8() {
        double entropysrc = 0.0;
        for (int k = 0; k <= 2 * (this.MSIZE - 1); ++k) {
            if (this.pxy[k] == 0.0) continue;
            entropysrc += this.pxy[k] * Math.log(this.pxy[k]);
        }
        return -entropysrc;
    }

    private double getF9() {
        return this.HXY;
    }

    private double getF10() {
        int k;
        double mean = 0.0;
        for (k = 0; k < this.MSIZE - 1; ++k) {
            mean += (double)k * this.px_y[k];
        }
        double var = 0.0;
        for (k = 0; k < this.MSIZE - 1; ++k) {
            var += Math.pow((double)k - mean, 2.0) * this.px_y[k];
        }
        return var;
    }

    private double getF11() {
        double entropydiff = 0.0;
        for (int k = 0; k < this.MSIZE - 1; ++k) {
            if (this.px_y[k] == 0.0) continue;
            entropydiff += this.px_y[k] * Math.log(this.px_y[k]);
        }
        return -entropydiff;
    }

    private double getF12() {
        return (this.HXY - this.HXY1) / Math.max(this.HX, this.HY);
    }

    private double getF13() {
        return Math.sqrt(1.0 - Math.exp(-2.0 * Math.abs(this.HXY2 - this.HXY)));
    }

    private double Homogeneite() {
        double homogeneity = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                homogeneity += this.matrix[i2][j] / (1.0 + (double)Math.abs(i2 - j));
            }
        }
        return homogeneity;
    }

    private double Dissimilarite() {
        double dissimilarity = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                dissimilarity += this.matrix[i2][j] * (double)Math.abs(i2 - j);
            }
        }
        return dissimilarity;
    }

    private double Inertie() {
        double inertie = 0.0;
        for (int j = 0; j < this.MSIZE; ++j) {
            for (int i2 = 0; i2 < this.MSIZE; ++i2) {
                inertie += this.matrix[i2][j] * Math.pow(i2 - j, 2.0);
            }
        }
        return inertie;
    }

    @Override
    public double[] Features() {
        return this.features;
    }

    @Override
    public double Feature(int i2) {
        return this.features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String glr = this.reducer.getClass().getSimpleName();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + glr + "_" + this.reducer.Bins();
        }
        glr = null;
        return names;
    }
}

