/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.com;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayOperations;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.Maths;
import mathematics.functions.Function;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;

public class CooccurrenceMatrix {
    protected int MSIZE = -1;
    protected double[][] matrix = null;
    protected int[] dx = new int[]{-1, 0, 1, 1};
    protected int[] dy = new int[]{1, 1, 1, 0};
    protected ColorReducer reducer = null;
    protected BufferedImage reduced = null;
    protected int ForbiddenValue = -1;
    protected int nbGrayLevel = -1;
    protected double Sum;
    protected double sum;
    protected Function function = null;
    private int radius = -1;
    protected List<CoordinatesWeighted> se = null;
    protected int[] dx3 = new int[]{-1, 0, 1, 1, -1, 0, 1, 1};
    protected int[] dy3 = new int[]{1, 1, 1, 0, 1, 1, 1, 0};
    protected int[] dz3 = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
    protected DV reduced3d = null;

    public void setDirection(int DX, int DY) {
        if (this.dx.length != 1) {
            this.dy = null;
            this.dx = null;
            this.dx = new int[1];
            this.dy = new int[1];
        }
        this.dx[0] = DX;
        this.dy[0] = DY;
    }

    public void setDirection(int DX, int DY, int DZ) {
        if (this.dx3.length != 1) {
            this.dz3 = null;
            this.dy3 = null;
            this.dx3 = null;
            this.dx3 = new int[1];
            this.dy3 = new int[1];
            this.dz3 = new int[1];
        }
        this.dx3[0] = DX;
        this.dy3[0] = DY;
        this.dz3[0] = DZ;
    }

    public void setDirections(int[] dx, int[] dy) {
        if (dx.length != dy.length) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        this.dx = null;
        this.dy = null;
        this.dx = Arrays.copyOf(dx, dx.length);
        this.dy = Arrays.copyOf(dy, dy.length);
    }

    public void setDirections(int[] dx, int[] dy, int[] dz) {
        if (this.dx3.length != this.dy3.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (this.dx3.length != this.dz3.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        this.dx3 = null;
        this.dy3 = null;
        this.dz3 = null;
        this.dx3 = Arrays.copyOf(dx, dx.length);
        this.dy3 = Arrays.copyOf(dy, dy.length);
        this.dz3 = Arrays.copyOf(dz, dz.length);
    }

    public void Fill(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy) {
        this.setDirections(dx, dy);
        this.Fill(image, mask, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy) {
        this.setDirection(dx, dy);
        this.Fill(image, mask, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(BufferedImage image, BufferedImage mask, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacement defined.");
        }
        if (this.reduced == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.reduced)) {
            this.reduced = null;
            this.reduced = ImageNew.Same((BufferedImage)image);
        }
        this.reducer = reducer;
        int dim = -1;
        boolean fuzzy = reducer instanceof FuzzyGLR;
        if (!fuzzy) {
            if (Maths.isDyadic((int)nbGrayLevel) == -1) {
                throw new IllegalArgumentException("nbGrayLevel is not diadic.");
            }
            dim = nbGrayLevel;
        } else {
            switch (image.getType()) {
                case 10: {
                    dim = 256;
                    break;
                }
                case 11: {
                    dim = 65536;
                    break;
                }
            }
        }
        if (this.matrix == null || nbGrayLevel != this.MSIZE) {
            this.MSIZE = dim;
            this.matrix = null;
            this.matrix = new double[this.MSIZE][this.MSIZE];
            this.nbGrayLevel = nbGrayLevel;
        } else {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        }
        if (reducer instanceof FuzzyGLR) {
            reducer.Reduce(image, this.reduced, ForbiddenValue, 1);
        } else {
            reducer.Reduce(image, this.reduced, nbGrayLevel, ForbiddenValue);
        }
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.reduced, (int)0, (BufferedImage)this.reduced);
        }
        this.Sum = 0.0;
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.computeMatrix(this.reduced, this.dx[i2], this.dy[i2], ForbiddenValue);
        }
        ArrayArithmetic.Divide((double[][])this.matrix, (double)(this.Sum * (double)this.dx.length), (double[][])this.matrix);
    }

    private void computeMatrix(BufferedImage reduced, int dx, int dy, int ForbiddenValue) {
        int height = reduced.getHeight();
        int width = reduced.getWidth();
        int delta = ForbiddenValue < 0 ? 0 : 1;
        this.sum = 0.0;
        switch (reduced.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)reduced.getRaster().getDataBuffer()).getData();
                int offset = dx + dy * width;
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v1;
                        int y1;
                        int x1;
                        int v0 = bbin[pos] & 0xFF;
                        if (v0 != ForbiddenValue && (x1 = x + dx) >= 0 && width > x1 && (y1 = y + dy) >= 0 && height > y1 && (v1 = bbin[offset] & 0xFF) != ForbiddenValue) {
                            double[] dArray = this.matrix[v0 - delta];
                            int n = v1 - delta;
                            dArray[n] = dArray[n] + 1.0;
                            double[] dArray2 = this.matrix[v1 - delta];
                            int n2 = v0 - delta;
                            dArray2[n2] = dArray2[n2] + 1.0;
                            this.sum += 2.0;
                        }
                        ++x;
                        ++pos;
                        ++offset;
                    }
                }
                bbin = null;
                break;
            }
            default: {
                WritableRaster wr = reduced.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int y1;
                        if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                        int v0 = wr.getSample(x, y, 0);
                        int x1 = x + dx;
                        if (x1 < 0 || x1 >= width || (y1 = y + dy) < 0 || y1 >= height || wr.getSample(x1, y1, 0) == ForbiddenValue) continue;
                        int v1 = wr.getSample(x1, y1, 0);
                        double[] dArray = this.matrix[v0 - delta];
                        int n = v1 - delta;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray3 = this.matrix[v1 - delta];
                        int n3 = v0 - delta;
                        dArray3[n3] = dArray3[n3] + 1.0;
                        this.sum += 2.0;
                    }
                }
                wr = null;
            }
        }
        this.Sum += this.sum;
    }

    public void Fill(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int[] dx, int[] dy, int[] dz) {
        this.setDirections(dx, dy, dz);
        this.Fill(dv, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, int dx, int dy, int dz) {
        this.setDirection(dx, dy, dz);
        this.Fill(dv, reducer, nbGrayLevel, ForbiddenValue);
    }

    public void Fill(DV dv, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue) {
        if (this.dx3 == null) {
            throw new IllegalArgumentException("Any displacement defined.");
        }
        if (this.reduced3d == null || !DvTools.areDimensionsAndTypeEqual((DV)dv, (DV)this.reduced3d)) {
            this.reduced3d = null;
            this.reduced3d = DvNew.Same((DV)dv);
        }
        this.reducer = reducer;
        int dim = -1;
        boolean fuzzy = reducer instanceof FuzzyGLR;
        if (!fuzzy) {
            if (Maths.isDyadic((int)nbGrayLevel) == -1) {
                throw new IllegalArgumentException("nbGrayLevel is not diadic.");
            }
            dim = nbGrayLevel;
        } else {
            switch (dv.Type) {
                case 8: {
                    dim = 256;
                    break;
                }
                case 16: {
                    dim = 65536;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
        }
        if (this.matrix == null || nbGrayLevel != this.MSIZE) {
            this.MSIZE = dim;
            this.matrix = null;
            this.matrix = new double[this.MSIZE][this.MSIZE];
            this.nbGrayLevel = nbGrayLevel;
        } else {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        }
        if (reducer instanceof FuzzyGLR) {
            reducer.Reduce(dv, this.reduced3d, ForbiddenValue, 1);
        } else {
            reducer.Reduce(dv, this.reduced3d, nbGrayLevel, ForbiddenValue);
        }
        this.Sum = 0.0;
        for (int i2 = 0; i2 < this.dx3.length; ++i2) {
            this.FillMatrix(this.reduced3d, this.dx3[i2], this.dy3[i2], this.dz3[i2], ForbiddenValue);
        }
        ArrayArithmetic.Divide((double[][])this.matrix, (double)(this.Sum * (double)this.dx3.length), (double[][])this.matrix);
    }

    private void FillMatrix(DV dv, int dx, int dy, int dz, int ForbiddenValue) {
        int width = dv.SizeX;
        int height = dv.SizeY;
        int depth = dv.SizeZ;
        int delta = ForbiddenValue < 0 ? 0 : 1;
        this.sum = 0.0;
        switch (this.reduced3d.Type) {
            case 8: {
                byte[] bbin = this.reduced3d.getDataBufferByte(0);
                int offset = dx + dy * width + dz * dv.LayerSize;
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            int v1;
                            int z1;
                            int y1;
                            int x1;
                            int v0 = bbin[pos] & 0xFF;
                            if (v0 != ForbiddenValue && (x1 = x + dx) >= 0 && width > x1 && (y1 = y + dy) >= 0 && height > y1 && (z1 = z + dz) >= 0 && depth > z1 && (v1 = bbin[offset] & 0xFF) != ForbiddenValue) {
                                double[] dArray = this.matrix[v0 - delta];
                                int n = v1 - delta;
                                dArray[n] = dArray[n] + 1.0;
                                double[] dArray2 = this.matrix[v1 - delta];
                                int n2 = v0 - delta;
                                dArray2[n2] = dArray2[n2] + 1.0;
                                this.sum += 2.0;
                            }
                            ++x;
                            ++pos;
                            ++offset;
                        }
                    }
                }
                bbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.Sum += this.sum;
    }

    public void Fill(BufferedImage image, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("nbGrayLevel is not diadic.");
        }
        if (this.dx == null) {
            throw new IllegalArgumentException("Any displacement defined.");
        }
        this.CreateSE(function, radius);
        if (this.matrix == null || nbGrayLevel != this.MSIZE) {
            this.MSIZE = nbGrayLevel;
            this.matrix = null;
            this.matrix = new double[this.MSIZE][this.MSIZE];
            this.nbGrayLevel = nbGrayLevel;
        }
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        if (this.reduced == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.reduced)) {
            this.reduced = null;
            this.reduced = ImageNew.Same((BufferedImage)image);
        }
        this.reducer = reducer;
        switch (image.getType()) {
            case 10: 
            case 11: {
                reducer.Reduce(image, this.reduced, nbGrayLevel, ForbiddenValue);
                break;
            }
        }
        this.Sum = 0.0;
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.computeFuzzyMatrix(this.reduced, this.dx[i2], this.dy[i2], ForbiddenValue);
        }
        ArrayArithmetic.Divide((double[][])this.matrix, (double)(this.Sum * (double)this.dx.length), (double[][])this.matrix);
    }

    private void computeFuzzyMatrix(BufferedImage reduced, int dx, int dy, int ForbiddenValue) {
        int height = reduced.getHeight();
        int width = reduced.getWidth();
        int delta = ForbiddenValue < 0 ? 0 : 1;
        CoordinatesWeighted c = null;
        this.sum = 0.0;
        switch (reduced.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)reduced.getRaster().getDataBuffer()).getData();
                int offset = dx + dy * width;
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v1;
                        int y1;
                        int x1;
                        int v0 = bbin[pos] & 0xFF;
                        if (v0 != ForbiddenValue && (x1 = x + dx) >= 0 && width > x1 && (y1 = y + dy) >= 0 && height > y1 && (v1 = bbin[offset] & 0xFF) != ForbiddenValue) {
                            v0 -= delta;
                            v1 -= delta;
                            for (int s = 0; s < this.se.size(); ++s) {
                                c = this.se.get(s);
                                int X = v0 + c.X;
                                int Y = v1 + c.Y;
                                if (0 > X || X >= this.MSIZE || 0 > Y || Y >= this.MSIZE) continue;
                                double[] dArray = this.matrix[Y];
                                int n = X;
                                dArray[n] = dArray[n] + c.Wd;
                                double[] dArray2 = this.matrix[X];
                                int n2 = Y;
                                dArray2[n2] = dArray2[n2] + c.Wd;
                                this.sum += 2.0 * c.Wd;
                            }
                        }
                        ++x;
                        ++pos;
                        ++offset;
                    }
                }
                bbin = null;
                break;
            }
            default: {
                WritableRaster wr = reduced.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int v1;
                        int y1;
                        int x1;
                        int v0 = wr.getSample(x, y, 0);
                        if (v0 == ForbiddenValue || (x1 = x + dx) < 0 || x1 >= width || (y1 = y + dy) < 0 || y1 >= height || (v1 = wr.getSample(x1, y1, 0)) == ForbiddenValue) continue;
                        v0 -= delta;
                        v1 -= delta;
                        for (int s = 0; s < this.se.size(); ++s) {
                            c = this.se.get(s);
                            int X = v0 + c.X;
                            int Y = v1 + c.Y;
                            if (0 > X || X >= this.MSIZE || 0 > Y || Y >= this.MSIZE) continue;
                            double[] dArray = this.matrix[Y];
                            int n = X;
                            dArray[n] = dArray[n] + c.Wd;
                            double[] dArray3 = this.matrix[X];
                            int n3 = Y;
                            dArray3[n3] = dArray3[n3] + c.Wd;
                            this.sum += 2.0 * c.Wd;
                        }
                        this.sum += 2.0;
                    }
                }
                wr = null;
            }
        }
        this.Sum += this.sum;
    }

    private void CreateSE(Function function, int radius) {
        if (this.function != null && this.function.equals(function) && this.radius == radius) {
            return;
        }
        double[] arg = new double[1];
        Euclidian metric = new Euclidian();
        this.se = new ArrayList<CoordinatesWeighted>((radius + 1) * (radius + 1));
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                arg[0] = metric.Distance((double)x, (double)y, 0.0, 0.0, 0.0, 0.0);
                double v = function.Compute(arg);
                if (0 >= Double.compare(v, 0.0)) continue;
                this.se.add(new CoordinatesWeighted(x, y, 0, -1, v));
            }
        }
    }

    public int getMSIZE() {
        return this.MSIZE;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public int[] getDx() {
        return this.dx;
    }

    public int[] getDy() {
        return this.dy;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3 && parameters.length != 5) {
            throw new IllegalArgumentException("Exactly 3 or 5 parameters required.");
        }
        this.reducer = (ColorReducer)parameters[0];
        this.nbGrayLevel = (Integer)parameters[1];
        if (this.nbGrayLevel <= 0 || !Maths.isPowerOf((int)this.nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("nbGrayLevel (parameter 1) is not dyadic.");
        }
        this.ForbiddenValue = (Integer)parameters[2];
        if (parameters.length == 3) {
            return;
        }
        if (parameters[3] instanceof int[] && parameters[4] instanceof int[]) {
            this.setDirections((int[])parameters[3], (int[])parameters[4]);
        } else if (parameters[3] instanceof Integer && parameters[4] instanceof Integer) {
            this.setDirection((Integer)parameters[3], (Integer)parameters[4]);
        } else {
            throw new IllegalArgumentException("Parameters 3 & 4 are not int or int[].");
        }
    }
}

