/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLMfeatures;
import characterization.textures.statisticalmatrices.rlm.MultiRLM;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.MultiDZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dv.DV;
import dv.DvIO;
import filesAndFolders.FichiersDossiersIHM;
import filesAndFolders.FileNameFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import gui.MailBox;
import imageTiTi.ImageIO;
import init.Initializer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mathematics.functions.LinearFunctions;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;
import processing.reducer.HistogramGLR;
import processing.reducer.LinearGLR;
import processing.reducer.MinMaxLinearGLR;

public class StatisticalMatricesGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final double Version = 1.0;
    private String about = "Version 1.0\nAuthor: Guillaume THIBAULT\nWeb: www.thibault.biz\nCopyright (c) 2006-Today\nAll Rights Reserved";
    private String cite = "How to cite this software?\nVisit <a href=\"www.thibault.biz/Publications/Publications.html\">www.thibault.biz/Publications/Publications.html</a>\nCite the papers presenting the implemented methods:\n - Size Zone Matrix (SZM) => IEEE BME 2014, IJPRAI 2013, PRIP 2009.\n - Run Length Matrix (RLM) => IEEE BME 2014, IJPRAI 2013, PRIP 2009.\n - Distance Zone Matrix (DZM) => IEEE BME 2014.\n - Multiple SZM / RLM / DZM => IEEE BME 2014.\n - Fuzzy SZM / RLM / DZM => arXiv 2017 <a href=\"https://arxiv.org/abs/1611.06009\">https://arxiv.org/abs/1611.06009</a>.";
    private String howto = "How to use this software?\n - 1 - Click on the 'Find' button to select the directory containing the images/volumes to characterize\nThe volumes have to be stored in separated directories as an image sequence. - 2 - (Optional) Fill one of the boxes 'Filter by' in order to process only the images containing the given string\n - 3 - Select the algorithm to use\n - 4 - Select the gray level reducer to use\n - 5 - Enter the number of bins or the fussification value (if the reducer Fuzzy is selected)\n - 6 - Enter the forbidden value (value to ignore during the processing). \nEnter a negative value to process all the pixels.\nIt must be 0 for the fuzzy reducer.\n - 7 - Press 'Start'Result: a file named Features_Technique_Reducer_Bins_ForbiddenValue.txt will contain the features.";
    private int CPU = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    private String currentpath1 = "~/";
    private JComboBox AlgoChoice;
    private JLabel BinsLabel;
    private JTextField BinsText;
    private JButton BouttonLancer;
    private JToggleButton ButtonFind1;
    private JComboBox DimensionChoice;
    private JMenuItem ExitMenu;
    private JTextField FilterName;
    private JTextField FilterType;
    private JLabel ForbiddenValueLabel;
    private JTextField ForbiddenValueText;
    private JTextField InputDirText;
    private JLabel LabelAlgorithme;
    private JLabel LabelDimensions;
    private JLabel LabelFiltrerNom;
    private JLabel LabelFiltrerType;
    private JLabel LabelIS;
    private JMenuItem MenuAbout;
    private JMenuItem MenuCite;
    private JMenuItem MenuHowTo;
    private JComboBox ReducerChoice;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;

    public StatisticalMatricesGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.LabelIS = new JLabel();
        this.InputDirText = new JTextField();
        this.ButtonFind1 = new JToggleButton();
        this.jLayeredPane1 = new JLayeredPane();
        this.LabelFiltrerNom = new JLabel();
        this.LabelFiltrerType = new JLabel();
        this.FilterName = new JTextField();
        this.FilterType = new JTextField();
        this.BouttonLancer = new JButton();
        this.AlgoChoice = new JComboBox();
        this.LabelAlgorithme = new JLabel();
        this.jLabel1 = new JLabel();
        this.ReducerChoice = new JComboBox();
        this.BinsLabel = new JLabel();
        this.BinsText = new JTextField();
        this.ForbiddenValueLabel = new JLabel();
        this.ForbiddenValueText = new JTextField();
        this.LabelDimensions = new JLabel();
        this.DimensionChoice = new JComboBox();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.ExitMenu = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.MenuAbout = new JMenuItem();
        this.MenuCite = new JMenuItem();
        this.MenuHowTo = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Statistical Matrices");
        this.LabelIS.setText("Folder");
        this.InputDirText.setEditable(false);
        this.InputDirText.setToolTipText("");
        this.ButtonFind1.setSelected(true);
        this.ButtonFind1.setText("Find");
        this.ButtonFind1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.ButtonFind1ActionPerformed(evt);
            }
        });
        this.jLayeredPane1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.LabelFiltrerNom.setText("Filter by name");
        this.LabelFiltrerType.setText("Filter by type");
        this.jLayeredPane1.setLayer(this.LabelFiltrerNom, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.LabelFiltrerType, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.FilterName, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.FilterType, JLayeredPane.DEFAULT_LAYER);
        GroupLayout jLayeredPane1Layout = new GroupLayout(this.jLayeredPane1);
        this.jLayeredPane1.setLayout(jLayeredPane1Layout);
        jLayeredPane1Layout.setHorizontalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane1Layout.createSequentialGroup().addContainerGap().addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LabelFiltrerNom).addComponent(this.LabelFiltrerType)).addGap(18, 18, 18).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.FilterName).addComponent(this.FilterType)).addContainerGap()));
        jLayeredPane1Layout.setVerticalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane1Layout.createSequentialGroup().addContainerGap().addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelFiltrerNom).addComponent(this.FilterName, -2, -1, -2)).addGap(18, 18, 18).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelFiltrerType).addComponent(this.FilterType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.BouttonLancer.setText("Start");
        this.BouttonLancer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.BouttonLancerActionPerformed(evt);
            }
        });
        this.AlgoChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Size Zone Matrix (SZM)", "Multiple Size Zone Matrix (Multi-SZM)", "Run Length Matrix (RLM)", "Multiple Run Length Matrix (Multi-RLM)", "Distance Zone Matrix (DZM)", "Multiple Distance Zone Matrix (Multi-DZM)"}));
        this.AlgoChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.AlgoChoiceActionPerformed(evt);
            }
        });
        this.LabelAlgorithme.setText("Algorithm");
        this.jLabel1.setText("Reducer");
        this.ReducerChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Linear", "Stretching + Linear", "Histogram", "Fuzzy"}));
        this.ReducerChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StatisticalMatricesGUI.this.ReducerChoiceItemStateChanged(evt);
            }
        });
        this.BinsLabel.setText("Bins");
        this.BinsText.setText("64");
        this.ForbiddenValueLabel.setText("Forbidden value");
        this.ForbiddenValueText.setText("0");
        this.ForbiddenValueText.setToolTipText("");
        this.LabelDimensions.setText("Dimensions");
        this.DimensionChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"2D", "3D"}));
        this.DimensionChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StatisticalMatricesGUI.this.DimensionChoiceItemStateChanged(evt);
            }
        });
        this.jMenu1.setText("File");
        this.ExitMenu.setText("Exit");
        this.ExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.ExitMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.ExitMenu);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Help");
        this.MenuAbout.setText("About");
        this.MenuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.MenuAboutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuAbout);
        this.MenuCite.setText("Cite");
        this.MenuCite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.MenuCiteActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuCite);
        this.MenuHowTo.setText("How To");
        this.MenuHowTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticalMatricesGUI.this.MenuHowToActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuHowTo);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.BouttonLancer).addGap(155, 155, 155)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.ForbiddenValueLabel).addComponent(this.BinsLabel, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ReducerChoice, GroupLayout.Alignment.TRAILING, -2, 195, -2).addComponent(this.BinsText, GroupLayout.Alignment.TRAILING, -2, 60, -2).addComponent(this.ForbiddenValueText, GroupLayout.Alignment.TRAILING, -2, 60, -2))).addGroup(layout.createSequentialGroup().addComponent(this.LabelAlgorithme).addGap(7, 7, 7).addComponent(this.AlgoChoice, 0, 1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.LabelIS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InputDirText)).addGroup(layout.createSequentialGroup().addComponent(this.LabelDimensions).addGap(232, 232, 232))).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ButtonFind1, -1, -1, Short.MAX_VALUE).addComponent(this.DimensionChoice, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelIS).addComponent(this.InputDirText, -2, -1, -2).addComponent(this.ButtonFind1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelDimensions).addComponent(this.DimensionChoice, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jLayeredPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.AlgoChoice, -2, -1, -2).addComponent(this.LabelAlgorithme)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.ReducerChoice, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.BinsLabel).addComponent(this.BinsText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ForbiddenValueLabel).addComponent(this.ForbiddenValueText, -2, -1, -2)).addGap(3, 3, 3).addComponent(this.BouttonLancer).addContainerGap()));
        this.pack();
    }

    private void ButtonFind1ActionPerformed(ActionEvent evt) {
        File file = FichiersDossiersIHM.ChoisirDossier(this.currentpath1, false);
        if (file == null) {
            return;
        }
        this.currentpath1 = file.getAbsolutePath();
        this.InputDirText.setText(file.getAbsolutePath());
        this.InputDirText.repaint();
    }

    private void BouttonLancerActionPerformed(ActionEvent evt) {
        int bins;
        if (this.InputDirText.getText() == null || this.InputDirText.getText().isEmpty()) {
            new MailBox(0, "Select a directory to process!\n(Error 1)", "Error");
            return;
        }
        FileFilter filefilter = null;
        switch (this.DimensionChoice.getSelectedIndex()) {
            case 0: {
                if (this.FilterName.getText() == null || this.FilterName.getText().isEmpty()) {
                    if (this.FilterType.getText() == null || this.FilterType.getText().isEmpty()) {
                        filefilter = file -> file.isFile() && file.getName().charAt(0) != '.';
                        break;
                    }
                    filefilter = file -> file.isFile() && file.getName().charAt(0) != '.' && file.getName().endsWith(this.FilterType.getText());
                    break;
                }
                if (this.FilterType.getText() == null || this.FilterType.getText().isEmpty()) {
                    filefilter = file -> file.isFile() && file.getName().charAt(0) != '.' && file.getName().contains(this.FilterName.getText());
                    break;
                }
                filefilter = file -> file.isFile() && file.getName().charAt(0) != '.' && file.getName().endsWith(this.FilterType.getText()) && file.getName().contains(this.FilterName.getText());
                break;
            }
            case 1: {
                if (this.FilterName.getText() == null || this.FilterName.getText().isEmpty()) {
                    if (this.FilterType.getText() == null || this.FilterType.getText().isEmpty()) {
                        filefilter = file -> file.isDirectory() && file.getName().charAt(0) != '.';
                        break;
                    }
                    filefilter = file -> file.isDirectory() && file.getName().charAt(0) != '.' && file.getName().endsWith(this.FilterType.getText());
                    break;
                }
                if (this.FilterType.getText() == null || this.FilterType.getText().isEmpty()) {
                    filefilter = file -> file.isDirectory() && file.getName().charAt(0) != '.' && file.getName().contains(this.FilterName.getText());
                    break;
                }
                filefilter = file -> file.isDirectory() && file.getName().charAt(0) != '.' && file.getName().endsWith(this.FilterType.getText()) && file.getName().contains(this.FilterName.getText());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown dimension. Must not occur!");
            }
        }
        Object[] files = new File(this.InputDirText.getText()).listFiles(filefilter);
        if (files == null || files.length == 0) {
            new MailBox(0, "No image/directory found!\n'" + this.InputDirText.getText() + "'\nCheck the path, and the filter(s) if necessary\n(Error 2)", "Error");
            return;
        }
        Arrays.sort(files);
        if (!this.BinsText.getText().equalsIgnoreCase("All")) {
            bins = Integer.valueOf(this.BinsText.getText());
            if (bins <= 0) {
                new MailBox(0, "Bins/Fuzzyfication value <= 0\n" + bins, "Error");
                return;
            }
        } else {
            bins = -1;
        }
        int forbiddenvalue = Integer.valueOf(this.ForbiddenValueText.getText());
        ColorReducer reducer = null;
        String reducername = "";
        switch (this.ReducerChoice.getSelectedIndex()) {
            case 0: {
                reducername = "Linear";
                reducer = new LinearGLR();
                break;
            }
            case 1: {
                reducername = "MinMaxLinear";
                reducer = new MinMaxLinearGLR();
                break;
            }
            case 2: {
                reducername = "Histogram";
                reducer = new HistogramGLR();
                break;
            }
            case 3: {
                reducername = "Fuzzy";
                reducer = new FuzzyGLR(bins, 8, LinearFunctions.DecreasingLinearFrom_01_N0(bins));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown reducer. Must not occur!");
            }
        }
        ComputableFeatures characterizer = null;
        String characterizername = "";
        block12 : switch (this.AlgoChoice.getSelectedIndex()) {
            case 0: {
                characterizername = "SZM";
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    characterizer = new FuzzySZMfeatures();
                    characterizer.Parameters(-1, reducer, forbiddenvalue, true);
                    break;
                }
                characterizer = new SZMfeatures();
                characterizer.Parameters(bins, 1, reducer, forbiddenvalue, true);
                break;
            }
            case 1: {
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    new MailBox(0, "The Multiple SZM does not support the fuzzy version (coming soon)", "Error");
                    return;
                }
                characterizername = "MultiSZM";
                characterizer = new MultiSZM();
                characterizer.Parameters(1, reducer, forbiddenvalue, true);
                break;
            }
            case 2: {
                characterizername = "RLM";
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    characterizer = new FuzzyRLMfeatures();
                    characterizer.Parameters(-1, reducer, forbiddenvalue);
                    break;
                }
                characterizer = new RLMfeatures();
                characterizer.Parameters(bins, reducer, forbiddenvalue);
                break;
            }
            case 3: {
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    new MailBox(0, "The Multiple RLM does not support the fuzzy version (coming soon)", "Error");
                    return;
                }
                characterizername = "MultiRLM";
                characterizer = new MultiRLM();
                characterizer.Parameters(reducer, forbiddenvalue);
                break;
            }
            case 4: {
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    new MailBox(0, "The DZM does not support the fuzzy version (coming soon)", "Error");
                    return;
                }
                characterizername = "DZM";
                characterizer = new DZMfeatures();
                switch (this.DimensionChoice.getSelectedIndex()) {
                    case 0: {
                        characterizer.Parameters(bins, 1, new StructuringElement(new Object[]{3, -15}), true, false, reducer, forbiddenvalue, true);
                        break block12;
                    }
                    case 1: {
                        characterizer.Parameters(bins, 1, new StructuringElement3D(new Object[]{3, -15}), true, false, reducer, forbiddenvalue, true);
                        break block12;
                    }
                }
                throw new IllegalStateException("Unknown dimension. Must not occur!");
            }
            case 5: {
                if (this.ReducerChoice.getSelectedIndex() == 3) {
                    new MailBox(0, "The Multiple DZM does not support the fuzzy version (coming soon)", "Error");
                    return;
                }
                characterizername = "MultiDZM";
                characterizer = new MultiDZM();
                switch (this.DimensionChoice.getSelectedIndex()) {
                    case 0: {
                        characterizer.Parameters(1, new StructuringElement(new Object[]{3, -15}), true, false, reducer, forbiddenvalue, true);
                        break block12;
                    }
                    case 1: {
                        characterizer.Parameters(1, new StructuringElement3D(new Object[]{3, -15}), true, false, reducer, forbiddenvalue, true);
                        break block12;
                    }
                }
                throw new IllegalStateException("Unknown dimension. Must not occur!");
            }
            default: {
                throw new IllegalStateException("Unknown operation/algorithm. Must not occur!");
            }
        }
        int nbfeatures = characterizer.Features().length;
        int[] types = new int[nbfeatures + 1];
        Arrays.fill(types, 1);
        types[types.length - 1] = 2;
        FichierTabule result = new FichierTabule(files.length, types, "Features.");
        switch (this.DimensionChoice.getSelectedIndex()) {
            case 0: {
                int i2;
                int f;
                for (f = 0; f < files.length; ++f) {
                    try {
                        BufferedImage image = ImageIO.Read((File)files[f]);
                        characterizer.Compute(image, null, -1, this.CPU);
                        for (i2 = 0; i2 < nbfeatures; ++i2) {
                            result.setValue(f, i2, characterizer.Feature(i2));
                        }
                        result.setValue(f, nbfeatures, ((File)files[f]).getAbsolutePath());
                        image = null;
                        continue;
                    }
                    catch (Error | Exception ex) {
                        new MailBox(0, "Issue with the image :\n" + ((File)files[f]).getAbsolutePath() + "\n" + ex.getMessage(), "Error");
                        ex.printStackTrace();
                        return;
                    }
                }
                break;
            }
            case 1: {
                int i2;
                int f;
                for (f = 0; f < files.length; ++f) {
                    try {
                        DV dv = DvIO.ReadFromStack(((File)files[f]).getAbsolutePath(), FileNameFilters.Images);
                        characterizer.Compute(dv, this.CPU);
                        for (i2 = 0; i2 < nbfeatures; ++i2) {
                            result.setValue(f, i2, characterizer.Feature(i2));
                        }
                        result.setValue(f, nbfeatures, ((File)files[f]).getAbsolutePath());
                        dv.Kill();
                        dv = null;
                        continue;
                    }
                    catch (Error | Exception ex) {
                        new MailBox(0, "Issue with the image :\n" + ((File)files[f]).getAbsolutePath() + "\n" + ex.getMessage(), "Error");
                        ex.printStackTrace();
                        return;
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown dimension. Must not occur!");
            }
        }
        String[] colnames = characterizer.FeaturesNames();
        for (int i3 = 0; i3 < colnames.length; ++i3) {
            result.setColumnName(i3, colnames[i3]);
        }
        result.setColumnName(colnames.length, "Images");
        String resname = "Features_" + (this.DimensionChoice.getSelectedIndex() == 0 ? "2D" : "3D") + "_" + characterizername + "_" + reducername + "_" + bins + "_" + forbiddenvalue + ".txt";
        result.Write(resname, false);
        new MailBox(0, "Success!\n" + files.length + " image" + (files.length == 1 ? "" : "s") + " characterized.\nLook for the file " + resname, "Process Over");
    }

    private void ExitMenuActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void ReducerChoiceItemStateChanged(ItemEvent evt) {
        switch (this.ReducerChoice.getSelectedIndex()) {
            case 0: 
            case 1: 
            case 2: {
                this.BinsLabel.setText("Bins");
                this.BinsText.setText("64");
                this.ForbiddenValueText.setEnabled(true);
                this.ForbiddenValueText.setText("0");
                this.ForbiddenValueLabel.setText("Forbidden value");
                break;
            }
            case 3: {
                this.BinsLabel.setText("Fuzzyfication");
                this.BinsText.setText("4");
                this.ForbiddenValueLabel.setText("Forbidden value (Mandatory)");
                this.ForbiddenValueText.setText("0");
                this.ForbiddenValueText.setEnabled(false);
                break;
            }
            default: {
                new MailBox(0, "Reducer choice not supported. Should not occur!", "Error");
            }
        }
    }

    private void MenuAboutActionPerformed(ActionEvent evt) {
        new MailBox(0, this.about, "About");
    }

    private void MenuHowToActionPerformed(ActionEvent evt) {
        new MailBox(0, this.howto, "How To");
    }

    private void DimensionChoiceItemStateChanged(ItemEvent evt) {
    }

    private void AlgoChoiceActionPerformed(ActionEvent evt) {
        switch (this.AlgoChoice.getSelectedIndex()) {
            case 0: 
            case 2: 
            case 4: {
                this.BinsText.setEnabled(true);
                if (!this.BinsText.getText().equalsIgnoreCase("All")) break;
                this.BinsText.setText("64");
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                this.BinsText.setText("All");
                this.BinsText.setEnabled(false);
                break;
            }
            default: {
                new MailBox(0, "Algorithm choice not supported. Should not occur!", "Error");
            }
        }
    }

    private void MenuCiteActionPerformed(ActionEvent evt) {
        new MailBox(0, this.cite, "Cite");
    }

    public static void main(String[] args) {
        Initializer.Start();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(StatisticalMatricesGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new StatisticalMatricesGUI().setVisible(true));
    }
}

