/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class TransitionLBP
implements MorphoFilter {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private StructuringElement se = null;
    private int[] Lut = null;
    private int[] res = null;
    private int nbFreeThreads = 0;
    private TransitionLBPThread[] threads = null;
    private int mode = 2;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, this.se, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.se, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different dimension.");
        }
        if (result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The result image must have a DataBuffer of type Integer.");
        }
        if (result.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The result image must have 1 channel/band/bank.");
        }
        this.setStructuringElement(se);
        this.res = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        Arrays.fill(this.res, -1);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new TransitionLBPThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new TransitionLBPThread();
                this.threads[i2].start();
            }
            TransitionLBP transitionLBP = this;
            synchronized (transitionLBP) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, se, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, se, i2 * step, source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void BuildLut() {
        int size = this.se.getSE().length;
        int length = (int)Math.pow(2.0, size);
        if (this.Lut != null && this.Lut.length == length) {
            return;
        }
        this.Lut = null;
        this.Lut = new int[length];
        LocalBinaryPattern.FillLut(this.Lut, size, this.mode);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void setUniform(int mode) {
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        this.se = se;
        this.BuildLut();
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int BorderEffectSizeX() {
        if (this.se != null) {
            return this.se.getSizeX();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.se != null) {
            return this.se.getSizeY();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.mode = (Integer)parameters[1];
        this.setStructuringElement((StructuringElement)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.se);
        params.add(this.mode);
        return params;
    }

    private class TransitionLBPThread
    extends Thread {
        private int width;
        private int height;
        private int type;
        private int orderx;
        private int ordery;
        private int nbPoints = 0;
        private int miny;
        private int maxy;
        private CoordinatesWeighted[] seco = null;
        private short[] shortbufferin = null;
        private byte[] bytebufferin = null;
        public Object lock = new Object();

        public void setConditions(BufferedImage Original, StructuringElement se, int miny, int maxy) {
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.nbPoints = this.seco.length;
            this.miny = miny;
            this.maxy = maxy;
            this.bytebufferin = null;
            this.shortbufferin = null;
            switch (Original.getType()) {
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var11_11 = this.lock;
                synchronized (var11_11) {
                    try {
                        TransitionLBP.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.miny == 0) {
                    this.miny += this.ordery;
                }
                if (this.maxy == this.height) {
                    this.maxy -= this.ordery;
                }
                endx = this.width - this.orderx;
                switch (this.type) {
                    case 10: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                coord = this.seco[0];
                                previous = current = this.bytebufferin[pos + coord.Y * this.width + coord.X] & 255;
                                first = current;
                                val = 0;
                                for (c = 1; c < this.nbPoints; ++c) {
                                    val <<= 1;
                                    coord = this.seco[c];
                                    current = this.bytebufferin[pos + coord.Y * this.width + coord.X] & 255;
                                    if (0 <= previous - current) {
                                        ++val;
                                    }
                                    previous = current;
                                }
                                val <<= 1;
                                if (0 <= current - first) {
                                    ++val;
                                }
                                TransitionLBP.this.res[pos] = TransitionLBP.this.Lut[val];
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                coord = this.seco[0];
                                previous = current = this.shortbufferin[pos + coord.Y * this.width + coord.X] & 65535;
                                first = current;
                                val = 0;
                                for (c = 1; c < this.nbPoints; ++c) {
                                    val <<= 1;
                                    coord = this.seco[c];
                                    current = this.shortbufferin[pos + coord.Y * this.width + coord.X] & 65535;
                                    if (0 <= previous - current) {
                                        ++val;
                                    }
                                    previous = current;
                                }
                                val <<= 1;
                                if (0 <= current - first) {
                                    ++val;
                                }
                                TransitionLBP.this.res[pos] = TransitionLBP.this.Lut[val];
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported. Gray level required.");
        }
    }
}

