/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import characterization.ComputableFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class MultiLBP
implements ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private double[] histogram = null;
    private double[] coef = null;
    private LocalBinaryPattern lbp = new LocalBinaryPattern();
    private final ArrayFeatures AF = new ArrayFeatures();
    private int sestart = -1;
    private int seend = -1;
    private int sestep = -1;
    private int ForbiddenValue = -1;

    @Override
    public synchronized void Kill() {
        this.histogram = null;
        this.coef = null;
        this.lbp.Kill();
        this.lbp = null;
    }

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.sestart < 0) {
            throw new IllegalArgumentException("No parameters set.");
        }
        this.Compute(source, mask, this.sestart, this.seend, this.sestep, ForbiddenValue, nbCPU);
    }

    public void Compute(BufferedImage source, BufferedImage mask, int sestart, int seend, int sestep, int ForbiddenValue, int nbCPU) {
        this.sestart = sestart;
        this.seend = seend;
        this.sestep = sestep;
        this.ForbiddenValue = ForbiddenValue;
        if (this.coef == null || this.coef.length != (seend - sestart) / sestep + 1) {
            throw new IllegalArgumentException("Coefficients not defined, or at least not for this configuration");
        }
        int nb = 0;
        StructuringElement se = null;
        int order = sestart;
        while (order <= seend) {
            se = new StructuringElement(new Object[]{order, -13, 8});
            this.lbp.Compute(source, mask, se, ForbiddenValue, nbCPU);
            if (this.histogram == null || this.histogram.length != this.lbp.Features().length) {
                this.histogram = new double[this.lbp.Features().length];
            }
            ArrayArithmetic.Add((double[])this.lbp.Features(), (double)this.coef[nb], (double[])this.lbp.Features());
            ArrayArithmetic.Add((double[])this.histogram, (double[])this.lbp.Features(), (double[])this.histogram);
            se = null;
            order += sestep;
            ++nb;
        }
        ArrayArithmetic.Divide((double[])this.histogram, (double)this.AF.Integral(this.coef), (double[])this.histogram);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.sestart < 0) {
            throw new IllegalArgumentException("No parameters set.");
        }
        this.Compute(dv, this.sestart, this.seend, this.sestep, this.ForbiddenValue, nbCPU);
    }

    public void Compute(DV source, int sestart, int seend, int sestep, int ForbiddenValue, int nbCPU) {
        this.sestart = sestart;
        this.seend = seend;
        this.sestep = sestep;
        this.ForbiddenValue = ForbiddenValue;
        if (this.coef == null || this.coef.length != (seend - sestart) / sestep + 1) {
            throw new IllegalArgumentException("Coefficients not defined, or at least not for this configuration");
        }
        int nb = 0;
        StructuringElement3D se = null;
        int order = sestart;
        while (order <= seend) {
            se = new StructuringElement3D(new Object[]{order, -13, 8});
            this.lbp.Compute(source, se, ForbiddenValue, nbCPU);
            if (this.histogram == null || this.histogram.length != this.lbp.Features().length) {
                this.histogram = new double[this.lbp.Features().length];
            }
            ArrayArithmetic.Add((double[])this.lbp.Features(), (double)this.coef[nb], (double[])this.lbp.Features());
            ArrayArithmetic.Add((double[])this.histogram, (double[])this.lbp.Features(), (double[])this.histogram);
            se = null;
            order += sestep;
            ++nb;
        }
        ArrayArithmetic.Divide((double[])this.histogram, (double)this.AF.Integral(this.coef), (double[])this.histogram);
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    public void setUniform(int mode) {
        this.lbp.setUniform(mode);
    }

    public int getUniform() {
        return this.lbp.getUniform();
    }

    public void setCoefficients(double[] coef) {
        this.coef = Arrays.copyOf(coef, coef.length);
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 6) {
            throw new IllegalArgumentException("Exactly 6 parameters required.");
        }
        this.sestart = (Integer)parameters[0];
        this.seend = (Integer)parameters[1];
        this.sestep = (Integer)parameters[2];
        this.ForbiddenValue = (Integer)parameters[3];
        this.setCoefficients((double[])parameters[5]);
        this.lbp.Parameters(new StructuringElement3D(new Object[]{this.sestart, -13, 8}), (Integer)parameters[4], this.ForbiddenValue);
        this.histogram = ArrayNew.Same((double[])this.lbp.Features());
    }

    public List<Object> Parameters() {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.sestart);
        params.add(this.seend);
        params.add(this.sestep);
        params.add(this.ForbiddenValue);
        params.add(this.getUniform());
        params.add(this.coef);
        return params;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        String[] names = ArrayNew.Same((String[])this.lbp.FeaturesNames());
        String mod = null;
        switch (this.getUniform()) {
            case 0: {
                mod = "CL";
                break;
            }
            case 1: {
                mod = "UN1";
                break;
            }
            case 2: {
                mod = "UN2";
                break;
            }
            default: {
                throw new IllegalStateException("Must not occur.");
            }
        }
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = "MultiLBP_ " + this.sestart + "_" + this.seend + "_" + this.sestep + " " + mod + "_" + (i2 < 10 ? "00" : (i2 < 100 ? "0" : "")) + i2;
        }
        mod = null;
        return this.lbp.FeaturesNames();
    }
}

