/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import characterization.ComputableFeatures;
import characterization.textures.lbp.FuzzyLBP;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.StructuringElement;

public class MultiFuzzyLBP
implements ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private double[] histogram = null;
    private final FuzzyLBP flbp = new FuzzyLBP();
    private int sestart = 1;
    private int seend = 5;
    private int sestep = 2;
    private int fuzzystart = 1;
    private int fuzzyend = 5;
    private int fuzzystep = 2;
    private int ForbiddenValue = -1;

    public MultiFuzzyLBP() {
        this.flbp.setUniform(1);
        this.flbp.setStructuringElement(new StructuringElement(new Object[]{1, -13, 8}));
    }

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (mask != null) {
            throw new Error("Mask not supported (yet).");
        }
        this.Compute(source, this.sestart, this.seend, this.sestep, this.fuzzystart, this.fuzzyend, this.fuzzystep, ForbiddenValue, nbCPU);
    }

    public void Compute(BufferedImage source, int sestart, int seend, int sestep, int fuzzystart, int fuzzyend, int fuzzystep, int ForbiddenValue, int nbCPU) {
        this.sestart = sestart;
        this.seend = seend;
        this.sestep = sestep;
        this.fuzzystart = fuzzystart;
        this.fuzzyend = fuzzyend;
        this.ForbiddenValue = ForbiddenValue;
        int nb = 0;
        StructuringElement se = null;
        for (int order = sestart; order <= seend; order += sestep) {
            se = new StructuringElement(new Object[]{order, -13, 8});
            for (int fuzzyness = fuzzystart; fuzzyness <= fuzzyend; fuzzyness += fuzzystep) {
                this.flbp.Compute(source, se, fuzzyness, ForbiddenValue, nbCPU);
                if (this.histogram == null || this.histogram.length != this.flbp.Features().length) {
                    this.histogram = new double[this.flbp.Features().length];
                }
                ArrayArithmetic.Add((double[])this.histogram, (double[])this.flbp.Features(), (double[])this.histogram);
                ++nb;
            }
            se = null;
        }
        ArrayArithmetic.Divide((double[])this.histogram, (double)nb, (double[])this.histogram);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    public void setUniform(int mode) {
        this.flbp.setUniform(mode);
    }

    public int getUniform() {
        return this.flbp.getUniform();
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 8) {
            throw new IllegalArgumentException("Exactly 8 parameters required.");
        }
        this.sestart = (Integer)parameters[0];
        this.seend = (Integer)parameters[1];
        this.sestep = (Integer)parameters[2];
        this.fuzzystart = (Integer)parameters[3];
        this.fuzzyend = (Integer)parameters[4];
        this.fuzzystep = (Integer)parameters[5];
        this.ForbiddenValue = (Integer)parameters[6];
        this.setUniform((Integer)parameters[7]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(9);
        params.add(this.sestart);
        params.add(this.seend);
        params.add(this.sestep);
        params.add(this.fuzzystart);
        params.add(this.fuzzyend);
        params.add(this.fuzzystep);
        params.add(this.ForbiddenValue);
        params.add(this.getUniform());
        return params;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.flbp.FeaturesNames();
    }

    @Override
    public synchronized void Kill() {
        this.histogram = null;
        this.flbp.Kill();
    }
}

