/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayTools;
import characterization.ComputableFeatures;
import dv.DV;
import dv.DvConverter;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.Maths;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class LocalBinaryPattern
implements MorphoFilter,
ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private StructuringElement se = null;
    private StructuringElement3D se3 = null;
    private int[] Lut = null;
    private int[] res = null;
    private byte[] res3 = null;
    private int nbFreeThreads = 0;
    private LocalBinaryPatternThread[] threads = null;
    private LocalBinaryPattern3DThread[] threads3d = null;
    private double[] histogram = null;
    private String[] names = null;
    private int mode = -1;
    private int oldlength = -1;
    private int oldmode = this.mode;
    private int maxlut = -1;
    private int ForbiddenValue = -1;
    private int nbPixelProcessed;
    private BufferedImage imtmp = null;
    private DV dvtmp = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public synchronized void Kill() {
        int i2;
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
            }
        }
        if (this.threads3d != null) {
            for (i2 = 0; i2 < this.threads3d.length; ++i2) {
                this.threads3d[i2].Kill();
            }
        }
        this.se = null;
        this.se3 = null;
        this.Lut = null;
        this.res = null;
        this.res3 = null;
        this.histogram = null;
        this.names = null;
        this.imtmp = null;
        if (this.dvtmp != null) {
            this.dvtmp.Kill();
        }
        this.dvtmp = null;
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2] = null;
            }
        }
        if (this.threads3d != null) {
            for (i2 = 0; i2 < this.threads3d.length; ++i2) {
                this.threads3d[i2] = null;
            }
        }
        this.threads = null;
        this.threads3d = null;
    }

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.imtmp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        }
        this.Filter(source, mask, this.se, ForbiddenValue, this.imtmp, nbCPU);
    }

    public void Compute(BufferedImage source, BufferedImage mask, StructuringElement se, int ForbiddenValue, int nbCPU) {
        if (this.imtmp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        }
        this.Filter(source, mask, se, ForbiddenValue, this.imtmp, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, this.se, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.se, result, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.Filter(source, null, se, this.ForbiddenValue, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage mask, StructuringElement se, int ForbiddenValue, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different dimension.");
        }
        if (result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The result image must have a DataBuffer of type Integer.");
        }
        if (result.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The result image must have 1 channel/band/bank.");
        }
        this.setStructuringElement(se);
        se.PreComputePositions(source.getWidth());
        this.ForbiddenValue = ForbiddenValue;
        BufferedImage image = null;
        if (mask != null) {
            image = ImageNew.Clone((BufferedImage)source);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)source, (int)ForbiddenValue, (BufferedImage)image);
        } else {
            image = source;
        }
        this.nbPixelProcessed = 0;
        Arrays.fill(this.histogram, 0.0);
        this.res = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        Arrays.fill(this.res, -1);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new LocalBinaryPatternThread[nbCPU];
            for (int i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new LocalBinaryPatternThread();
                this.threads[i2].start();
            }
            LocalBinaryPattern i2 = this;
            synchronized (i2) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = image.getHeight() / nbCPU;
        for (int i3 = 0; i3 < nbCPU - 1; ++i3) {
            this.threads[i3].setConditions(image, se, i3 * step, (i3 + 1) * step);
            Object object = this.threads[i3].lock;
            synchronized (object) {
                this.threads[i3].lock.notify();
                continue;
            }
        }
        this.threads[nbCPU - 1].setConditions(image, se, (nbCPU - 1) * step, image.getHeight());
        Object i3 = this.threads[nbCPU - 1].lock;
        synchronized (i3) {
            this.threads[nbCPU - 1].lock.notify();
        }
        i3 = this;
        synchronized (i3) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        for (int i4 = 0; i4 < nbCPU; ++i4) {
            ArrayArithmetic.Add((double[])this.threads[i4].hist, (double[])this.histogram, (double[])this.histogram);
            this.nbPixelProcessed += this.threads[i4].nbpixel;
        }
        if (0 < this.nbPixelProcessed) {
            ArrayArithmetic.Divide((double[])this.histogram, (double)this.nbPixelProcessed, (double[])this.histogram);
        }
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.dvtmp == null || !DvTools.areDimensionsEqual((DV)dv, (DV)this.dvtmp)) {
            this.dvtmp = null;
            this.dvtmp = new DV(dv.SizeX, dv.SizeY, dv.SizeZ, dv.Channel, 8);
        }
        this.Filter(dv, this.se3, this.ForbiddenValue, this.dvtmp, nbCPU);
    }

    public void Compute(DV dv, StructuringElement3D se, int ForbiddenValue, int nbCPU) {
        if (this.dvtmp == null || !DvTools.areDimensionsEqual((DV)dv, (DV)this.dvtmp)) {
            this.dvtmp = null;
            this.dvtmp = new DV(dv.SizeX, dv.SizeY, dv.SizeZ, dv.Channel, 8);
        }
        this.Filter(dv, se, ForbiddenValue, this.dvtmp, nbCPU);
    }

    public DV Filter(DV dv, int nbCPU) {
        this.Filter(dv, this.se3, null, nbCPU);
        return null;
    }

    public DV Filter(DV dv, StructuringElement3D se, int nbCPU) {
        DV result = new DV(dv.SizeX, dv.SizeY, dv.SizeZ, dv.Channel, 8);
        this.Filter(dv, se, result, nbCPU);
        return result;
    }

    public void Filter(DV dv, DV result, int nbCPU) {
        this.Filter(dv, this.se3, result, nbCPU);
    }

    public void Filter(DV dv, StructuringElement3D se, DV result, int nbCPU) {
        this.Filter(dv, se, this.ForbiddenValue, result, nbCPU);
    }

    public void Filter(DV dv, StructuringElement3D se, int ForbiddenValue, DV result, int nbCPU) {
        int type;
        this.ForbiddenValue = ForbiddenValue;
        int counter = 0;
        switch (dv.Type) {
            case 8: {
                type = 10;
                break;
            }
            case 16: {
                type = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        this.setStructuringElement3D(se);
        this.nbPixelProcessed = 0;
        Arrays.fill(this.histogram, 0.0);
        double[] hist = (double[])this.histogram.clone();
        BufferedImage tmp = new BufferedImage(dv.SizeX, dv.SizeY, type);
        for (int z = 0; z < dv.SizeZ; ++z) {
            DvConverter.DVtoBufferedImage(dv, 0, z, tmp);
            this.Compute(tmp, null, this.se, ForbiddenValue, nbCPU);
            if (0 >= this.nbPixelProcessed) continue;
            ArrayArithmetic.Multiply((double[])this.histogram, (double)this.nbPixelProcessed, (double[])this.histogram);
            ArrayArithmetic.Add((double[])hist, (double[])this.histogram, (double[])hist);
            counter += this.nbPixelProcessed;
        }
        tmp = null;
        if (ArrayTools.ContainsNaN((double[])hist)) {
            System.out.println("Oups Z");
        }
        tmp = new BufferedImage(dv.SizeX, dv.SizeZ, type);
        for (int y = 0; y < dv.SizeY; ++y) {
            DvConverter.DvXZtoBufferedImage(dv, 0, y, tmp);
            this.Compute(tmp, null, this.se, ForbiddenValue, nbCPU);
            if (0 >= this.nbPixelProcessed) continue;
            ArrayArithmetic.Multiply((double[])this.histogram, (double)this.nbPixelProcessed, (double[])this.histogram);
            ArrayArithmetic.Add((double[])hist, (double[])this.histogram, (double[])hist);
            counter += this.nbPixelProcessed;
        }
        tmp = null;
        if (ArrayTools.ContainsNaN((double[])hist)) {
            System.out.println("Oups Y");
        }
        tmp = new BufferedImage(dv.SizeY, dv.SizeZ, type);
        for (int x = 0; x < dv.SizeX; ++x) {
            DvConverter.DvYZtoBufferedImage(dv, 0, x, tmp);
            this.Compute(tmp, null, this.se, ForbiddenValue, nbCPU);
            if (0 >= this.nbPixelProcessed) continue;
            ArrayArithmetic.Multiply((double[])this.histogram, (double)this.nbPixelProcessed, (double[])this.histogram);
            ArrayArithmetic.Add((double[])hist, (double[])this.histogram, (double[])hist);
            counter += this.nbPixelProcessed;
        }
        tmp = null;
        if (ArrayTools.ContainsNaN((double[])hist)) {
            System.out.println("Oups X");
        }
        System.arraycopy(hist, 0, this.histogram, 0, this.histogram.length);
        this.nbPixelProcessed = counter;
        ArrayArithmetic.Multiply((double[])this.histogram, (double)(1.0 / (double)this.nbPixelProcessed), (double[])this.histogram);
        hist = null;
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void BuildLut() {
        int size = this.se.getSE().length;
        if (this.Lut != null && size == this.oldlength && this.oldmode == this.mode) {
            return;
        }
        int length = Maths.Power((int)2, (int)size);
        this.Lut = null;
        this.Lut = new int[length];
        LocalBinaryPattern.FillLut(this.Lut, size, this.mode);
        this.oldmode = this.mode;
        this.oldlength = size;
        this.maxlut = this.AF.Maximum(this.Lut);
        this.histogram = null;
        this.histogram = new double[this.maxlut + 1];
        this.names = null;
        this.names = new String[this.maxlut + 1];
        String mod = null;
        switch (this.mode) {
            case 0: {
                mod = "CL";
                break;
            }
            case 1: {
                mod = "UN1";
                break;
            }
            case 2: {
                mod = "UN2";
                break;
            }
            default: {
                throw new IllegalStateException("Must not occur.");
            }
        }
        int nbpoints = this.se.getSE().length;
        int order = this.se.getOrder();
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2] = "LBP_" + mod + "_" + nbpoints + "R" + order + "_" + (i2 < 10 ? "00" : (i2 < 100 ? "0" : "")) + i2;
        }
        mod = null;
    }

    public static void FillLut(int[] lut, int size, int mode) {
        int numConfig = 0;
        int[] done = new int[lut.length];
        int[] t = new int[size];
        block5: for (int i2 = 0; i2 < lut.length; ++i2) {
            Maths.DecimalToBase((int)i2, (int)2, (int[])t);
            int min = i2;
            for (int y = 1; y < size; ++y) {
                int val = t[0];
                for (int x = 1; x < size; ++x) {
                    t[x - 1] = t[x];
                }
                t[x - 1] = val;
                val = Maths.BaseToDecimal((int[])t, (int)2);
                if (val >= min) continue;
                min = val;
            }
            switch (mode) {
                case 0: {
                    lut[i2] = min;
                    continue block5;
                }
                case 1: {
                    if (done[min] == 0) {
                        done[min] = 1;
                        lut[i2] = numConfig++;
                        continue block5;
                    }
                    lut[i2] = lut[min];
                    continue block5;
                }
                case 2: {
                    if (done[min] == 0) {
                        done[min] = 1;
                        if (min == 0 || min == 1 || min == 3 || min == 7 || min == 15 || min == 31 || min == 63 || min == 127 || min == 255) {
                            lut[i2] = numConfig++;
                            continue block5;
                        }
                        lut[i2] = 9;
                        continue block5;
                    }
                    lut[i2] = lut[min];
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Construction mode of Lut not supported (see constants).");
                }
            }
        }
        t = null;
    }

    public static int Compute(BufferedImage image, int x, int y, int pos, int ForbiddenValue, StructuringElement se) {
        se.PreComputePositions(image.getWidth());
        int val = 0;
        CoordinatesWeighted[] seco = se.getSE();
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int v = bb[pos] & 0xFF;
                for (CoordinatesWeighted co : seco) {
                    int pix;
                    val <<= 1;
                    if (0 > x + co.X || x + co.X >= image.getWidth() || 0 > y + co.Y || y + co.Y >= image.getHeight() || (pix = bb[pos + co.Pos] & 0xFF) == ForbiddenValue || pix < v) continue;
                    ++val;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int sv = sb[pos] & 0xFFFF;
                for (CoordinatesWeighted co : seco) {
                    int pix;
                    val <<= 1;
                    if (0 > x + co.X || x + co.X >= image.getWidth() || 0 > y + co.Y || y + co.Y >= image.getHeight() || (pix = sb[pos + co.Pos] & 0xFFFF) == ForbiddenValue || pix < sv) continue;
                    ++val;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return val;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void setUniform(int mode) {
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public int getMaximumValueLut() {
        return this.maxlut;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        this.se = se;
        this.BuildLut();
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.se3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        this.se3 = se;
        if (this.se == null || this.se.getOrder() != se.getOrder() || this.se.getSE().length != se.getSE().length) {
            this.setStructuringElement(new StructuringElement(new Object[]{se.getOrder(), -13, se.getSE().length}));
        }
    }

    public int BorderEffectSizeX() {
        if (this.se3 != null) {
            return this.se3.getSizeX();
        }
        if (this.se != null) {
            return this.se.getSizeX();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.se3 != null) {
            return this.se3.getSizeY();
        }
        if (this.se != null) {
            return this.se.getSizeY();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        if (this.se3 != null) {
            return this.se3.getSizeZ();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.mode = (Integer)parameters[1];
        this.ForbiddenValue = (Integer)parameters[2];
        if (parameters[0] instanceof StructuringElement) {
            this.setStructuringElement((StructuringElement)parameters[0]);
        } else if (parameters[0] instanceof StructuringElement3D) {
            this.setStructuringElement3D((StructuringElement3D)parameters[0]);
        } else {
            throw new IllegalArgumentException("The fist parameter is not a structuring element.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        if (this.se != null) {
            params.add(this.se);
        } else {
            params.add(this.se3);
        }
        params.add(this.mode);
        return params;
    }

    public int[] getLut() {
        return this.Lut;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    private class LocalBinaryPattern3DThread
    extends Thread {
        private int width;
        private int height;
        private int depth;
        private int layersize;
        private int type;
        private int orderx;
        private int ordery;
        private int orderz;
        private int nbPoints = 0;
        private int minz;
        private int maxz;
        private CoordinatesWeighted[] seco = null;
        private byte[] bytebufferin = null;
        public final Object lock = new Object();
        public double[] hist = null;
        private boolean exit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            this.seco = null;
            this.bytebufferin = null;
            this.hist = null;
            this.interrupt();
        }

        public void setConditions(DV dv, StructuringElement3D se, int minz, int maxz) {
            this.type = dv.Type;
            this.width = dv.SizeX;
            this.height = dv.SizeY;
            this.depth = dv.SizeZ;
            this.layersize = dv.LayerSize;
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.orderz = se.getSizeZ() >> 1;
            this.nbPoints = this.seco.length;
            this.minz = minz;
            this.maxz = maxz;
            this.bytebufferin = null;
            if (this.hist == null || this.hist.length != LocalBinaryPattern.this.histogram.length) {
                this.hist = new double[LocalBinaryPattern.this.histogram.length];
            } else {
                Arrays.fill(this.hist, 0.0);
            }
            switch (dv.Type) {
                case 8: {
                    this.bytebufferin = dv.getDataBufferByte(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported DV type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block8: while (true) lbl-1000:
            // 3 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        LocalBinaryPattern.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.minz == 0) {
                    this.minz += this.ordery;
                }
                if (this.maxz == this.depth) {
                    this.maxz -= this.orderz;
                }
                endx = this.width - this.orderx;
                endy = this.height - this.ordery;
                switch (this.type) {
                    case 8: {
                        if (LocalBinaryPattern.this.ForbiddenValue >= 0) ** GOTO lbl49
                        z = this.minz;
                        while (true) {
                            if (z >= this.maxz) ** GOTO lbl-1000
                            for (y = this.ordery; y < endy; ++y) {
                                x = this.orderx;
                                pos = z * this.layersize + y * this.width + x;
                                while (x < endx) {
                                    v = this.bytebufferin[pos] & 255;
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        if ((this.bytebufferin[pos + this.seco[c].Pos] & 255) < v) continue;
                                        ++val;
                                    }
                                    v = LocalBinaryPattern.this.Lut[val];
                                    LocalBinaryPattern.this.res3[pos] = (byte)v;
                                    v0 = v;
                                    this.hist[v0] = this.hist[v0] + 1.0;
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++z;
                        }
lbl49:
                        // 1 sources

                        z = this.minz;
                        while (true) {
                            if (z >= this.maxz) continue block8;
                            for (y = this.ordery; y < endy; ++y) {
                                x = this.orderx;
                                pos = z * this.layersize + y * this.width + x;
                                while (x < endx) {
                                    v = this.bytebufferin[pos] & 255;
                                    if (v != LocalBinaryPattern.this.ForbiddenValue) {
                                        val = 0;
                                        for (c = 0; c < this.nbPoints; ++c) {
                                            val <<= 1;
                                            pix = this.bytebufferin[pos + this.seco[c].Pos] & 255;
                                            if (pix == LocalBinaryPattern.this.ForbiddenValue || pix < v) continue;
                                            ++val;
                                        }
                                        v = LocalBinaryPattern.this.Lut[val];
                                        LocalBinaryPattern.this.res3[pos] = (byte)v;
                                        v1 = v;
                                        this.hist[v1] = this.hist[v1] + 1.0;
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            ++z;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("DV type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class LocalBinaryPatternThread
    extends Thread {
        private int width;
        private int height;
        private int type;
        private int orderx;
        private int ordery;
        private int nbPoints = 0;
        private int miny;
        private int maxy;
        private CoordinatesWeighted[] seco = null;
        private short[] shortbufferin = null;
        private byte[] bytebufferin = null;
        public final Object lock = new Object();
        public double[] hist = null;
        private int nbpixel;
        private boolean exit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.seco = null;
            this.bytebufferin = null;
            this.shortbufferin = null;
            this.hist = null;
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            this.interrupt();
        }

        public void setConditions(BufferedImage Original, StructuringElement se, int miny, int maxy) {
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.nbPoints = this.seco.length;
            this.miny = miny;
            this.maxy = maxy;
            this.bytebufferin = null;
            this.shortbufferin = null;
            if (this.hist == null || this.hist.length != LocalBinaryPattern.this.histogram.length) {
                this.hist = new double[LocalBinaryPattern.this.histogram.length];
            } else {
                Arrays.fill(this.hist, 0.0);
            }
            switch (Original.getType()) {
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        LocalBinaryPattern.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.miny == 0) {
                    this.miny += this.ordery;
                }
                if (this.maxy == this.height) {
                    this.maxy -= this.ordery;
                }
                int endx = this.width - this.orderx;
                this.nbpixel = 0;
                switch (this.type) {
                    case 10: {
                        int pix;
                        int c;
                        int val;
                        int v;
                        int pos;
                        int x;
                        int y;
                        if (LocalBinaryPattern.this.ForbiddenValue < 0) {
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = this.orderx;
                                pos = y * this.width + x;
                                while (x < endx) {
                                    v = this.bytebufferin[pos] & 0xFF;
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        if ((this.bytebufferin[pos + this.seco[c].Pos] & 0xFF) < v) continue;
                                        ++val;
                                    }
                                    LocalBinaryPattern.this.res[pos] = v = LocalBinaryPattern.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                    ++x;
                                    ++pos;
                                }
                            }
                            this.nbpixel = (endx - this.orderx) * (this.maxy - this.miny);
                            break;
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                v = this.bytebufferin[pos] & 0xFF;
                                if (v != LocalBinaryPattern.this.ForbiddenValue) {
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        pix = this.bytebufferin[pos + this.seco[c].Pos] & 0xFF;
                                        if (pix == LocalBinaryPattern.this.ForbiddenValue || pix < v) continue;
                                        ++val;
                                    }
                                    LocalBinaryPattern.this.res[pos] = v = LocalBinaryPattern.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                    ++this.nbpixel;
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        int pix;
                        int c;
                        int val;
                        int v;
                        int pos;
                        int x;
                        int y;
                        if (LocalBinaryPattern.this.ForbiddenValue < 0) {
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = this.orderx;
                                pos = y * this.width + x;
                                while (x < endx) {
                                    v = this.shortbufferin[pos] & 0xFFFF;
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        if ((this.shortbufferin[pos + this.seco[c].Pos] & 0xFFFF) < v) continue;
                                        ++val;
                                    }
                                    LocalBinaryPattern.this.res[pos] = v = LocalBinaryPattern.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                    ++x;
                                    ++pos;
                                }
                            }
                            this.nbpixel = (endx - this.orderx) * (this.maxy - this.miny);
                            break;
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                v = this.shortbufferin[pos] & 0xFFFF;
                                if (v != LocalBinaryPattern.this.ForbiddenValue) {
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        pix = this.shortbufferin[pos + this.seco[c].Pos] & 0xFFFF;
                                        if (pix == LocalBinaryPattern.this.ForbiddenValue || pix < v) continue;
                                        ++val;
                                    }
                                    ++this.nbpixel;
                                    LocalBinaryPattern.this.res[pos] = v = LocalBinaryPattern.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported. Gray level required.");
                    }
                }
            }
        }
    }
}

