/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import characterization.ComputableFeatures;
import characterization.textures.lbp.ContrastLBP;
import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.StructuringElement;

public class LBPVariance
implements ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private LocalBinaryPattern lbp = new LocalBinaryPattern();
    private ContrastLBP clbp = new ContrastLBP();
    private StructuringElement se = null;
    private int mode = 2;
    private double[] histogram = null;
    private String[] names = null;
    private BufferedImage resultlbp = null;
    private BufferedImage resultconlbp = null;

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (mask != null) {
            throw new Error("Mask not supported (yet).");
        }
        this.Compute(source, this.se, nbCPU);
    }

    public void Compute(BufferedImage source, StructuringElement se, int nbCPU) {
        int x;
        this.setStructuringElement(se);
        int width = source.getWidth();
        int height = source.getHeight();
        int orderx = se.getSizeX() >> 1;
        int ordery = se.getSizeY() >> 1;
        int endx = width - orderx;
        int endy = height - ordery;
        if (this.resultlbp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.resultlbp)) {
            this.resultconlbp = null;
            this.resultlbp = null;
            this.resultlbp = ImageNew.Integer((int)width, (int)height, (int)1);
            this.resultconlbp = ImageNew.Double((int)width, (int)height, (int)1);
        }
        if (this.histogram == null || this.histogram.length != this.lbp.getMaximumValueLut() + 1) {
            this.histogram = null;
            this.histogram = new double[this.lbp.getMaximumValueLut() + 1];
            this.names = null;
            this.names = new String[this.lbp.getMaximumValueLut() + 1];
            for (x = 0; x < this.names.length; ++x) {
                this.names[x] = "Column " + (x < 10 ? "00" : (x < 100 ? "0" : "")) + x;
            }
        } else {
            Arrays.fill(this.histogram, 0.0);
        }
        this.lbp.Filter(source, se, this.resultlbp, nbCPU);
        this.clbp.Filter(source, se, this.resultconlbp, nbCPU);
        int[] reslbp = ((DataBufferInt)this.resultlbp.getRaster().getDataBuffer()).getData();
        double[] resconlbp = ((DataBufferDouble)this.resultconlbp.getRaster().getDataBuffer()).getData();
        for (int y = ordery; y < endy; ++y) {
            x = orderx;
            int pos = y * width + x;
            while (x < endx) {
                int n = reslbp[pos];
                this.histogram[n] = this.histogram[n] + resconlbp[pos];
                ++x;
                ++pos;
            }
        }
        int nb = (endx - orderx) * (endy - ordery);
        ArrayArithmetic.Divide((double[])this.histogram, (double)nb, (double[])this.histogram);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setUniform(int mode) {
        this.lbp.setUniform(mode);
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.lbp.setStructuringElement(se);
        this.clbp.setStructuringElement(se);
        this.se = se;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.setUniform((Integer)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.se);
        params.add(this.mode);
        return params;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    @Override
    public synchronized void Kill() {
        this.lbp.Kill();
        this.lbp = null;
        this.clbp.Kill();
        this.clbp = null;
        this.se = null;
        this.histogram = null;
        this.names = null;
        this.resultconlbp = null;
        this.resultlbp = null;
    }
}

