/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import characterization.ComputableFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.StructuringElement;

public class FuzzyLBP
implements ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private StructuringElement se = null;
    private int[] Lut = null;
    private int nbFreeThreads = 0;
    private FuzzyLBPThread[] threads = null;
    private int mode;
    private int oldmode = this.mode = 1;
    private int maxlut = -1;
    private double[] histogram = null;
    private String[] names = null;
    private int fuzzyness = -1;
    private int ForbiddenValue = -1;
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (mask != null) {
            throw new Error("Mask not supported (yet).");
        }
        this.Compute(source, this.se, this.fuzzyness, nbCPU);
    }

    public void Compute(BufferedImage source, StructuringElement se, int fuzzyness, int nbCPU) {
        this.Compute(source, se, fuzzyness, this.ForbiddenValue, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Compute(BufferedImage source, StructuringElement se, int fuzzyness, int ForbiddenValue, int nbCPU) {
        Object object;
        int i2;
        this.setStructuringElement(se);
        this.setFuzzyness(fuzzyness);
        this.ForbiddenValue = ForbiddenValue;
        int width = source.getWidth();
        int height = source.getHeight();
        int orderx = se.getSizeX() >> 1;
        int ordery = se.getSizeY() >> 1;
        int endx = width - orderx;
        int endy = height - ordery;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new FuzzyLBPThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new FuzzyLBPThread();
                this.threads[i2].start();
            }
            FuzzyLBP fuzzyLBP = this;
            synchronized (fuzzyLBP) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, se, fuzzyness, i2 * step, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, se, fuzzyness, i2 * step, source.getHeight());
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        for (i2 = 0; i2 < nbCPU; ++i2) {
            ArrayArithmetic.Add((double[])this.threads[i2].hist, (double[])this.histogram, (double[])this.histogram);
        }
        int nb = (endx - orderx) * (endy - ordery);
        ArrayArithmetic.Divide((double[])this.histogram, (double)nb, (double[])this.histogram);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void BuildLut() {
        int size = this.se.getSE().length;
        int length = (int)Math.pow(2.0, size);
        if (this.Lut != null && this.Lut.length == length && this.oldmode == this.mode) {
            return;
        }
        this.Lut = null;
        this.Lut = new int[length];
        LocalBinaryPattern.FillLut(this.Lut, size, this.mode);
        this.oldmode = this.mode;
        this.maxlut = this.AF.Maximum(this.Lut);
        this.histogram = null;
        this.histogram = new double[this.maxlut + 1];
        this.names = null;
        this.names = new String[this.maxlut + 1];
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2] = "Fuzzylbp " + (i2 < 10 ? "00" : (i2 < 100 ? "0" : "")) + i2;
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void setUniform(int mode) {
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public void setFuzzyness(int fuzzyness) {
        if (fuzzyness <= 0) {
            throw new IllegalArgumentException("The fuzzyness must be positive or null.");
        }
        this.fuzzyness = fuzzyness;
    }

    public int getFuzzyness() {
        return this.fuzzyness;
    }

    public int getMaximumValueLut() {
        return this.maxlut;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        this.se = se;
        this.BuildLut();
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.mode = (Integer)parameters[1];
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.setFuzzyness((Integer)parameters[2]);
    }

    public List<Object> Parameters() {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.se);
        params.add(this.mode);
        params.add(this.fuzzyness);
        return params;
    }

    public int[] getLut() {
        return this.Lut;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    @Override
    public synchronized void Kill() {
        if (this.threads == null) {
            return;
        }
        for (FuzzyLBPThread thread : this.threads) {
            thread.Kill();
        }
        this.se = null;
        this.Lut = null;
        this.histogram = null;
        this.names = null;
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = null;
        }
        this.threads = null;
    }

    private class FuzzyLBPThread
    extends Thread {
        private int width;
        private int height;
        private int type;
        private int orderx;
        private int ordery;
        private int nbPoints = 0;
        private int miny;
        private int maxy;
        private CoordinatesWeighted[] seco = null;
        private double[] probabilities;
        private double[] m0;
        private double[] m1;
        private int[] toprocess;
        private int[] lbpcode;
        private int T;
        private short[] shortbufferin = null;
        private byte[] bytebufferin = null;
        public final Object lock = new Object();
        public double[] hist = null;
        private boolean exit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            this.m1 = null;
            this.m0 = null;
            this.probabilities = null;
            this.lbpcode = null;
            this.toprocess = null;
            this.seco = null;
            this.bytebufferin = null;
            this.shortbufferin = null;
            this.hist = null;
            this.interrupt();
        }

        public void setConditions(BufferedImage Original, StructuringElement se, int fuzzyness, int miny, int maxy) {
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.nbPoints = this.seco.length;
            this.T = fuzzyness;
            this.miny = miny;
            this.maxy = maxy;
            if (this.toprocess == null || this.toprocess.length != this.nbPoints) {
                this.lbpcode = null;
                this.toprocess = null;
                this.toprocess = new int[this.nbPoints];
                this.lbpcode = new int[this.nbPoints];
                this.probabilities = null;
                this.m1 = null;
                this.m0 = null;
                this.m0 = new double[this.nbPoints];
                this.m1 = new double[this.nbPoints];
                this.probabilities = new double[this.nbPoints];
            }
            if (this.hist == null || this.hist.length != FuzzyLBP.this.histogram.length) {
                this.hist = new double[FuzzyLBP.this.histogram.length];
            } else {
                Arrays.fill(this.hist, 0.0);
            }
            this.bytebufferin = null;
            this.shortbufferin = null;
            switch (Original.getType()) {
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        FuzzyLBP.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.miny == 0) {
                    this.miny += this.ordery;
                }
                if (this.maxy == this.height) {
                    this.maxy -= this.ordery;
                }
                endx = this.width - this.orderx;
                T2 = this.T << 1;
                switch (this.type) {
                    case 10: {
                        if (FuzzyLBP.this.ForbiddenValue >= 0) ** GOTO lbl54
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                pc = this.bytebufferin[pos] & 255;
                                pcpt = pc + this.T;
                                pcmt = pc - this.T;
                                for (c = 0; c < this.nbPoints; ++c) {
                                    pi = this.bytebufferin[pos + this.seco[c].Pos] & 255;
                                    if (pcpt <= pi) {
                                        this.m0[c] = 0.0;
                                        this.toprocess[c] = 0;
                                    } else if (pi <= pcmt) {
                                        this.m0[c] = 1.0;
                                        this.toprocess[c] = 0;
                                    } else {
                                        this.m0[c] = (double)(this.T - pi + pc) / (double)T2;
                                        this.toprocess[c] = 1;
                                    }
                                    this.m1[c] = 1.0 - this.m0[c];
                                }
                                this.FillHistogram(0);
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
lbl54:
                        // 1 sources

                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                pc = this.bytebufferin[pos] & 255;
                                if (pc != FuzzyLBP.this.ForbiddenValue) {
                                    pcpt = pc + this.T;
                                    pcmt = pc - this.T;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        pi = this.bytebufferin[pos + this.seco[c].Pos] & 255;
                                        if (pcpt == FuzzyLBP.this.ForbiddenValue || pcpt <= pi) {
                                            this.m0[c] = 0.0;
                                            this.toprocess[c] = 0;
                                        } else if (pi <= pcmt) {
                                            this.m0[c] = 1.0;
                                            this.toprocess[c] = 0;
                                        } else {
                                            this.m0[c] = (double)(this.T - pi + pc) / (double)T2;
                                            this.toprocess[c] = 1;
                                        }
                                        this.m1[c] = 1.0 - this.m0[c];
                                    }
                                    this.FillHistogram(0);
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        if (FuzzyLBP.this.ForbiddenValue >= 0) ** GOTO lbl115
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                pc = this.shortbufferin[pos] & 65535;
                                pcpt = pc + this.T;
                                pcmt = pc - this.T;
                                for (c = 0; c < this.nbPoints; ++c) {
                                    pi = this.shortbufferin[pos + this.seco[c].Pos] & 65535;
                                    if (pcpt <= pi) {
                                        this.m0[c] = 0.0;
                                        this.toprocess[c] = 0;
                                    } else if (pi <= pcmt) {
                                        this.m0[c] = 1.0;
                                        this.toprocess[c] = 0;
                                    } else {
                                        this.m0[c] = (double)(this.T - pi + pc) / (double)T2;
                                        this.toprocess[c] = 1;
                                    }
                                    this.m1[c] = 1.0 - this.m0[c];
                                }
                                this.FillHistogram(0);
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
lbl115:
                        // 1 sources

                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                pc = this.shortbufferin[pos] & 65535;
                                if (pc != FuzzyLBP.this.ForbiddenValue) {
                                    pcpt = pc + this.T;
                                    pcmt = pc - this.T;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        pi = this.shortbufferin[pos + this.seco[c].Pos] & 65535;
                                        if (pcpt == FuzzyLBP.this.ForbiddenValue || pcpt <= pi) {
                                            this.m0[c] = 0.0;
                                            this.toprocess[c] = 0;
                                        } else if (pi <= pcmt) {
                                            this.m0[c] = 1.0;
                                            this.toprocess[c] = 0;
                                        } else {
                                            this.m0[c] = (double)(this.T - pi + pc) / (double)T2;
                                            this.toprocess[c] = 1;
                                        }
                                        this.m1[c] = 1.0 - this.m0[c];
                                    }
                                    this.FillHistogram(0);
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported. Gray level required.");
                    }
                }
                break;
            }
        }

        private void FillHistogram(int position) {
            if (position == this.nbPoints) {
                int code = 0;
                double p = 1.0;
                for (int i2 = 0; i2 < this.nbPoints; ++i2) {
                    code <<= 1;
                    code += this.lbpcode[i2];
                    p *= this.probabilities[i2];
                }
                int n = FuzzyLBP.this.Lut[code];
                this.hist[n] = this.hist[n] + p;
                return;
            }
            if (this.toprocess[position] == 0) {
                this.lbpcode[position] = this.m1[position] < 0.5 ? 0 : 1;
                this.probabilities[position] = 1.0;
                this.FillHistogram(position + 1);
                return;
            }
            this.lbpcode[position] = 0;
            this.probabilities[position] = this.m0[position];
            this.FillHistogram(position + 1);
            this.lbpcode[position] = 1;
            this.probabilities[position] = this.m1[position];
            this.FillHistogram(position + 1);
        }
    }
}

