/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import characterization.ComputableFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.statisticalmatrices.com.Haralick;
import dv.DV;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morphee.StructuringElement;
import processing.reducer.ColorReducer;
import processing.reducer.LinearGLR;

public class CooccurrenceLBP
implements ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    public static final int NORMAL = 11;
    public static final int HARALICK = 13;
    private LocalBinaryPattern lbp = new LocalBinaryPattern();
    public Haralick haralick = new Haralick();
    private StructuringElement se = null;
    private int uniform = 2;
    private int modefeatures = 11;
    private double[] features = null;
    private String[] names = null;
    private int[][] matDr0;
    private int[][] matDrDr;
    private int[][] mat0Dr;
    private int[][] matmDrDr;
    private BufferedImage resultlbp = null;
    private LinearGLR reducer = new LinearGLR();
    private int delta = -1;
    private int[] dx;
    private int[] dy;

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (mask != null) {
            throw new Error("Mask not supported (yet).");
        }
        this.Compute(source, mask, this.se, ForbiddenValue, this.delta, nbCPU);
    }

    public void Compute(BufferedImage source, BufferedImage mask, StructuringElement se, int ForbiddenValue, int delta, int nbCPU) {
        this.BuildDisplacements(delta);
        this.setStructuringElement(se);
        int width = source.getWidth();
        int height = source.getHeight();
        int orderx = se.getSizeX() >> 1;
        int ordery = se.getSizeY() >> 1;
        int deltawidth = delta * width;
        if (this.resultlbp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.resultlbp)) {
            this.resultlbp = null;
            this.resultlbp = ImageNew.Integer((int)width, (int)height, (int)1);
        }
        BufferedImage image = null;
        if (mask != null) {
            image = ImageNew.Clone((BufferedImage)source);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)source, (int)ForbiddenValue, (BufferedImage)image);
        } else {
            image = source;
        }
        this.lbp.Filter(image, se, this.resultlbp, nbCPU);
        int maxgray = source.getType() == 10 ? 256 : 65536;
        switch (this.modefeatures) {
            case 11: {
                int x;
                int y;
                int[] reslbp = ((DataBufferInt)this.resultlbp.getRaster().getDataBuffer()).getData();
                int size = this.lbp.getMaximumValueLut() + 1;
                if (this.matDr0 == null || this.matDr0.length != size) {
                    this.matmDrDr = null;
                    this.mat0Dr = null;
                    this.matDrDr = null;
                    this.matDr0 = null;
                    this.matDr0 = new int[size][size];
                    this.matDrDr = new int[size][size];
                    this.mat0Dr = new int[size][size];
                    this.matmDrDr = new int[size][size];
                    this.features = new double[4 * size * size];
                } else {
                    Arrays.fill((Object[])this.matDr0, (Object)0);
                    Arrays.fill((Object[])this.matDrDr, (Object)0);
                    Arrays.fill((Object[])this.mat0Dr, (Object)0);
                    Arrays.fill((Object[])this.matmDrDr, (Object)0);
                    Arrays.fill(this.features, 0.0);
                }
                int endx = width - orderx - delta;
                int endy = height - ordery - delta;
                for (int y2 = ordery; y2 < endy; ++y2) {
                    int x2 = orderx;
                    int pos = y2 * width + x2;
                    while (x2 < endx) {
                        int v0 = reslbp[pos];
                        int vd0 = reslbp[pos + delta];
                        int v0d = reslbp[pos + deltawidth];
                        int vdd = reslbp[pos + deltawidth + delta];
                        int[] nArray = this.matDr0[v0];
                        int n = vd0;
                        nArray[n] = nArray[n] + 1;
                        int[] nArray2 = this.matDr0[v0d];
                        int n2 = vdd;
                        nArray2[n2] = nArray2[n2] + 1;
                        int[] nArray3 = this.mat0Dr[v0];
                        int n3 = v0d;
                        nArray3[n3] = nArray3[n3] + 1;
                        int[] nArray4 = this.mat0Dr[vd0];
                        int n4 = vdd;
                        nArray4[n4] = nArray4[n4] + 1;
                        int[] nArray5 = this.matDrDr[v0];
                        int n5 = vdd;
                        nArray5[n5] = nArray5[n5] + 1;
                        int[] nArray6 = this.matmDrDr[vd0];
                        int n6 = v0d;
                        nArray6[n6] = nArray6[n6] + 1;
                        ++x2;
                        ++pos;
                    }
                }
                int nb = 0;
                int pos = 0;
                for (y = 0; y < size; ++y) {
                    x = 0;
                    while (x < size) {
                        nb += this.matDr0[y][x];
                        this.features[pos] = this.matDr0[y][x];
                        ++x;
                        ++pos;
                    }
                }
                for (y = 0; y < size; ++y) {
                    x = 0;
                    while (x < size) {
                        nb += this.mat0Dr[y][x];
                        this.features[pos] = this.mat0Dr[y][x];
                        ++x;
                        ++pos;
                    }
                }
                for (y = 0; y < size; ++y) {
                    x = 0;
                    while (x < size) {
                        nb += this.matDrDr[y][x];
                        this.features[pos] = this.matDrDr[y][x];
                        ++x;
                        ++pos;
                    }
                }
                for (y = 0; y < size; ++y) {
                    x = 0;
                    while (x < size) {
                        nb += this.matmDrDr[y][x];
                        this.features[pos] = this.matmDrDr[y][x];
                        ++x;
                        ++pos;
                    }
                }
                ArrayArithmetic.Divide((double[])this.features, (double)nb, (double[])this.features);
                break;
            }
            case 13: {
                this.haralick.Compute(this.resultlbp, mask, (ColorReducer)this.reducer, maxgray, -1, this.dx, this.dy);
                this.features = this.haralick.Features();
                this.names = this.haralick.FeaturesNames();
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode of features extraction unknown.");
            }
        }
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setUniform(int uniform) {
        this.lbp.setUniform(uniform);
        this.uniform = uniform;
    }

    public int getUniform() {
        return this.uniform;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.lbp.setStructuringElement(se);
        this.se = se;
    }

    private void BuildDisplacements(int delta) {
        if (delta <= 0) {
            throw new IllegalArgumentException("delta <= 0.");
        }
        if (this.delta == delta) {
            return;
        }
        this.delta = delta;
        this.dx = new int[]{delta, delta, 0, -delta};
        this.dy = new int[]{0, delta, delta, delta};
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 4 parameters required.");
        }
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.setUniform((Integer)parameters[1]);
        this.modefeatures = (Integer)parameters[2];
        this.BuildDisplacements((Integer)parameters[3]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.se);
        params.add(this.uniform);
        params.add(this.modefeatures);
        params.add(this.delta);
        return params;
    }

    @Override
    public double[] Features() {
        return this.features;
    }

    @Override
    public double Feature(int x) {
        return this.features[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    @Override
    public synchronized void Kill() {
        this.lbp.Kill();
        this.lbp = null;
        this.haralick = null;
        this.se = null;
        this.features = null;
        this.names = null;
        this.matmDrDr = null;
        this.mat0Dr = null;
        this.matDrDr = null;
        this.matDr0 = null;
        this.resultlbp = null;
        this.reducer = null;
        this.dy = null;
        this.dx = null;
    }
}

