/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import characterization.ComputableFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class CenterSymmetricLBP
implements MorphoFilter,
ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private StructuringElement se = null;
    private int[] Lut = null;
    private int maxlut = -1;
    private int T = 25;
    private int[] res = null;
    private int nbFreeThreads = 0;
    private CenterSymmetricLBPThread[] threads = null;
    private double[] histogram = null;
    private String[] names = null;
    private int mode;
    private int oldmode = this.mode = 2;
    private final ArrayFeatures AF = new ArrayFeatures();
    private BufferedImage imtmp = null;

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (mask != null) {
            throw new Error("Mask not supported (yet).");
        }
        if (this.imtmp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        }
        this.Filter(source, this.se, this.imtmp, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, this.se, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.se, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        Object e2;
        int i2;
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different dimension.");
        }
        if (result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The result image must have a DataBuffer of type Integer.");
        }
        if (result.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The result image must have 1 channel/band/bank.");
        }
        this.setStructuringElement(se);
        if (this.histogram == null || this.histogram.length != this.maxlut + 1) {
            this.histogram = null;
            this.histogram = new double[this.maxlut + 1];
            this.names = null;
            this.names = new String[this.maxlut + 1];
            for (i2 = 0; i2 < this.names.length; ++i2) {
                this.names[i2] = "CSlbp_" + (i2 < 10 ? "00" : (i2 < 100 ? "0" : "")) + i2;
            }
        } else {
            Arrays.fill(this.histogram, 0.0);
        }
        this.res = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        Arrays.fill(this.res, -1);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new CenterSymmetricLBPThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new CenterSymmetricLBPThread();
                this.threads[i2].start();
            }
            CenterSymmetricLBP centerSymmetricLBP = this;
            synchronized (centerSymmetricLBP) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = source.getHeight() / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, se, i2 * step, (i2 + 1) * step);
            e2 = this.threads[i2].lock;
            synchronized (e2) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, se, i2 * step, source.getHeight());
        e2 = this.threads[i2].lock;
        synchronized (e2) {
            this.threads[i2].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int orderx = se.getSizeX() >> 1;
        int ordery = se.getSizeY() >> 1;
        int endx = width - orderx;
        int endy = height - ordery;
        int nb = (endx - orderx) * (endy - ordery);
        ArrayArithmetic.Divide((double[])this.histogram, (double)nb, (double[])this.histogram);
    }

    private void BuildLut() {
        int size = this.se.getSE().length >> 1;
        int length = (int)Math.pow(2.0, size);
        if (this.Lut != null && this.Lut.length == length && this.oldmode == this.mode) {
            return;
        }
        this.Lut = null;
        this.Lut = new int[length];
        LocalBinaryPattern.FillLut(this.Lut, size, this.mode);
        this.oldmode = this.mode;
        this.maxlut = this.AF.Maximum(this.Lut);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void setThreshold(int Threshold) {
        if (Threshold < 0) {
            throw new IllegalArgumentException("Positive or null threshold required.");
        }
        this.T = Threshold;
    }

    public int getThreshold() {
        return this.T;
    }

    public void setUniform(int mode) {
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public int getMaximumValueLut() {
        return this.maxlut;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        if (se.getSE().length % 2 != 0) {
            throw new IllegalArgumentException("Pair number of point in the structuring element required.");
        }
        this.se = se;
        this.BuildLut();
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int BorderEffectSizeX() {
        if (this.se != null) {
            return this.se.getSizeX();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.se != null) {
            return this.se.getSizeY();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.mode = (Integer)parameters[1];
        this.setStructuringElement((StructuringElement)parameters[0]);
        this.setThreshold((Integer)parameters[2]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.se);
        params.add(this.mode);
        params.add(this.T);
        return params;
    }

    public int[] getLut() {
        return this.Lut;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    @Override
    public synchronized void Kill() {
        if (this.threads == null) {
            return;
        }
        for (CenterSymmetricLBPThread thread : this.threads) {
            thread.Kill();
        }
        this.se = null;
        this.Lut = null;
        this.res = null;
        this.histogram = null;
        this.names = null;
        this.imtmp = null;
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = null;
        }
        this.threads = null;
    }

    private class CenterSymmetricLBPThread
    extends Thread {
        private int width;
        private int height;
        private int type;
        private int orderx;
        private int ordery;
        private int nbPoints = 0;
        private int miny;
        private int maxy;
        private CoordinatesWeighted[] seco = null;
        private short[] shortbufferin = null;
        private byte[] bytebufferin = null;
        public final Object lock = new Object();
        private boolean exit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            this.seco = null;
            this.bytebufferin = null;
            this.shortbufferin = null;
            this.interrupt();
        }

        public void setConditions(BufferedImage Original, StructuringElement se, int miny, int maxy) {
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.nbPoints = this.seco.length >> 1;
            this.miny = miny;
            this.maxy = maxy;
            this.bytebufferin = null;
            this.shortbufferin = null;
            switch (Original.getType()) {
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: while (true) lbl-1000:
            // 3 sources

            {
                var4_5 = this.lock;
                synchronized (var4_5) {
                    try {
                        CenterSymmetricLBP.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.miny == 0) {
                    this.miny += this.ordery;
                }
                if (this.maxy == this.height) {
                    this.maxy -= this.ordery;
                }
                endx = this.width - this.orderx;
                switch (this.type) {
                    case 10: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) ** GOTO lbl-1000
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                val = 0;
                                for (c = 0; c < this.nbPoints; ++c) {
                                    val <<= 1;
                                    c0 = this.seco[c];
                                    c1 = this.seco[c + this.nbPoints];
                                    v1 = this.bytebufferin[pos + c1.Y * this.width + c1.X] & 255;
                                    v0 = this.bytebufferin[pos + c0.Y * this.width + c0.X] & 255;
                                    if (CenterSymmetricLBP.this.T >= Math.abs(v1 - v0)) continue;
                                    ++val;
                                }
                                CenterSymmetricLBP.this.res[pos] = CenterSymmetricLBP.this.Lut[val];
                                v0 = CenterSymmetricLBP.this.Lut[val];
                                CenterSymmetricLBP.this.histogram[v0] = CenterSymmetricLBP.this.histogram[v0] + 1.0;
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                val = 0;
                                for (c = 0; c < this.nbPoints; ++c) {
                                    val <<= 1;
                                    c0 = this.seco[c];
                                    c1 = this.seco[c + this.nbPoints];
                                    v1 = this.shortbufferin[pos + c1.Y * this.width + c1.X] & 65535;
                                    v0 = this.shortbufferin[pos + c0.Y * this.width + c0.X] & 65535;
                                    if (CenterSymmetricLBP.this.T >= Math.abs(v1 - v0)) continue;
                                    ++val;
                                }
                                CenterSymmetricLBP.this.res[pos] = CenterSymmetricLBP.this.Lut[val];
                                v1 = CenterSymmetricLBP.this.Lut[val];
                                CenterSymmetricLBP.this.histogram[v1] = CenterSymmetricLBP.this.histogram[v1] + 1.0;
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported. Gray level required.");
                    }
                }
                break;
            }
        }
    }
}

