/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.lbp;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import characterization.ComputableFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import dv.DV;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class AverageLBP
implements MorphoFilter,
ComputableFeatures {
    public static final int CLASSICAL = 0;
    public static final int UNIFORM = 1;
    public static final int UNIFORM2 = 2;
    private StructuringElement se = null;
    private int[] Lut = null;
    private int[] res = null;
    private int nbFreeThreads = 0;
    private LocalBinaryPatternThread[] threads = null;
    private double[] histogram = null;
    private String[] names = null;
    private int mode;
    private int oldmode = this.mode = 1;
    private int maxlut = -1;
    private int ForbiddenValue = -1;
    private int nbPixelProcessed;
    private BufferedImage imtmp = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public synchronized void Kill() {
        if (this.threads == null) {
            return;
        }
        for (LocalBinaryPatternThread thread : this.threads) {
            thread.Kill();
        }
        this.se = null;
        this.Lut = null;
        this.res = null;
        this.histogram = null;
        this.names = null;
        this.imtmp = null;
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = null;
        }
        this.threads = null;
    }

    @Override
    public void Compute(BufferedImage source, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.imtmp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        }
        this.Filter(source, mask, this.se, ForbiddenValue, this.imtmp, nbCPU);
    }

    public void Compute(BufferedImage source, BufferedImage mask, StructuringElement se, int ForbiddenValue, int nbCPU) {
        if (this.imtmp == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imtmp)) {
            this.imtmp = null;
            this.imtmp = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        }
        this.Filter(source, mask, se, ForbiddenValue, this.imtmp, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, this.se, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.se, result, nbCPU);
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.Filter(source, null, se, this.ForbiddenValue, result, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage mask, StructuringElement se, int ForbiddenValue, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different dimension.");
        }
        if (result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The result image must have a DataBuffer of type Integer.");
        }
        if (result.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The result image must have 1 channel/band/bank.");
        }
        this.setStructuringElement(se);
        se.PreComputePositions(source.getWidth());
        this.ForbiddenValue = ForbiddenValue;
        BufferedImage image = null;
        if (mask != null) {
            image = ImageNew.Clone((BufferedImage)source);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)source, (int)ForbiddenValue, (BufferedImage)image);
        } else {
            image = source;
        }
        Arrays.fill(this.histogram, 0.0);
        this.res = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        Arrays.fill(this.res, -1);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new LocalBinaryPatternThread[nbCPU];
            for (int i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new LocalBinaryPatternThread();
                this.threads[i2].start();
            }
            AverageLBP i2 = this;
            synchronized (i2) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = image.getHeight() / nbCPU;
        for (int i3 = 0; i3 < nbCPU - 1; ++i3) {
            this.threads[i3].setConditions(image, se, i3 * step, (i3 + 1) * step);
            Object object = this.threads[i3].lock;
            synchronized (object) {
                this.threads[i3].lock.notify();
                continue;
            }
        }
        this.threads[nbCPU - 1].setConditions(image, se, (nbCPU - 1) * step, image.getHeight());
        Object i3 = this.threads[nbCPU - 1].lock;
        synchronized (i3) {
            this.threads[nbCPU - 1].lock.notify();
        }
        i3 = this;
        synchronized (i3) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        for (int i4 = 0; i4 < nbCPU; ++i4) {
            ArrayArithmetic.Add((double[])this.threads[i4].hist, (double[])this.histogram, (double[])this.histogram);
            this.nbPixelProcessed += this.threads[i4].nbpixel;
        }
        ArrayArithmetic.Divide((double[])this.histogram, (double)this.nbPixelProcessed, (double[])this.histogram);
    }

    private void BuildLut() {
        int size = this.se.getSE().length;
        int length = (int)Math.pow(2.0, size);
        if (this.Lut != null && this.Lut.length == length && this.oldmode == this.mode) {
            return;
        }
        this.Lut = null;
        this.Lut = new int[length];
        LocalBinaryPattern.FillLut(this.Lut, size, this.mode);
        this.oldmode = this.mode;
        this.maxlut = this.AF.Maximum(this.Lut);
        this.histogram = null;
        this.histogram = new double[this.maxlut + 1];
        this.names = null;
        this.names = new String[this.maxlut + 1];
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2] = "Albp " + (i2 < 10 ? "00" : (i2 < 100 ? "0" : "")) + i2;
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void setUniform(int mode) {
        this.mode = mode;
    }

    public int getUniform() {
        return this.mode;
    }

    public int getMaximumValueLut() {
        return this.maxlut;
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        if (se == null || se.getType() != -13) {
            throw new IllegalArgumentException("LBP structuring element required.");
        }
        this.se = se;
        this.BuildLut();
    }

    public StructuringElement3D getStructuringElement3D() {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.mode = (Integer)parameters[1];
        this.setStructuringElement((StructuringElement)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.se);
        params.add(this.mode);
        return params;
    }

    public int[] getLut() {
        return this.Lut;
    }

    @Override
    public double[] Features() {
        return this.histogram;
    }

    @Override
    public double Feature(int x) {
        return this.histogram[x];
    }

    @Override
    public String[] FeaturesNames() {
        return this.names;
    }

    public int BorderEffectSizeX() {
        if (this.se != null) {
            return this.se.getSizeX();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.se != null) {
            return this.se.getSizeY();
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public MorphoFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class LocalBinaryPatternThread
    extends Thread {
        private int width;
        private int height;
        private int type;
        private int orderx;
        private int ordery;
        private int nbPoints = 0;
        private int miny;
        private int maxy;
        private int[] buffer = null;
        private CoordinatesWeighted[] seco = null;
        private short[] shortbufferin = null;
        private byte[] bytebufferin = null;
        public final Object lock = new Object();
        public double[] hist = null;
        private int nbpixel;
        private boolean exit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.exit = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            this.buffer = null;
            this.seco = null;
            this.bytebufferin = null;
            this.shortbufferin = null;
            this.hist = null;
            this.interrupt();
        }

        public void setConditions(BufferedImage Original, StructuringElement se, int miny, int maxy) {
            this.type = Original.getType();
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.seco = se.getSE();
            this.orderx = se.getSizeX() >> 1;
            this.ordery = se.getSizeY() >> 1;
            this.nbPoints = this.seco.length;
            this.miny = miny;
            this.maxy = maxy;
            this.bytebufferin = null;
            this.shortbufferin = null;
            if (this.hist == null || this.hist.length != AverageLBP.this.histogram.length) {
                this.hist = new double[AverageLBP.this.histogram.length];
            } else {
                Arrays.fill(this.hist, 0.0);
            }
            if (this.buffer == null || this.buffer.length != se.getSE().length) {
                this.buffer = null;
                this.buffer = new int[se.getSE().length];
            }
            switch (Original.getType()) {
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        AverageLBP.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.exit) {
                    return;
                }
                if (this.miny == 0) {
                    this.miny += this.ordery;
                }
                if (this.maxy == this.height) {
                    this.maxy -= this.ordery;
                }
                int endx = this.width - this.orderx;
                switch (this.type) {
                    case 10: {
                        int p;
                        int val;
                        double ave;
                        int v;
                        int c;
                        int sum;
                        int pos;
                        int x;
                        int y;
                        if (AverageLBP.this.ForbiddenValue < 0) {
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = this.orderx;
                                pos = y * this.width + x;
                                while (x < endx) {
                                    sum = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        this.buffer[c] = v = this.bytebufferin[pos + this.seco[c].Pos] & 0xFF;
                                        sum += v;
                                    }
                                    ave = (double)sum / (double)this.nbPoints;
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        if ((double)this.buffer[c] < ave) continue;
                                        ++val;
                                    }
                                    AverageLBP.this.res[pos] = v = AverageLBP.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                    ++x;
                                    ++pos;
                                }
                            }
                            this.nbpixel = (endx - this.orderx) * (this.maxy - this.miny);
                            break;
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                if ((this.bytebufferin[pos] & 0xFF) != AverageLBP.this.ForbiddenValue) {
                                    sum = 0;
                                    p = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        v = this.bytebufferin[pos + this.seco[c].Pos] & 0xFF;
                                        if (v == AverageLBP.this.ForbiddenValue) continue;
                                        this.buffer[p++] = v;
                                        sum += v;
                                    }
                                    if (p == 0) {
                                        AverageLBP.this.res[pos] = 1;
                                        this.hist[1] = this.hist[1] + 1.0;
                                    } else {
                                        ave = (double)sum / (double)p;
                                        val = 0;
                                        for (c = 0; c < p; ++c) {
                                            val <<= 1;
                                            if ((double)this.buffer[c] < ave) continue;
                                            ++val;
                                        }
                                        AverageLBP.this.res[pos] = v = AverageLBP.this.Lut[val];
                                        int n = v;
                                        this.hist[n] = this.hist[n] + 1.0;
                                        ++this.nbpixel;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        int p;
                        int val;
                        double ave;
                        int v;
                        int c;
                        int sum;
                        int pos;
                        int x;
                        int y;
                        if (AverageLBP.this.ForbiddenValue < 0) {
                            for (y = this.miny; y < this.maxy; ++y) {
                                x = this.orderx;
                                pos = y * this.width + x;
                                while (x < endx) {
                                    sum = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        this.buffer[c] = v = this.shortbufferin[pos + this.seco[c].Pos] & 0xFFFF;
                                        sum += v;
                                    }
                                    ave = sum / this.nbPoints;
                                    val = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        val <<= 1;
                                        if ((double)this.buffer[c] < ave) continue;
                                        ++val;
                                    }
                                    AverageLBP.this.res[pos] = v = AverageLBP.this.Lut[val];
                                    int n = v;
                                    this.hist[n] = this.hist[n] + 1.0;
                                    ++x;
                                    ++pos;
                                }
                            }
                            this.nbpixel = (endx - this.orderx) * (this.maxy - this.miny);
                            break;
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block9;
                            x = this.orderx;
                            pos = y * this.width + x;
                            while (x < endx) {
                                if ((this.shortbufferin[pos] & 0xFFFF) != AverageLBP.this.ForbiddenValue) {
                                    sum = 0;
                                    p = 0;
                                    for (c = 0; c < this.nbPoints; ++c) {
                                        v = this.shortbufferin[pos + this.seco[c].Pos] & 0xFFFF;
                                        if (v == AverageLBP.this.ForbiddenValue) continue;
                                        this.buffer[p++] = v;
                                        sum += v;
                                    }
                                    if (p == 0) {
                                        AverageLBP.this.res[pos] = 1;
                                        this.hist[1] = this.hist[1] + 1.0;
                                    } else {
                                        ave = (double)sum / (double)p;
                                        val = 0;
                                        for (c = 0; c < p; ++c) {
                                            val <<= 1;
                                            if ((double)this.buffer[c] < ave) continue;
                                            ++val;
                                        }
                                        AverageLBP.this.res[pos] = v = AverageLBP.this.Lut[val];
                                        int n = v;
                                        this.hist[n] = this.hist[n] + 1.0;
                                        ++this.nbpixel;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported. Gray level required.");
                    }
                }
            }
        }
    }
}

