/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.detectors.points.corners;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import processing.filters.SignalFilter;

public class FAST
implements SignalFilter {
    private int[][] circle16 = new int[][]{{0, -3}, {1, -3}, {2, -2}, {3, -1}, {3, 0}, {3, 1}, {2, 2}, {1, 3}, {0, 3}, {-1, 3}, {-2, 2}, {-3, 1}, {-3, 0}, {-3, -1}, {-2, -2}, {-1, -3}};
    private List<CoordinatesWeighted> corners = new ArrayList<CoordinatesWeighted>(1000);
    private double Sensitivity = -1.0;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.Sensitivity < 0.0) {
            throw new IllegalArgumentException("Parameters not defined.");
        }
        this.Filter(source, this.Sensitivity, result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, double sensitivity, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, sensitivity, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, double sensitivity, BufferedImage result, int nbCPU) {
        switch (source.getType()) {
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Only type BYTE_GRAY supported.");
            }
        }
        this.corners.clear();
        this.findCorners(source, 0, sensitivity);
        if (result == null) {
            return;
        }
        ImageOperations.Fill((BufferedImage)result, (int)0);
        Iterator<CoordinatesWeighted> iter = this.corners.iterator();
        System.out.println("Size = " + this.corners.size());
        while (iter.hasNext()) {
            CoordinatesWeighted p = iter.next();
            result.getRaster().setSample(p.X, p.Y, 0, p.Wi);
            p = null;
        }
        iter = null;
    }

    private void findCorners(BufferedImage input, int band, double factor) {
        int R;
        int i2;
        int x;
        int y;
        if (Double.compare(factor, 0.0) <= 0 || 4.0 < factor) {
            throw new IllegalArgumentException("Sensitivity must be in ]0.0, 4.0].");
        }
        int width = input.getWidth();
        int height = input.getHeight();
        double X = 0.0;
        double X2 = 0.0;
        double COUNT = 0.0;
        WritableRaster raster = input.getRaster();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                i2 = raster.getSample(x, y, band);
                X += (double)i2;
                X2 += (double)(i2 * i2);
                COUNT += 1.0;
            }
        }
        double variance = X2 / COUNT - X * X / (COUNT * COUNT);
        double stddev = Math.sqrt(variance);
        int T = (int)(stddev * factor);
        for (y = R = 3; y < height - R; ++y) {
            for (x = R; x < width - R; ++x) {
                int s;
                int p = raster.getSample(x, y, band);
                int pmt = p - T;
                int ppt = p + T;
                int dcount = 0;
                int bcount = 0;
                for (i2 = 0; i2 < 16; i2 += 4) {
                    s = raster.getSample(x + this.circle16[i2 % 16][0], y + this.circle16[i2 % 16][1], band);
                    if (s < pmt) {
                        ++dcount;
                    }
                    if (s <= ppt) continue;
                    ++bcount;
                }
                if (dcount < 3 && bcount < 3) continue;
                int Vbright = 0;
                int Vdark = 0;
                dcount = 0;
                bcount = 0;
                boolean isPOI = false;
                for (i2 = 0; i2 < 28; ++i2) {
                    s = raster.getSample(x + this.circle16[i2 % 16][0], y + this.circle16[i2 % 16][1], band);
                    if (s < pmt) {
                        if (i2 < 16) {
                            Vdark += pmt - s;
                        }
                        if (++dcount >= 12) {
                            isPOI = true;
                        }
                    } else {
                        dcount = 0;
                    }
                    if (s > ppt) {
                        if (i2 < 16) {
                            Vbright += s - ppt;
                        }
                        if (++bcount < 12) continue;
                        isPOI = true;
                        continue;
                    }
                    bcount = 0;
                }
                if (!isPOI) continue;
                int V = Math.max(Vdark, Vbright);
                this.corners.add(new CoordinatesWeighted(x, y, 0, 0, V));
            }
        }
        Iterator<CoordinatesWeighted> iter = this.corners.iterator();
        int dist2max = 4 * R * R;
        block6: while (iter.hasNext()) {
            CoordinatesWeighted p = iter.next();
            for (CoordinatesWeighted n : this.corners) {
                int dist2;
                if (n == p || (dist2 = (p.X - n.X) * (p.X - n.X) + (p.Y - n.Y) * (p.Y - n.Y)) > dist2max || n.Wi < p.Wi) continue;
                iter.remove();
                continue block6;
            }
        }
    }

    public List<CoordinatesWeighted> Corners() {
        return this.corners;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.Sensitivity = (Double)parameters[0];
        if (this.Sensitivity <= 0.0 || 4.0 < this.Sensitivity) {
            throw new IllegalArgumentException("Incorrect value of Sensitivity. ]0, 4] expected.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.Sensitivity);
        return params;
    }
}

