/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.detectors.points;

import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.filters.SignalFilter;

public class Canny
implements SignalFilter {
    final float ORIENT_SCALE = 40.0f;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] derivative_mag;
    private int[] magnitude;
    private int[] orientation;
    private int threshold1;
    private int threshold2;
    private int widGaussianKernel = -1;
    private float[] af;
    private float[] af1;
    private float[] af2;
    private float[] af3;
    private float[] af4;
    private float[] af5;
    private float[] af6;

    public Canny() {
    }

    public Canny(int SeuilInf, int SeuilSup, int WidGaussianKernel) {
        this.Parameters(SeuilInf, SeuilSup, WidGaussianKernel);
    }

    public BufferedImage Filter(BufferedImage sourceImage, int SeuilInf, int SeuilSup, int WidGaussianKernel, int nbCPU) {
        this.Parameters(SeuilInf, SeuilSup, WidGaussianKernel);
        return this.Filter(sourceImage, nbCPU);
    }

    public BufferedImage Filter(BufferedImage sourceImage, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)sourceImage);
        this.Filter(sourceImage, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.widGaussianKernel < 0) {
            throw new IllegalArgumentException("Set parameters first.");
        }
        this.Filter(source, this.threshold1, this.threshold2, this.widGaussianKernel, result, nbCPU);
    }

    public void Filter(BufferedImage source, int SeuilInf, int SeuilSup, int WidGaussianKernel, BufferedImage result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level image supported.");
        }
        this.Parameters(SeuilInf, SeuilSup, WidGaussianKernel);
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.picsize = this.width * this.height;
        if (this.data == null || this.data.length != this.picsize) {
            this.data = new int[this.picsize];
            this.magnitude = new int[this.picsize];
            this.orientation = new int[this.picsize];
            this.derivative_mag = new int[this.picsize];
        } else {
            Arrays.fill(this.data, 0);
            Arrays.fill(this.magnitude, 0);
            Arrays.fill(this.orientation, 0);
            Arrays.fill(this.derivative_mag, 0);
        }
        float f = 1.0f;
        this.canny_core(source, f, this.widGaussianKernel);
        this.thresholding_tracker(this.threshold1, this.threshold2);
        ImageConverter.ArrayToImage((int[])this.data, (BufferedImage)result);
    }

    private void canny_core(BufferedImage sourceImage, float f, int i2) {
        float f1;
        int k4;
        if (this.af == null || this.af4.length != this.picsize) {
            this.af = new float[this.picsize];
            this.af1 = new float[this.picsize];
            this.af2 = new float[this.picsize];
            this.af3 = new float[this.picsize];
        } else {
            Arrays.fill(this.af, 0.0f);
            Arrays.fill(this.af1, 0.0f);
            Arrays.fill(this.af2, 0.0f);
            Arrays.fill(this.af3, 0.0f);
        }
        if (this.af4 == null || this.af4.length != i2) {
            this.af4 = new float[i2];
            this.af5 = new float[i2];
            this.af6 = new float[i2];
        } else {
            Arrays.fill(this.af4, 0.0f);
            Arrays.fill(this.af5, 0.0f);
            Arrays.fill(this.af6, 0.0f);
        }
        ImageConverter.ImageToArray1D((BufferedImage)sourceImage, (int[])this.data);
        for (k4 = 0; !(k4 >= i2 || (f1 = this.gaussian(k4, f)) <= 0.005f && k4 >= 2); ++k4) {
            float f2 = this.gaussian((float)k4 - 0.5f, f);
            float f3 = this.gaussian((float)k4 + 0.5f, f);
            float f4 = this.gaussian(k4, f * 0.5f);
            this.af4[k4] = (f1 + f2 + f3) / 3.0f / (6.283185f * f * f);
            this.af5[k4] = f3 - f2;
            this.af6[k4] = 1.6f * f4 - f1;
        }
        int j = k4;
        int j1 = this.width - (j - 1);
        int l = this.width * (j - 1);
        int i1 = this.width * (this.height - (j - 1));
        for (int l4 = j - 1; l4 < j1; ++l4) {
            for (int l5 = l; l5 < i1; l5 += this.width) {
                float f8;
                int k1 = l4 + l5;
                float f10 = f8 = (float)this.data[k1] * this.af4[0];
                int l6 = 1;
                int k7 = k1 - this.width;
                int i8 = k1 + this.width;
                while (l6 < j) {
                    f8 += this.af4[l6] * (float)(this.data[k7] + this.data[i8]);
                    f10 += this.af4[l6] * (float)(this.data[k1 - l6] + this.data[k1 + l6]);
                    ++l6;
                    k7 -= this.width;
                    i8 += this.width;
                }
                this.af[k1] = f8;
                this.af1[k1] = f10;
            }
        }
        for (int i5 = j - 1; i5 < j1; ++i5) {
            for (int i6 = l; i6 < i1; i6 += this.width) {
                float f9 = 0.0f;
                int l1 = i5 + i6;
                for (int i7 = 1; i7 < j; ++i7) {
                    f9 += this.af5[i7] * (this.af[l1 - i7] - this.af[l1 + i7]);
                }
                this.af2[l1] = f9;
            }
        }
        for (int j5 = k4; j5 < this.width - k4; ++j5) {
            for (int j6 = l; j6 < i1; j6 += this.width) {
                float f11 = 0.0f;
                int i22 = j5 + j6;
                int j7 = 1;
                int l7 = this.width;
                while (j7 < j) {
                    f11 += this.af5[j7] * (this.af1[i22 - l7] - this.af1[i22 + l7]);
                    ++j7;
                    l7 += this.width;
                }
                this.af3[i22] = f11;
            }
        }
        j1 = this.width - j;
        l = this.width * j;
        i1 = this.width * (this.height - j);
        for (int k5 = j; k5 < j1; ++k5) {
            for (int k6 = l; k6 < i1; k6 += this.width) {
                float f5;
                int j2 = k5 + k6;
                int k2 = j2 - this.width;
                int l2 = j2 + this.width;
                int i3 = j2 - 1;
                int j3 = j2 + 1;
                int k3 = k2 - 1;
                int l3 = k2 + 1;
                int i4 = l2 - 1;
                int j4 = l2 + 1;
                float f6 = this.af2[j2];
                float f7 = this.af3[j2];
                float f12 = this.hypotenuse(f6, f7);
                int k = (int)((double)f12 * 20.0);
                this.derivative_mag[j2] = k >= 256 ? 255 : k;
                float f13 = this.hypotenuse(this.af2[k2], this.af3[k2]);
                float f14 = this.hypotenuse(this.af2[l2], this.af3[l2]);
                float f15 = this.hypotenuse(this.af2[i3], this.af3[i3]);
                float f16 = this.hypotenuse(this.af2[j3], this.af3[j3]);
                float f18 = this.hypotenuse(this.af2[l3], this.af3[l3]);
                float f20 = this.hypotenuse(this.af2[j4], this.af3[j4]);
                float f19 = this.hypotenuse(this.af2[i4], this.af3[i4]);
                float f17 = this.hypotenuse(this.af2[k3], this.af3[k3]);
                if (f6 * f7 <= 0.0f) {
                    if (Math.abs(f6) >= Math.abs(f7)) {
                        float f2;
                        f5 = Math.abs(f6 * f12);
                        if (!(f2 >= Math.abs(f7 * f18 - (f6 + f7) * f16)) || !(f5 > Math.abs(f7 * f19 - (f6 + f7) * f15))) continue;
                    } else {
                        float f3;
                        f5 = Math.abs(f7 * f12);
                        if (!(f3 >= Math.abs(f6 * f18 - (f7 + f6) * f13)) || !(f5 > Math.abs(f6 * f19 - (f7 + f6) * f14))) continue;
                    }
                } else if (Math.abs(f6) >= Math.abs(f7)) {
                    float f4;
                    f5 = Math.abs(f6 * f12);
                    if (!(f4 >= Math.abs(f7 * f20 + (f6 - f7) * f16)) || !(f5 > Math.abs(f7 * f17 + (f6 - f7) * f15))) continue;
                } else {
                    float f8;
                    f5 = Math.abs(f7 * f12);
                    if (!(f8 >= Math.abs(f6 * f20 + (f7 - f6) * f14)) || !(f5 > Math.abs(f6 * f17 + (f7 - f6) * f13))) continue;
                }
                this.magnitude[j2] = this.derivative_mag[j2];
                this.orientation[j2] = (int)(Math.atan2(f7, f6) * 40.0);
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private float hypotenuse(float f, float f1) {
        if (f == 0.0f && f1 == 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(f * f + f1 * f1);
    }

    private float gaussian(float f, float f1) {
        return (float)Math.exp(-f * f / (2.0f * f1 * f1));
    }

    private void thresholding_tracker(int i2, int j) {
        Arrays.fill(this.data, 0);
        int pos = 0;
        for (int l = 0; l < this.width; ++l) {
            int i1 = 0;
            while (i1 < this.height) {
                if (this.magnitude[pos] >= i2) {
                    this.follow(l, i1, pos, j);
                }
                ++i1;
                ++pos;
            }
        }
    }

    private boolean follow(int i2, int j, int pos, int k) {
        int j1 = i2 + 1;
        int k1 = i2 - 1;
        int l1 = j + 1;
        int i22 = j - 1;
        int j2 = pos;
        if (l1 >= this.height) {
            l1 = this.height - 1;
        }
        if (i22 < 0) {
            i22 = 0;
        }
        if (j1 >= this.width) {
            j1 = this.width - 1;
        }
        if (k1 < 0) {
            k1 = 0;
        }
        if (this.data[j2] == 0) {
            this.data[j2] = this.magnitude[j2];
            boolean flag = false;
            for (int l = k1; l <= j1; ++l) {
                for (int i1 = i22; i1 <= l1; ++i1) {
                    int k2 = l + i1 * this.width;
                    if (i1 == j && l == i2 || this.magnitude[k2] < k || !this.follow(l, i1, k2, k)) continue;
                    flag = true;
                    break;
                }
                if (!flag) break;
            }
            return true;
        }
        return false;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.threshold1 = (Integer)parameters[0];
        this.threshold2 = (Integer)parameters[1];
        this.widGaussianKernel = (Integer)parameters[2];
        if (this.widGaussianKernel < 3 || 40 < this.widGaussianKernel) {
            this.widGaussianKernel = -1;
            throw new IllegalArgumentException("The value of the widGaussianKernel is out of its valid range [3, 40].");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.threshold1);
        params.add(this.threshold2);
        params.add(this.widGaussianKernel);
        return params;
    }
}

