/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.detectors.lines;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HoughLine {
    private int Width;
    private int Height = -1;
    private double maxRho;
    private final double maxTheta = Math.PI;
    private int maxIndexTheta;
    private int maxIndexRho;
    private int[][] accumulator;
    private final int[] dx8 = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    private final int[] dy8 = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Transform(BufferedImage image, int threshold) {
        this.Initialize(image.getWidth(), image.getHeight());
        ArrayOperations.Fill((int[][])this.accumulator, (int)0);
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < this.Height; ++y) {
                    for (int x = 0; x < this.Width; ++x) {
                        if (threshold > wr.getSample(x, y, 0)) continue;
                        this.vote(x, y);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < this.Height; ++y) {
                    int x = 0;
                    while (x < this.Width) {
                        if (threshold <= (bb[pos] & 0xFF)) {
                            this.vote(x, y);
                        }
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < this.Height; ++y) {
                    int x = 0;
                    while (x < this.Width) {
                        if (threshold <= (sb[pos] & 0xFFFF)) {
                            this.vote(x, y);
                        }
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    private void Initialize(int width, int height) {
        if (this.Width == width || this.Height == height) {
            return;
        }
        this.Width = width;
        this.Height = height;
        this.maxRho = Math.sqrt(width * width + height * height);
        this.maxIndexTheta = 360;
        this.maxIndexRho = (int)(1.0 + this.maxRho);
        this.accumulator = null;
        this.accumulator = new int[this.maxIndexRho][this.maxIndexTheta];
    }

    private void vote(int x, int y) {
        x -= this.Width >> 1;
        y -= this.Height >> 1;
        for (int indexTheta = 0; indexTheta < this.maxIndexTheta; ++indexTheta) {
            double theta = this.IndexToTheta(indexTheta);
            double rho = (double)x * Math.cos(theta) + (double)y * Math.sin(theta);
            int indexRho = this.RhoToIndex(rho);
            if (indexTheta >= this.maxIndexTheta || indexRho >= this.maxIndexRho) continue;
            int[] nArray = this.accumulator[indexRho];
            int n = indexTheta;
            nArray[n] = nArray[n] + 1;
        }
    }

    public void Lines(BufferedImage result, int Threshold, int Radius, BufferedImage HoughSpace) {
        if (this.Height <= 0) {
            throw new IllegalArgumentException("Call method transform first in order to fill the accumulator.");
        }
        if (result.getWidth() != this.Width || result.getHeight() != this.Height) {
            throw new IllegalArgumentException("The image used to fill the accumulator had different dimensions than 'result' image.");
        }
        if (HoughSpace != null && HoughSpace.getType() != 1) {
            throw new IllegalArgumentException("The HoughSpace image must be of type TYPE_INT_RGB.");
        }
        List<double[]> winners = this.Winners(Threshold, Radius);
        int num = 0;
        Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.PINK};
        Point A = new Point();
        Point B = new Point();
        for (double[] winner : winners) {
            double rho = winner[0];
            double theta = winner[1];
            Color color = colors[num++ % colors.length];
            double[] c = this.RhoTheta_To_AB(rho, theta);
            if (Double.isNaN(c[0])) {
                A.setLocation((int)c[1], 0);
                B.setLocation((int)c[1], this.Height);
                this.drawSegment(result, A, B, color);
            } else {
                A.setLocation(0, (int)c[1]);
                B.setLocation(this.Width, (int)(c[0] * (double)this.Width + c[1]));
                this.drawSegment(result, A, B, color);
            }
            if (HoughSpace != null) {
                Point center = new Point(this.ThetaToIndex(theta), this.RhoToIndex(rho));
                this.drawCircle(HoughSpace, center, Radius, color);
            }
            c = null;
            color = null;
        }
        winners.clear();
        winners = null;
        B = null;
        A = null;
    }

    private void drawCircle(BufferedImage image, Point center, int radius, Color c) {
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(c);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(center.x - radius, center.y - radius, radius << 1, radius << 1);
        g2d = null;
    }

    private void drawSegment(BufferedImage image, Point A, Point B, Color c) {
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(c);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawLine(A.x, A.y, B.x, B.y);
        g2d = null;
    }

    public int RhoToIndex(double rho) {
        return (int)(0.5 + (rho / this.maxRho + 0.5) * (double)this.maxIndexRho);
    }

    public double IndexToRho(int index) {
        return ((double)index / (double)this.maxIndexRho - 0.5) * this.maxRho;
    }

    public int ThetaToIndex(double theta) {
        return (int)(0.5 + theta / this.maxTheta * (double)this.maxIndexTheta);
    }

    public double IndexToTheta(int index) {
        return (double)index / (double)this.maxIndexTheta * this.maxTheta;
    }

    public double[] RhoTheta_To_AB(double rho, double theta) {
        if (Math.abs(Math.sin(theta)) < 0.01) {
            double a = Double.NaN;
            double b = (double)(this.Width >> 1) + (theta < 1.57 ? rho : -rho);
            return new double[]{Double.NaN, b};
        }
        double a = -Math.cos(theta) / Math.sin(theta);
        double b = rho / Math.sin(theta) + (double)(this.Height >> 1) - a * (double)(this.Width >> 1);
        return new double[]{a, b};
    }

    public int getMaxIndexTheta() {
        return this.maxIndexTheta;
    }

    public int getMaxIndexRho() {
        return this.maxIndexRho;
    }

    public int[][] getAccumulator() {
        return this.accumulator;
    }

    public List<double[]> Winners(int percentagethreshold, int radius) {
        int radius2 = radius << 1;
        int highestvote = this.AF.Maximum(this.accumulator);
        int minvote = (int)((double)highestvote / 100.0 * (double)percentagethreshold);
        ArrayList<int[]> coords = new ArrayList<int[]>(43);
        for (int r = 0; r < this.maxIndexRho; ++r) {
            for (int t = 0; t < this.maxIndexTheta; ++t) {
                if (this.accumulator[r][t] < minvote) continue;
                int nmax = 0;
                for (int k = 0; k < this.dx8.length; ++k) {
                    int rk = r + this.dx8[k];
                    int tk = t + this.dy8[k];
                    if (rk < 0 || rk >= this.maxIndexRho) continue;
                    if (tk < 0) {
                        tk += this.maxIndexTheta;
                    }
                    if (tk >= this.maxIndexTheta) {
                        tk -= this.maxIndexTheta;
                    }
                    if (this.accumulator[rk][tk] <= nmax) continue;
                    nmax = this.accumulator[rk][tk];
                }
                if (nmax > this.accumulator[r][t]) continue;
                boolean ignore = false;
                Iterator iter = coords.iterator();
                while (iter.hasNext()) {
                    int[] coord2 = (int[])iter.next();
                    int dist = this.distance(coord2[0], coord2[1], r, t);
                    if (dist > radius2) continue;
                    if (this.accumulator[r][t] < this.accumulator[coord2[0]][coord2[1]]) {
                        ignore = true;
                        break;
                    }
                    iter.remove();
                    coord2 = null;
                }
                iter = null;
                if (ignore) continue;
                coords.add(new int[]{r, t});
            }
        }
        ArrayList<double[]> winners = new ArrayList<double[]>(coords.size());
        coords.forEach(coord -> winners.add(new double[]{this.IndexToRho(coord[0]), this.IndexToTheta(coord[1])}));
        return winners;
    }

    private int distance(int r0, int t0, int r1, int t1) {
        int dist = Math.max(Math.abs(r0 - r1), Math.abs(t0 - t1));
        if (t0 < t1) {
            t0 += this.maxIndexTheta;
            r0 = this.maxIndexRho - r0 - 1;
        } else {
            t1 += this.maxIndexTheta;
            r1 = this.maxIndexRho - r1 - 1;
        }
        dist = Math.min(dist, Math.max(Math.abs(r0 - r1), Math.abs(t0 - t1)));
        return dist;
    }

    public BufferedImage HoughSpace() {
        BufferedImage img = new BufferedImage(this.maxIndexTheta, this.maxIndexRho, 1);
        int max = this.AF.Maximum(this.accumulator);
        double scale = (double)max / 10.0;
        for (int r = 0; r < this.maxIndexRho; ++r) {
            for (int t = 0; t < this.maxIndexTheta; ++t) {
                double v = Math.log(1.0 + (double)this.accumulator[r][t] / scale) / Math.log(1.0 + (double)max / scale);
                Color color = Color.getHSBColor(0.0f, 0.0f, (float)v);
                img.setRGB(t, r, color.getRGB());
            }
        }
        return img;
    }
}

