/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.detectors.circle;

import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mathematics.Geometry2D;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;

public class HoughCircle {
    public List<Double> radii = new LinkedList<Double>();
    public List<Coordinate> centers = new LinkedList<Coordinate>();
    public int[] accumulator = null;
    private int width;
    private int height = -1;
    private double maxradius = 0.0;
    private final Metric dist = new Euclidian();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();

    public void Transform(BufferedImage image, double draw) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>((int)this.IF.Counter(image, 0, 0));
        ImageConverter.ImageToListOfPoints((BufferedImage)image, list);
        this.Transform(list, image.getWidth(), image.getHeight(), draw);
        list.clear();
        list = null;
    }

    public void Transform(List<Coordinates> points, int width, int height, double draw) {
        this.width = width;
        this.height = height;
        int length = width * height;
        int nbdraw = (int)((double)points.size() * 3.0 * draw);
        if (nbdraw <= 0) {
            throw new IllegalArgumentException(nbdraw + " draws to fill the Hough space. Check the number of points in the list and coefficient 'draw'.");
        }
        if (this.accumulator == null || this.accumulator.length != length) {
            this.accumulator = null;
            this.accumulator = new int[length];
        }
        Arrays.fill(this.accumulator, 0);
        this.radii.clear();
        this.centers.clear();
        this.maxradius = 0.0;
        int count = 0;
        while (count < nbdraw) {
            int z;
            int y;
            int x = (int)(Math.random() * (double)points.size());
            while (x == (y = (int)(Math.random() * (double)points.size()))) {
            }
            while (x == (z = (int)(Math.random() * (double)points.size())) || y == z) {
            }
            Coordinates p1 = points.get(x);
            Coordinates p2 = points.get(y);
            Coordinates p3 = points.get(z);
            Coordinate center = new Coordinate();
            try {
                Geometry2D.FindCenter(p1, p2, p3, center);
                if (0.0 <= center.X && center.X + 0.5 < (double)width && 0.0 <= center.Y && center.Y + 0.5 < (double)height) {
                    int n = (int)(center.X + 0.5) + (int)(center.Y + 0.5) * width;
                    this.accumulator[n] = this.accumulator[n] + 1;
                    double r = this.dist.Distance(p1, center);
                    this.radii.add(r);
                    if (this.maxradius < r) {
                        this.maxradius = r;
                    }
                    this.centers.add(center);
                }
                ++count;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            p3 = null;
            p2 = null;
            p1 = null;
        }
    }

    public int BestCircle(Coordinates center) {
        if (this.height < 0) {
            throw new IllegalStateException("No transformation (Hough space filling) performed so far.");
        }
        double[] rad = new double[this.AF.Maximum(this.accumulator)];
        int pos = this.AF.MaximumIndex();
        center.X = pos % this.width;
        center.Y = pos / this.width;
        center.Pos = pos;
        pos = 0;
        Iterator<Coordinate> itcenters = this.centers.iterator();
        Iterator<Double> itradii = this.radii.iterator();
        while (itcenters.hasNext()) {
            Coordinate c = itcenters.next();
            double radius = itradii.next();
            if ((int)(c.X + 0.5) == center.X && (int)(c.Y + 0.5) == center.Y) {
                rad[pos++] = radius;
            }
            c = null;
        }
        itcenters = null;
        itradii = null;
        int[] hist = new int[(int)(this.maxradius + 0.5) + 1];
        for (int r = 0; r < pos; ++r) {
            int n = (int)(rad[r] + 0.5);
            hist[n] = hist[n] + 1;
        }
        pos = this.AF.MaximumIndex(hist);
        hist = null;
        rad = null;
        return pos;
    }
}

