/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures;

import Jama.Matrix;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.util.ArrayList;
import java.util.List;
import mathematics.matriciel.Inverse;
import mathematics.metrics.Metric;
import mathematics.metrics.MetricGroup;
import mathematics.statistics.CenterReduce;
import mathematics.statistics.CoVarianceMatrix;

public class EfficiencyTest {
    protected FichierTabule Resultat = null;
    protected double PercentagePrediction = -1.0;

    public FichierTabule ComputeOneByOne(FichierTabule DataBase, FichierTabule Vignettes, Metric distance, boolean CentrerReduire) {
        int y;
        int x;
        double[][] database = null;
        double[][] vignettes = null;
        if (DataBase.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier DataBase ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        if (Vignettes.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier Vignettes ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        boolean continuer = true;
        for (x = 0; x < DataBase.Width() && continuer; ++x) {
            if (DataBase.ColumnType(x) != 0) continue;
            DataBase = FichierTabuleTools.CloneIntToDouble(DataBase);
            continuer = false;
        }
        continuer = true;
        for (x = 0; x < Vignettes.Width() && continuer; ++x) {
            if (Vignettes.ColumnType(x) != 0) continue;
            Vignettes = FichierTabuleTools.CloneIntToDouble(Vignettes);
            continuer = false;
        }
        FichierTabule ColonnesRes = new FichierTabule(Vignettes.Height(), new int[]{2, 0}, "EfficiencyTest_CompObO");
        ColonnesRes.setColumnName(0, "TextureFounded");
        ColonnesRes.setColumnName(1, "GoodClassification");
        for (y = 0; y < Vignettes.Height(); ++y) {
            ColonnesRes.setValue(y, 0, "");
        }
        FichierTabule result = FichierTabuleTools.MergeSideBySide(Vignettes, ColonnesRes);
        if (CentrerReduire) {
            CenterReduce sd = new CenterReduce();
            CenterReduce.ComputeDouble(DataBase);
            CenterReduce.ComputeDouble(Vignettes);
        }
        DataBase.setExcludedColumn(DataBase.Width() - 1, true);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, true);
        database = DataBase.getFileDouble();
        vignettes = Vignettes.getFileDouble();
        DataBase.setExcludedColumn(DataBase.Width() - 1, false);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, false);
        int HauteurD = database.length;
        int HauteurV = vignettes.length;
        int nbFail = 0;
        int nbGood = 0;
        for (y = 0; y < HauteurV; ++y) {
            int Nearest = 0;
            double DistNearest = distance.Distance(vignettes[y], database[0]);
            for (x = 1; x < HauteurD; ++x) {
                double Dist = distance.Distance(vignettes[y], database[x]);
                if (!(Dist < DistNearest)) continue;
                DistNearest = Dist;
                Nearest = x;
            }
            result.setValue(y, result.Width() - 2, DataBase.getValueString(Nearest, DataBase.Width() - 1));
            if (this.isVignetteOf(DataBase.getValueString(Nearest, DataBase.Width() - 1), Vignettes.getValueString(y, Vignettes.Width() - 1))) {
                result.setValue(y, result.Width() - 1, 1);
                ++nbGood;
                continue;
            }
            result.setValue(y, result.Width() - 1, 0);
            ++nbFail;
        }
        database = null;
        vignettes = null;
        this.PercentagePrediction = 100.0 * (double)nbGood / (double)(nbGood + nbFail);
        return result;
    }

    public FichierTabule ComputeOneFromGroup(FichierTabule DataBase, FichierTabule Vignettes, MetricGroup distance, boolean CentrerReduire) {
        int y;
        int x;
        double[][] vignettes = null;
        Matrix[] CovariancesInv = null;
        String name = null;
        ArrayList<String> Names = new ArrayList<String>(10);
        ArrayList<Integer> Occurrences = new ArrayList<Integer>(10);
        FichierTabule Groupe = null;
        CoVarianceMatrix cm = new CoVarianceMatrix();
        int HauteurD = DataBase.Height();
        int HauteurV = Vignettes.Height();
        if (DataBase.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier DataBase ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        if (Vignettes.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier Vignettes ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        boolean continuer = true;
        for (x = 0; x < DataBase.Width() && continuer; ++x) {
            if (DataBase.ColumnType(x) != 0) continue;
            DataBase = FichierTabuleTools.CloneIntToDouble(DataBase);
            continuer = false;
        }
        continuer = true;
        for (x = 0; x < Vignettes.Width() && continuer; ++x) {
            if (Vignettes.ColumnType(x) != 0) continue;
            Vignettes = FichierTabuleTools.CloneIntToDouble(Vignettes);
            continuer = false;
        }
        FichierTabule ColonnesRes = new FichierTabule(Vignettes.Height(), new int[]{2, 0}, "EfficiencyTest_CompOfG");
        ColonnesRes.setColumnName(0, "TextureFounded");
        ColonnesRes.setColumnName(1, "GoodClassification");
        for (y = 0; y < HauteurV; ++y) {
            ColonnesRes.setValue(y, 0, "");
        }
        FichierTabule result = FichierTabuleTools.MergeSideBySide(Vignettes, ColonnesRes);
        if (CentrerReduire) {
            CenterReduce sd = new CenterReduce();
            CenterReduce.ComputeDouble(DataBase);
            CenterReduce.ComputeDouble(Vignettes);
        }
        DataBase.setExcludedColumn(DataBase.Width() - 1, true);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, true);
        vignettes = Vignettes.getFileDouble();
        int n = DataBase.Width() - 1;
        Names.add(this.ExtractGroupName(DataBase.getValueString(0, n)));
        Occurrences.add(1);
        for (y = 1; y < HauteurD; ++y) {
            name = this.ExtractGroupName(DataBase.getValueString(y, n));
            x = Names.size() - 1;
            boolean find = false;
            while (!find && x >= 0) {
                if (name.equalsIgnoreCase((String)Names.get(x))) {
                    find = true;
                    Occurrences.set(x, (Integer)Occurrences.get(x) + 1);
                    continue;
                }
                --x;
            }
            if (find) continue;
            Names.add(name);
            Occurrences.add(1);
        }
        CovariancesInv = new Matrix[Names.size()];
        for (x = 0; x < Names.size(); ++x) {
            name = (String)Names.get(x);
            for (y = 0; y < HauteurD; ++y) {
                if (DataBase.isExcluded(y)) continue;
                if (DataBase.getValueString(y, n).contains(name)) {
                    DataBase.setSelected(y, true);
                    continue;
                }
                DataBase.setSelected(y, false);
            }
            Groupe = FichierTabuleTools.SaveSelectedRows(DataBase);
            Groupe.setExcludedColumn(n, true);
            cm.Compute(Groupe);
            try {
                CovariancesInv[x] = cm.getMatrix().inverse();
            }
            catch (Exception E) {
                CovariancesInv[x] = new Inverse().Gauss(cm.getMatrix());
            }
            Groupe = null;
            for (y = 0; y < HauteurD; ++y) {
                if (!DataBase.isSelected(y)) continue;
                DataBase.setSelected(y, false);
                DataBase.setExcluded(y, true);
            }
        }
        DataBase.setExcludedColumn(DataBase.Width() - 1, false);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, false);
        for (y = 0; y < HauteurD; ++y) {
            DataBase.setSelected(y, false);
            DataBase.setExcluded(y, false);
        }
        HauteurD = Names.size();
        HauteurV = vignettes.length;
        int nbFail = 0;
        int nbGood = 0;
        for (y = 0; y < HauteurV; ++y) {
            int Nearest = 0;
            double DistNearest = distance.Distance(CovariancesInv[0], vignettes[y]);
            for (x = 1; x < HauteurD; ++x) {
                double Dist = distance.Distance(CovariancesInv[x], vignettes[y]);
                if (!(Dist < DistNearest)) continue;
                DistNearest = Dist;
                Nearest = x;
            }
            result.setValue(y, result.Width() - 2, (String)Names.get(Nearest));
            if (this.isVignetteOfGroup((String)Names.get(Nearest), Vignettes.getValueString(y, Vignettes.Width() - 1))) {
                result.setValue(y, result.Width() - 1, 1);
                ++nbGood;
                continue;
            }
            result.setValue(y, result.Width() - 1, 0);
            ++nbFail;
        }
        Names.clear();
        Names = null;
        Occurrences.clear();
        Occurrences = null;
        vignettes = null;
        CovariancesInv = null;
        name = null;
        Groupe = null;
        cm = null;
        this.PercentagePrediction = 100.0 * (double)nbGood / (double)(nbGood + nbFail);
        return result;
    }

    public FichierTabule ComputeOneFromGroup(FichierTabule DataBase, FichierTabule Vignettes, Metric distance, int KNN, boolean CentrerReduire) {
        int y;
        int x;
        double[][] database = null;
        double[][] vignettes = null;
        int[] Votes = null;
        String name = null;
        ArrayList<String> Names = new ArrayList<String>(10);
        ArrayList<Voisin> kNN = null;
        int HauteurD = DataBase.Height();
        int HauteurV = Vignettes.Height();
        if (DataBase.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier DataBase ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        if (Vignettes.getNbExcluded() > 0) {
            throw new IllegalArgumentException("Le fichier Vignettes ne doit contenir QUE des instances valides => Excluded interdit.");
        }
        if (KNN > HauteurD || KNN < 1) {
            throw new Error("Valeur de KNN erronee.");
        }
        boolean continuer = true;
        for (x = 0; x < DataBase.Width() && continuer; ++x) {
            if (DataBase.ColumnType(x) != 0) continue;
            DataBase = FichierTabuleTools.CloneIntToDouble(DataBase);
            continuer = false;
        }
        continuer = true;
        for (x = 0; x < Vignettes.Width() && continuer; ++x) {
            if (Vignettes.ColumnType(x) != 0) continue;
            Vignettes = FichierTabuleTools.CloneIntToDouble(Vignettes);
            continuer = false;
        }
        FichierTabule ColonnesRes = new FichierTabule(Vignettes.Height(), new int[]{2, 0}, "EfficiencyTest_CompOfG");
        ColonnesRes.setColumnName(0, "TextureFounded");
        ColonnesRes.setColumnName(1, "GoodClassification");
        for (y = 0; y < HauteurV; ++y) {
            ColonnesRes.setValue(y, 0, "");
        }
        FichierTabule result = FichierTabuleTools.MergeSideBySide(Vignettes, ColonnesRes);
        if (CentrerReduire) {
            CenterReduce sd = new CenterReduce();
            CenterReduce.ComputeDouble(DataBase);
            CenterReduce.ComputeDouble(Vignettes);
        }
        DataBase.setExcludedColumn(DataBase.Width() - 1, true);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, true);
        database = DataBase.getFileDouble();
        vignettes = Vignettes.getFileDouble();
        DataBase.setExcludedColumn(DataBase.Width() - 1, false);
        Vignettes.setExcludedColumn(Vignettes.Width() - 1, false);
        int n = DataBase.Width() - 1;
        Names.add(this.ExtractGroupName(DataBase.getValueString(0, n)));
        for (y = 1; y < HauteurD; ++y) {
            name = this.ExtractGroupName(DataBase.getValueString(y, n));
            x = Names.size() - 1;
            boolean find = false;
            while (!find && x >= 0) {
                if (name.equalsIgnoreCase((String)Names.get(x))) {
                    find = true;
                    continue;
                }
                --x;
            }
            if (find) continue;
            Names.add(name);
        }
        HauteurD = database.length;
        HauteurV = vignettes.length;
        Votes = new int[Names.size()];
        kNN = new ArrayList<Voisin>(10);
        int nbFail = 0;
        int nbGood = 0;
        for (y = 0; y < HauteurV; ++y) {
            for (x = 0; x < KNN; ++x) {
                this.InsererVoisin(kNN, KNN, x, distance.Distance(vignettes[y], database[x]));
            }
            double max = ((Voisin)kNN.get((int)(KNN - 1))).dist;
            for (x = KNN; x < HauteurD; ++x) {
                double Dist = distance.Distance(vignettes[y], database[x]);
                if (!(Dist < max)) continue;
                this.InsererVoisin(kNN, KNN, x, Dist);
                max = ((Voisin)kNN.get((int)(KNN - 1))).dist;
            }
            for (x = 0; x < Votes.length; ++x) {
                Votes[x] = 0;
            }
            for (x = 0; x < KNN; ++x) {
                int n2 = this.FindPositionNameInList(Names, this.ExtractGroupName(DataBase.getValueString(((Voisin)kNN.get((int)x)).num, n)));
                Votes[n2] = Votes[n2] + 1;
            }
            int Winner = 0;
            for (x = 1; x < Votes.length; ++x) {
                if (Votes[x] <= Votes[Winner]) continue;
                Winner = x;
            }
            result.setValue(y, result.Width() - 2, (String)Names.get(Winner));
            if (((String)Names.get(Winner)).equalsIgnoreCase(this.ExtractGroupName(Vignettes.getValueString(y, Vignettes.Width() - 1)))) {
                result.setValue(y, result.Width() - 1, 1);
                ++nbGood;
            } else {
                result.setValue(y, result.Width() - 1, 0);
                ++nbFail;
            }
            kNN.clear();
        }
        kNN = null;
        Votes = null;
        Names.clear();
        Names = null;
        database = null;
        vignettes = null;
        this.PercentagePrediction = 100.0 * (double)nbGood / (double)(nbGood + nbFail);
        return result;
    }

    protected void InsererVoisin(List<Voisin> kNN, int KNN, int num, double distance) {
        int i2;
        int taille = kNN.size();
        for (i2 = 0; i2 < taille && kNN.get((int)i2).dist < distance; ++i2) {
        }
        if (taille == KNN) {
            kNN.remove(KNN - 1);
        }
        kNN.add(i2, new Voisin(num, distance));
    }

    protected boolean isVignetteOf(String Texture, String Vignette) {
        int j;
        int i2;
        for (i2 = Texture.length() - 1; i2 >= 0 && Texture.charAt(i2) != '.'; --i2) {
        }
        for (j = Vignette.length() - 1; j >= 0 && Vignette.charAt(j) != '_'; --j) {
        }
        return Texture.substring(0, i2).equalsIgnoreCase(Vignette.substring(0, j));
    }

    protected boolean isVignetteOfGroup(String Groupe, String Vignette) {
        return Groupe.equalsIgnoreCase(this.ExtractGroupName(Vignette));
    }

    protected String ExtractGroupName(String Name2) {
        int i2;
        for (i2 = 0; i2 < Name2.length() && Name2.charAt(i2) != '_'; ++i2) {
        }
        return Name2.substring(0, i2);
    }

    protected int FindPositionNameInList(List<String> list, String Name2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).equalsIgnoreCase(Name2)) continue;
            return i2;
        }
        return -1;
    }

    public double getLastPercentagePrediction() {
        return this.PercentagePrediction;
    }

    protected class Voisin {
        int num;
        double dist;

        public Voisin(int num, double dist) {
            this.num = num;
            this.dist = dist;
        }
    }
}

