/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures;

import filesAndFolders.FichiersDossiersIHM;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class CutOutVignette {
    protected BufferedImage Texture = null;
    protected File Directory = null;
    protected File Vignettes = null;
    protected File[] fichiers = null;

    public void CutOut(String Dossier, int N, int Width, int Height) throws IOException {
        this.TestsAndFiles(Dossier, N, Width, Height);
        for (int i2 = 0; i2 < this.fichiers.length; ++i2) {
            if (!this.fichiers[i2].isFile() || this.fichiers[i2].getName().equalsIgnoreCase(".DS_Store") || this.fichiers[i2].getName().contains(".txt")) continue;
            this.Texture = null;
            this.Texture = ImageIO.Read(this.Directory.getPath() + "/" + this.fichiers[i2].getName());
            if (Width >= this.Texture.getWidth()) {
                throw new Error("Largeur de la texture inferieure ou egale e la largeur de la vignette souhaitee.");
            }
            if (Height >= this.Texture.getHeight()) {
                throw new Error("Hauteur de la texture inferieure ou egale e la hauteur de la vignette souhaitee.");
            }
            for (int j = 0; j < N; ++j) {
                int x = (int)(Math.random() * (double)(this.Texture.getWidth() - Width));
                int y = (int)(Math.random() * (double)(this.Texture.getHeight() - Height));
                this.CutAndSave(this.fichiers[i2].getName(), j, x, y, Width, Height);
            }
            this.Texture = null;
        }
    }

    public void CutOff(String Dossier, int N, int Width, int Height) throws IOException {
        int nb = 0;
        this.TestsAndFiles(Dossier, N, Width, Height);
        while (nb < N) {
            int i2 = (int)(Math.random() * (double)this.fichiers.length);
            if (!this.fichiers[i2].isFile() || this.fichiers[i2].getName().equalsIgnoreCase(".DS_Store") || this.fichiers[i2].getName().contains(".txt")) continue;
            this.Texture = ImageIO.Read(this.Directory.getPath() + "/" + this.fichiers[i2].getName());
            if (Width >= this.Texture.getWidth()) {
                throw new Error("Largeur de la texture inferieure ou egale e la largeur de la vignette souhaitee.");
            }
            if (Height >= this.Texture.getHeight()) {
                throw new Error("Hauteur de la texture inferieure ou egale e la hauteur de la vignette souhaitee.");
            }
            int x = (int)(Math.random() * (double)(this.Texture.getWidth() - Width));
            int y = (int)(Math.random() * (double)(this.Texture.getHeight() - Height));
            this.CutAndSave(this.fichiers[i2].getName(), nb++, x, y, Width, Height);
        }
    }

    protected void TestsAndFiles(String Dossier, int N, int Width, int Height) {
        if (N < 1) {
            throw new Error("Nombre de vignettes negatif ou nul : " + N);
        }
        if (Width < 1) {
            throw new Error("Largeur de la vignette negative ou nulle : " + Width);
        }
        if (Height < 1) {
            throw new Error("Hauteur de la vignette negative ou nulle : " + Height);
        }
        this.Directory = Dossier == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(Dossier);
        this.fichiers = this.Directory.listFiles();
        Arrays.sort(this.fichiers);
        this.Vignettes = new File(this.Directory.getAbsolutePath() + "/Vignettes " + Width + "x" + Height);
        this.Vignettes.mkdir();
    }

    protected void CutAndSave(String Nom, int Num, int X, int Y, int Width, int Height) throws FileNotFoundException, IOException {
        int x;
        String prefixe = null;
        BufferedImage Vignette = new BufferedImage(Width, Height, 13);
        WritableRaster wrvig = Vignette.getRaster();
        WritableRaster wrtext = this.Texture.getRaster();
        for (x = Nom.length() - 1; x >= 0 && Nom.charAt(x) != '.'; --x) {
        }
        prefixe = Nom.substring(0, x);
        for (int y = 0; y < Height; ++y) {
            for (x = 0; x < Width; ++x) {
                wrvig.setSample(x, y, 0, wrtext.getSample(x + X, y + Y, 0));
            }
        }
        ImageIO.Write(Vignette, this.Vignettes.getAbsolutePath() + "/" + prefixe + "_" + Num + ".pgm", 5);
        wrvig = null;
        wrtext = null;
        prefixe = null;
        Vignette = null;
    }
}

