/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures;

import characterization.ComputableFeatures;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class BasicTexturalFeatures2
implements ComputableFeatures {
    protected double Average = 0.0;
    protected double Sum = 0.0;
    protected int Size = 0;
    protected double Variance = 0.0;
    protected double StandardDeviation = 0.0;
    protected double Kurtosis = 0.0;
    protected double Skewness = 0.0;
    protected double Ratio = 0.0;
    private double[] Features = new double[7];
    private String[] FeaturesNames = new String[]{"Size", "Sum", "Average", "Variance", "Kurtosis", "Skewness", "Ratio"};

    public void Extract(BufferedImage source, BufferedImage mask, int ForbidenValue) {
        int x;
        int y;
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level or binary image required.");
        }
        if (source.getHeight() != mask.getHeight() || source.getWidth() != mask.getWidth()) {
            throw new IllegalArgumentException("Images source and mask have different dimensions.");
        }
        int surfacemask = 0;
        int width = source.getWidth();
        int height = source.getHeight();
        this.Skewness = 0.0;
        this.Kurtosis = 0.0;
        this.Variance = 0.0;
        this.Sum = 0.0;
        WritableRaster wr = source.getRaster();
        WritableRaster wrm = source.getRaster();
        this.Size = 0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (wrm.getSample(x, y, 0) == ForbidenValue || wrm.getSample(x, y, 0) <= 0) continue;
                ++surfacemask;
                if (wr.getSample(x, y, 0) == ForbidenValue) continue;
                this.Sum += (double)wr.getSample(x, y, 0);
                ++this.Size;
            }
        }
        this.Average = this.Sum / (double)this.Size;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) != ForbidenValue) continue;
                this.Variance += Math.pow(wr.getSampleDouble(x, y, 0) - this.Average, 2.0);
                this.Skewness += Math.pow(wr.getSampleDouble(x, y, 0) - this.Average, 3.0);
                this.Kurtosis += Math.pow(wr.getSampleDouble(x, y, 0) - this.Average, 4.0);
            }
        }
        this.Features[0] = this.Size;
        this.Features[1] = this.Sum;
        this.Features[2] = this.Average;
        this.Features[3] = this.Variance / (double)this.Size;
        this.Features[4] = this.Kurtosis / (double)this.Size;
        this.Features[5] = this.Skewness / (double)this.Size;
        this.Features[6] = (double)this.Size / (double)surfacemask;
        wr = null;
        wrm = null;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        throw new Error("Method not yet implemented.");
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void Parameters(Object ... parameters) {
        throw new Error("Method not implemented (yet).");
    }

    @Override
    public synchronized void Kill() {
        this.Features = null;
        this.FeaturesNames = null;
    }
}

