/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures;

import characterization.ComputableFeatures;
import dv.DV;
import dv.DvFeatures;
import imageTiTi.ImageComparator;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;

public class BasicTexturalFeatures
implements ComputableFeatures {
    private double[] Features = new double[6];
    private String[] FeaturesNames = new String[]{"BTF_Size", "BTF_Sum", "BTF_Average", "BTF_Variance", "BTF_Kurtosis", "BTF_Skewness"};
    private int ForbiddenValue = -1;
    private final DvFeatures DF = new DvFeatures();
    private final ImageFeatures IF = new ImageFeatures();

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Extract(image, mask, ForbiddenValue);
    }

    public void Extract(BufferedImage source, BufferedImage mask, int ForbiddenValue) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level or binary image required.");
        }
        BufferedImage result = null;
        if (mask != null) {
            result = ImageNew.Clone((BufferedImage)source);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)source, (int)ForbiddenValue, (BufferedImage)result);
        } else {
            result = source;
        }
        this.IF.Moments(result, ForbiddenValue);
        this.Features[0] = this.IF.Size();
        this.Features[1] = this.IF.Integral();
        this.Features[2] = this.IF.Average();
        this.Features[3] = this.IF.Variance();
        this.Features[4] = this.IF.Kurtosis();
        this.Features[5] = this.IF.Skewness();
        result = null;
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Extract(dv, this.ForbiddenValue);
    }

    public void Extract(DV source, int ForbidenValue) {
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Single channel DV required.");
        }
        this.DF.Moments(source, 0, ForbidenValue);
        this.Features[0] = this.DF.Size;
        this.Features[1] = this.DF.Integral;
        this.Features[2] = this.DF.Average;
        this.Features[3] = this.DF.Variance;
        this.Features[4] = this.DF.Kurtosis;
        this.Features[5] = this.DF.Skewness;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.ForbiddenValue = (Integer)parameters[0];
    }

    @Override
    public synchronized void Kill() {
        this.Features = null;
        this.FeaturesNames = null;
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }
}

