/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayOperations;
import characterization.shapes.skeletons.ISkeleton;
import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import listTiTi.Queue;
import listTiTi.Stack;
import mathematics.primitives.pointsTiTi.Coordinates;

public class VincentSkel
implements ISkeleton {
    private int[][] imarray;
    private int[][] outarray;
    private int[][] anchorsarray;
    private int[] tab_prune = new int[64];
    private int[] tab_homo = new int[64];
    private int[][] nlO = new int[6][2];
    private int[][] nlP = new int[6][2];
    private Queue<Integer> Qx = new Queue();
    private Queue<Integer> Qy = new Queue();
    private Queue<Integer> tabX = new Queue();
    private Queue<Integer> tabY = new Queue();
    private Stack<Integer> tempX = new Stack();
    private Stack<Integer> tempY = new Stack();
    private List<Coordinates> anchors = null;

    public BufferedImage Filter(BufferedImage image, int nbCPU) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        this.Filter(image, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage image, BufferedImage result, int nbCPU) {
        if (this.anchors == null) {
            this.Filter(image, new ArrayList<Coordinates>(1), result, nbCPU);
        } else {
            this.Filter(image, this.anchors, result, nbCPU);
        }
    }

    public BufferedImage Filter(BufferedImage image, int nbCPU, BufferedImage anchors) {
        this.Parameters(anchors);
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        this.Filter(image, result, nbCPU);
        return result;
    }

    @Override
    public BufferedImage Filter(BufferedImage image, List<Coordinates> anchors, int nbCPU) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        this.Filter(image, anchors, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage image, List<Coordinates> anchors, BufferedImage result, int nbCPU) {
        int height = image.getHeight();
        int width = image.getWidth();
        if (image.getType() != 12) {
            throw new IllegalArgumentException("Image source is not binary.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result have different type or dimensions.");
        }
        this.Parameters(anchors);
        if (this.imarray == null || this.imarray.length != height || this.imarray[0].length != width) {
            this.anchorsarray = null;
            this.outarray = null;
            this.imarray = null;
            this.imarray = new int[height][width];
            this.outarray = new int[height][width];
            this.anchorsarray = new int[height][width];
        }
        ImageConverter.ImageToInt((BufferedImage)image, (int[][])this.imarray);
        ArrayOperations.Fill((int[][])this.anchorsarray, (int)0);
        for (int i2 = 0; i2 < anchors.size(); ++i2) {
            Coordinates p = anchors.get(i2);
            this.anchorsarray[p.Y][p.X] = 1;
        }
        this.SkeletonWithAnchor(this.imarray, this.anchorsarray, width, height, this.outarray);
        ArrayComparator.Compare((int[][])this.outarray, (String)"!=", (int)0, (int)1, (int)0, (int[][])this.outarray);
        ImageConverter.ArrayToImage((int[][])this.outarray, (BufferedImage)result);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void SkeletonWithAnchor(int[][] imin, int[][] immark, int width, int height, int[][] imout) {
        int y;
        int x;
        int mod;
        ArrayOperations.Fill((int[][])imout, (int)0);
        this.nlP[0][0] = 1;
        this.nlP[0][1] = 0;
        this.nlP[1][0] = 0;
        this.nlP[1][1] = -1;
        this.nlP[2][0] = -1;
        this.nlP[2][1] = -1;
        this.nlP[3][0] = -1;
        this.nlP[3][1] = 0;
        this.nlP[4][0] = -1;
        this.nlP[4][1] = 1;
        this.nlP[5][0] = 0;
        this.nlP[5][1] = 1;
        this.nlO[0][0] = 1;
        this.nlO[0][1] = 0;
        this.nlO[1][0] = 1;
        this.nlO[1][1] = -1;
        this.nlO[2][0] = 0;
        this.nlO[2][1] = -1;
        this.nlO[3][0] = -1;
        this.nlO[3][1] = 0;
        this.nlO[4][0] = 0;
        this.nlO[4][1] = 1;
        this.nlO[5][0] = 1;
        this.nlO[5][1] = 1;
        Arrays.fill(this.tab_homo, 0);
        this.tab_homo[0] = 1;
        this.tab_homo[5] = 1;
        this.tab_homo[9] = 1;
        this.tab_homo[10] = 1;
        this.tab_homo[11] = 1;
        this.tab_homo[13] = 1;
        this.tab_homo[17] = 1;
        this.tab_homo[18] = 1;
        this.tab_homo[19] = 1;
        this.tab_homo[20] = 1;
        this.tab_homo[21] = 1;
        this.tab_homo[22] = 1;
        this.tab_homo[23] = 1;
        this.tab_homo[25] = 1;
        this.tab_homo[26] = 1;
        this.tab_homo[27] = 1;
        this.tab_homo[29] = 1;
        this.tab_homo[34] = 1;
        this.tab_homo[36] = 1;
        this.tab_homo[37] = 1;
        this.tab_homo[38] = 1;
        this.tab_homo[40] = 1;
        this.tab_homo[41] = 1;
        this.tab_homo[42] = 1;
        this.tab_homo[43] = 1;
        this.tab_homo[44] = 1;
        this.tab_homo[45] = 1;
        this.tab_homo[46] = 1;
        this.tab_homo[50] = 1;
        this.tab_homo[52] = 1;
        this.tab_homo[53] = 1;
        this.tab_homo[54] = 1;
        this.tab_homo[58] = 1;
        this.tab_homo[63] = 1;
        Arrays.fill(this.tab_prune, 0);
        this.tab_prune[0] = 1;
        this.tab_prune[1] = 1;
        this.tab_prune[2] = 1;
        this.tab_prune[3] = 1;
        this.tab_prune[4] = 1;
        this.tab_prune[6] = 1;
        this.tab_prune[8] = 1;
        this.tab_prune[12] = 1;
        this.tab_prune[16] = 1;
        this.tab_prune[24] = 1;
        this.tab_prune[32] = 1;
        this.tab_prune[33] = 1;
        this.tab_prune[48] = 1;
        this.Qx.Clear();
        this.Qx.Clear();
        this.Qy.Clear();
        this.tabX.Clear();
        this.tabY.Clear();
        this.tempX.Clear();
        this.tempY.Clear();
        for (int j = 0; j < height; ++j) {
            mod = j % 2;
            block1: for (int i2 = 0; i2 < width; ++i2) {
                int k;
                if (imin[j][i2] <= 0) continue;
                imout[j][i2] = immark[j][i2] > 0 ? 1 : 2;
                if (i2 == 0 || j == 0 || i2 == width - 1 || j == height - 1) {
                    this.Qx.push(i2);
                    this.Qy.push(j);
                    imout[j][i2] = 3;
                    continue;
                }
                if (mod == 0) {
                    for (k = 0; k < 6; ++k) {
                        x = i2 + this.nlP[k][0];
                        y = j + this.nlP[k][1];
                        if (x < 0 || x >= width || y < 0 || y >= height || imin[y][x] != 0) continue;
                        this.Qx.push(i2);
                        this.Qy.push(j);
                        imout[j][i2] = 3;
                        continue block1;
                    }
                    continue;
                }
                for (k = 0; k < 6; ++k) {
                    x = i2 + this.nlO[k][0];
                    y = j + this.nlO[k][1];
                    if (x < 0 || x >= width || y < 0 || y >= height || imin[y][x] != 0) continue;
                    this.Qx.push(i2);
                    this.Qy.push(j);
                    imout[j][i2] = 3;
                    continue block1;
                }
            }
        }
        this.Qx.push(9999);
        this.Qy.push(9999);
        while (true) {
            int k;
            int index;
            int m = this.Qx.front();
            int n = this.Qy.front();
            this.Qx.pop();
            this.Qy.pop();
            if (m == 9999 && n == 9999) {
                if (this.Qx.empty()) {
                    while (!this.tabX.empty()) {
                        m = this.tabX.front();
                        n = this.tabY.front();
                        this.tabX.pop();
                        this.tabY.pop();
                        index = 0;
                        mod = n % 2;
                        if (mod == 0) {
                            for (k = 0; k < 6; ++k) {
                                x = m + this.nlP[k][0];
                                y = n + this.nlP[k][1];
                                if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] == 0) continue;
                                index += (int)Math.pow(2.0, k);
                            }
                        } else {
                            for (k = 0; k < 6; ++k) {
                                x = m + this.nlO[k][0];
                                y = n + this.nlO[k][1];
                                if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] == 0) continue;
                                index += (int)Math.pow(2.0, k);
                            }
                        }
                        if (this.tab_prune[index] != 1) continue;
                        imout[n][m] = 2;
                        this.Qx.push(m);
                        this.Qy.push(n);
                    }
                    while (!this.Qx.empty()) {
                        m = this.Qx.front();
                        n = this.Qy.front();
                        this.Qx.pop();
                        this.Qy.pop();
                        mod = n % 2;
                        index = 0;
                        if (mod == 0) {
                            for (k = 0; k < 6; ++k) {
                                x = m + this.nlP[k][0];
                                y = n + this.nlP[k][1];
                                if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] == 0) continue;
                                index += (int)Math.pow(2.0, k);
                            }
                        } else {
                            for (k = 0; k < 6; ++k) {
                                x = m + this.nlO[k][0];
                                y = n + this.nlO[k][1];
                                if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] == 0) continue;
                                index += (int)Math.pow(2.0, k);
                            }
                        }
                        if (this.tab_prune[index] == 1) {
                            imout[n][m] = 0;
                            mod = n % 2;
                            if (mod == 0) {
                                for (k = 0; k < 6; ++k) {
                                    x = m + this.nlP[k][0];
                                    y = n + this.nlP[k][1];
                                    if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] != 3) continue;
                                    this.Qx.push(x);
                                    this.Qy.push(y);
                                    imout[y][x] = 2;
                                }
                                continue;
                            }
                            for (k = 0; k < 6; ++k) {
                                x = m + this.nlO[k][0];
                                y = n + this.nlO[k][1];
                                if (x < 0 || x >= width || y < 0 || y >= height || imout[y][x] != 3) continue;
                                this.Qx.push(x);
                                this.Qy.push(y);
                                imout[y][x] = 2;
                            }
                            continue;
                        }
                        imout[n][m] = 3;
                    }
                    while (!this.tabX.empty()) {
                        if (imout[this.tabY.front()][this.tabX.front()] == 3) {
                            imout[this.tabY.front().intValue()][this.tabX.front().intValue()] = 1;
                        }
                        this.tabX.pop();
                        this.tabY.pop();
                    }
                    break;
                }
                while (!this.Qx.empty()) {
                    this.tempX.push(this.Qx.front());
                    this.tempY.push(this.Qy.front());
                    this.Qx.pop();
                    this.Qy.pop();
                }
                while (!this.tempX.empty()) {
                    this.Qx.push(this.tempX.top());
                    this.Qy.push(this.tempY.top());
                    this.tempX.pop();
                    this.tempY.pop();
                }
                this.Qx.push(9999);
                this.Qy.push(9999);
                continue;
            }
            index = 0;
            mod = n % 2;
            if (mod == 0) {
                for (k = 0; k < 6; ++k) {
                    x = m + this.nlP[k][0];
                    y = n + this.nlP[k][1];
                    if (x < 0 || x >= width || y < 0 || y >= height) continue;
                    if (imout[y][x] != 0) {
                        index += (int)Math.pow(2.0, k);
                    }
                    if (imout[y][x] != 2) continue;
                    this.Qx.push(x);
                    this.Qy.push(y);
                    imout[y][x] = 3;
                }
            } else {
                for (k = 0; k < 6; ++k) {
                    x = m + this.nlO[k][0];
                    y = n + this.nlO[k][1];
                    if (x < 0 || x >= width || y < 0 || y >= height) continue;
                    if (imout[y][x] != 0) {
                        index += (int)Math.pow(2.0, k);
                    }
                    if (imout[y][x] != 2) continue;
                    this.Qx.push(x);
                    this.Qy.push(y);
                    imout[y][x] = 3;
                }
            }
            if (this.tab_homo[index] == 1) {
                this.tabX.push(m);
                this.tabY.push(n);
                continue;
            }
            imout[n][m] = 0;
        }
    }

    public List<Coordinates> Anchors() {
        return this.anchors;
    }

    public void Anchors(List<Coordinates> anchors) {
        this.anchors = anchors;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ISkeleton Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.Anchors((List)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.anchors);
        return params;
    }
}

