/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import dv.DV;
import imageTiTi.ImageConverter;
import java.awt.image.BufferedImage;
import java.util.List;
import processing.filters.SignalFilter;

public class ThinningNgZhouQuek
implements SignalFilter {
    public static final int HIGHER = 1;
    public static final int LOWER = 0;
    public static final int OTHER = -1;
    private int[] pattern1 = new int[]{-1, 1, 0, 1, 0, 0, 0, 0};
    private int[] pattern2 = new int[]{0, 1, 0, 1, -1, 0, 0, 0};
    private int[] pattern3 = new int[]{0, 0, -1, 1, 0, 1, 0, 0};
    private int[] pattern4 = new int[]{0, 0, 0, 1, 0, 1, -1, 0};
    private int[] pattern5 = new int[]{0, 0, 0, 0, -1, 1, 0, 1};
    private int[] pattern6 = new int[]{-1, 0, 0, 0, 0, 1, 0, 1};
    private int[] pattern7 = new int[]{0, 1, 0, 0, 0, 0, -1, 1};
    private int[] pattern8 = new int[]{0, 1, -1, 0, 0, 0, 0, 1};
    private int[] dx = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
    private int[] dy = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    private int[][] ima = null;
    private int[][] buffer = null;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage image, BufferedImage result, int nbCPU) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (this.ima == null || this.ima.length != height || this.ima[0].length != width) {
            this.ima = null;
            this.ima = new int[height][width];
        }
        ImageConverter.ImageToInt((BufferedImage)image, (int[][])this.ima);
        this.thinning(this.ima, height, width);
        ImageConverter.ArrayToImage((int[][])this.ima, (BufferedImage)result);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void thinning(int[][] image, int width, int height) {
        if (this.buffer == null || this.buffer[0].length != height) {
            this.buffer = new int[3][height];
        }
        for (int y = 0; y < height; ++y) {
            this.buffer[0][y] = 0;
            this.buffer[1][y] = image[0][y];
            this.buffer[2][y] = image[1][y];
        }
        for (int x = 1; x < width - 1; ++x) {
            int[] swp0 = this.buffer[0];
            this.buffer[0] = this.buffer[1];
            this.buffer[1] = this.buffer[2];
            this.buffer[2] = swp0;
            System.arraycopy(image[x + 1], 0, this.buffer[2], 0, height);
            for (int y = 1; y < height - 1; ++y) {
                int transitionsCount;
                int currentNeighbourhood;
                int v = image[x][y];
                if (v == 0 || (currentNeighbourhood = this.neighbourhood(this.buffer, 1, y)) <= 1 || currentNeighbourhood >= 6 || (transitionsCount = this.transitions(image, x, y)) == 1 && currentNeighbourhood <= 3) continue;
                if (transitionsCount == 1) {
                    image[x][y] = 0;
                    continue;
                }
                boolean matchOne = this.matchOneOfPatterns(image, x, y);
                if (!matchOne) continue;
                image[x][y] = 0;
            }
        }
    }

    private int neighbourhood(int[][] c, int x, int y) {
        int neighbourhood = 0;
        int ref = c[x][y];
        if (ref <= c[x - 1][y - 1]) {
            ++neighbourhood;
        }
        if (ref <= c[x - 1][y]) {
            ++neighbourhood;
        }
        if (ref <= c[x - 1][y + 1]) {
            ++neighbourhood;
        }
        if (ref <= c[x][y + 1]) {
            ++neighbourhood;
        }
        if (ref <= c[x + 1][y + 1]) {
            ++neighbourhood;
        }
        if (ref <= c[x + 1][y]) {
            ++neighbourhood;
        }
        if (ref <= c[x + 1][y - 1]) {
            ++neighbourhood;
        }
        if (ref <= c[x][y - 1]) {
            ++neighbourhood;
        }
        return neighbourhood;
    }

    private int transitions(int[][] c, int x, int y) {
        int transitions = 0;
        int ref = c[x][y];
        if (c[x - 1][y - 1] < ref && ref <= c[x - 1][y]) {
            ++transitions;
        }
        if (c[x - 1][y] < ref && ref <= c[x - 1][y + 1]) {
            ++transitions;
        }
        if (c[x - 1][y + 1] < ref && ref <= c[x][y + 1]) {
            ++transitions;
        }
        if (c[x][y + 1] < ref && ref <= c[x + 1][y + 1]) {
            ++transitions;
        }
        if (c[x + 1][y + 1] < ref && ref <= c[x + 1][y]) {
            ++transitions;
        }
        if (c[x + 1][y] < ref && ref <= c[x + 1][y - 1]) {
            ++transitions;
        }
        if (c[x + 1][y - 1] < ref && ref <= c[x][y - 1]) {
            ++transitions;
        }
        if (c[x][y - 1] < ref && ref <= c[x - 1][y - 1]) {
            ++transitions;
        }
        return transitions;
    }

    private boolean matchPixel(int ref, int pixel, int pattern) {
        if (pattern == -1) {
            return true;
        }
        if (pattern == 0 && pixel < ref) {
            return true;
        }
        return pattern == 1 && ref <= pixel;
    }

    private boolean matchPattern(int[][] c, int x, int y, int[] pattern) {
        int ref = c[x][y];
        for (int i2 = 0; i2 < 8; ++i2) {
            if (this.matchPixel(ref, c[x + this.dx[i2]][y + this.dy[i2]], pattern[i2])) continue;
            return false;
        }
        return true;
    }

    private boolean matchOneOfPatterns(int[][] c, int x, int y) {
        if (this.matchPattern(c, x, y, this.pattern1)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern2)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern3)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern4)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern5)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern6)) {
            return true;
        }
        if (this.matchPattern(c, x, y, this.pattern7)) {
            return true;
        }
        return this.matchPattern(c, x, y, this.pattern8);
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }
}

