/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class ThinningCM
implements SignalFilter {
    private int D = 0;
    private int ex;
    private int ey;
    private boolean EightConnex = true;
    private BufferedImage tmp = null;

    public ThinningCM() {
    }

    public ThinningCM(int d, boolean EightConnex) {
        this.D = d;
        this.EightConnex = EightConnex;
    }

    public BufferedImage Filter(BufferedImage source, int d, boolean EightConnex, int nbCPU) {
        this.D = d;
        this.EightConnex = EightConnex;
        return this.Filter(source, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, this.D, this.EightConnex, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage Result, int nbCPU) {
        this.Filter(source, this.D, this.EightConnex, Result, nbCPU);
    }

    public void Filter(BufferedImage source, int d, boolean EightConnex, BufferedImage Result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (EightConnex && source.getType() == 12) {
            throw new IllegalArgumentException("8-connexity forbiden with binary images.");
        }
        this.ex = source.getWidth() - 1;
        this.ey = source.getHeight() - 1;
        this.D = d;
        this.EightConnex = EightConnex;
        if (this.tmp == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.tmp)) {
            this.tmp = null;
            this.tmp = ImageNew.Same((BufferedImage)source);
        }
        ImageNew.Copy((BufferedImage)source, (BufferedImage)Result);
        ImageNew.Copy((BufferedImage)source, (BufferedImage)this.tmp);
        WritableRaster wr = this.tmp.getRaster();
        WritableRaster wrres = Result.getRaster();
        this.NorthReplace(wrres, this.D, wr);
        this.EastReplace(wr, this.D, wrres);
        this.SouthReplace(wrres, this.D, wr);
        this.WestReplace(wr, this.D, wrres);
        if (EightConnex) {
            this.NorthEastReplace(wrres, this.D, wr);
            this.SouthEastReplace(wr, this.D, wrres);
            this.SouthWestReplace(wrres, this.D, wr);
            this.NorthWestReplace(wr, this.D, wrres);
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private boolean NorthReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x, y + 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x, y - 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x - 1, y + 1, 0) + d >= v && wr.getSample(x - 1, y, 0) < v + d) {
            return false;
        }
        return wr.getSample(x + 1, y + 1, 0) + d < v || wr.getSample(x + 1, y, 0) >= v + d;
    }

    private void NorthReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.NorthReductible(wr, x, y, d)) {
                    int max = wr.getSample(x, y + 1, 0);
                    if (wr.getSample(x - 1, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y + 1, 0));
                    }
                    if (wr.getSample(x + 1, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y + 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean SouthReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x, y - 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x, y + 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x + 1, y - 1, 0) + d >= v && wr.getSample(x + 1, y, 0) < v + d) {
            return false;
        }
        return wr.getSample(x - 1, y - 1, 0) + d < v || wr.getSample(x - 1, y, 0) >= v + d;
    }

    private void SouthReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.SouthReductible(wr, x, y, d)) {
                    int max = wr.getSample(x, y - 1, 0);
                    if (wr.getSample(x + 1, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y - 1, 0));
                    }
                    if (wr.getSample(x - 1, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y - 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean WestReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x - 1, y, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x + 1, y, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x - 1, y - 1, 0) + d >= v && wr.getSample(x, y - 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x - 1, y + 1, 0) + d < v || wr.getSample(x, y + 1, 0) >= v + d;
    }

    private void WestReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.WestReductible(wr, x, y, d)) {
                    int max = wr.getSample(x - 1, y, 0);
                    if (wr.getSample(x - 1, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y - 1, 0));
                    }
                    if (wr.getSample(x - 1, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y + 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean EastReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x + 1, y, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x - 1, y, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x + 1, y + 1, 0) + d >= v && wr.getSample(x, y + 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x + 1, y - 1, 0) + d < v || wr.getSample(x, y - 1, 0) >= v + d;
    }

    private void EastReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.EastReductible(wr, x, y, d)) {
                    int max = wr.getSample(x + 1, y, 0);
                    if (wr.getSample(x + 1, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y + 1, 0));
                    }
                    if (wr.getSample(x + 1, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y - 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean NorthEastReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x + 1, y + 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x - 1, y - 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x, y + 1, 0) + d >= v && wr.getSample(x - 1, y + 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x + 1, y, 0) + d < v || wr.getSample(x + 1, y - 1, 0) >= v + d;
    }

    private void NorthEastReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.NorthEastReductible(wr, x, y, d)) {
                    int max = wr.getSample(x + 1, y + 1, 0);
                    if (wr.getSample(x, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x, y + 1, 0));
                    }
                    if (wr.getSample(x + 1, y, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean NorthWestReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x - 1, y + 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x + 1, y - 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x - 1, y, 0) + d >= v && wr.getSample(x - 1, y - 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x, y + 1, 0) + d < v || wr.getSample(x + 1, y + 1, 0) >= v + d;
    }

    private void NorthWestReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.NorthWestReductible(wr, x, y, d)) {
                    int max = wr.getSample(x - 1, y + 1, 0);
                    if (wr.getSample(x - 1, y, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y, 0));
                    }
                    if (wr.getSample(x, y + 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x, y + 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean SouthEastReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x + 1, y - 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x - 1, y + 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x + 1, y, 0) + d >= v && wr.getSample(x + 1, y + 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x, y - 1, 0) + d < v || wr.getSample(x - 1, y - 1, 0) >= v + d;
    }

    private void SouthEastReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.SouthEastReductible(wr, x, y, d)) {
                    int max = wr.getSample(x + 1, y - 1, 0);
                    if (wr.getSample(x + 1, y, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x + 1, y, 0));
                    }
                    if (wr.getSample(x, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x, y - 1, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    private boolean SouthWestReductible(WritableRaster wr, int x, int y, int d) {
        int v = wr.getSample(x, y, 0);
        if (wr.getSample(x - 1, y - 1, 0) + d >= v) {
            return false;
        }
        if (wr.getSample(x + 1, y + 1, 0) < v + d) {
            return false;
        }
        if (wr.getSample(x - 1, y, 0) + d >= v && wr.getSample(x - 1, y + 1, 0) < v + d) {
            return false;
        }
        return wr.getSample(x, y - 1, 0) + d < v || wr.getSample(x + 1, y - 1, 0) >= v + d;
    }

    private void SouthWestReplace(WritableRaster wr, int d, WritableRaster wrres) {
        for (int y = 1; y < this.ey; ++y) {
            for (int x = 1; x < this.ex; ++x) {
                if (this.SouthWestReductible(wr, x, y, d)) {
                    int max = wr.getSample(x - 1, y - 1, 0);
                    if (wr.getSample(x, y - 1, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x, y - 1, 0));
                    }
                    if (wr.getSample(x - 1, y, 0) + d < wr.getSample(x, y, 0)) {
                        max = Math.max(max, wr.getSample(x - 1, y, 0));
                    }
                    wrres.setSample(x, y, 0, max);
                    continue;
                }
                wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
            }
        }
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameter required.");
        }
        this.D = (Integer)parameters[0];
        this.EightConnex = (Boolean)parameters[1];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.D);
        params.add(this.EightConnex);
        return params;
    }
}

