/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class Thinning
implements SignalFilter {
    public static final int HIGHER = 1;
    public static final int LOWER = 0;
    public static final int OTHER = -1;
    private int height;
    private int width;
    private BufferedImage[] temp = new BufferedImage[2];
    private int[][][] Neighbourhood = null;

    public Thinning(int[][][] Neighbourhood) {
        this.Neighbourhood = Neighbourhood;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)Original)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.width = Original.getWidth();
        this.height = Original.getHeight();
        if (this.temp[0] == null || !ImageTools.areDimensionsEqual((BufferedImage)this.temp[0], (BufferedImage)Original)) {
            this.temp[0] = ImageNew.Same((BufferedImage)Original);
            this.temp[1] = ImageNew.Same((BufferedImage)Original);
        }
        this.Thin(Original, this.temp[0], 0);
        for (int i2 = 1; i2 < this.Neighbourhood.length - 1; ++i2) {
            this.Thin(this.temp[(i2 + 1) % 2], this.temp[i2 % 2], i2);
        }
        this.Thin(this.temp[this.Neighbourhood.length % 2], Result, this.Neighbourhood.length - 1);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private void Thin(BufferedImage source, BufferedImage result, int Num) {
        int H = this.height - 1;
        int W = this.width - 1;
        WritableRaster wr = source.getRaster();
        WritableRaster wrres = result.getRaster();
        for (int y = 1; y < H; ++y) {
            for (int x = 1; x < W; ++x) {
                if (wr.getSample(x, y, 0) > 0) {
                    if (this.CompatibleNeighbourhood(source, x, y, Num)) {
                        wrres.setSample(x, y, 0, 0);
                        continue;
                    }
                    wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
                    continue;
                }
                wrres.setSample(x, y, 0, 0);
            }
        }
        wrres = null;
        wr = null;
    }

    private boolean CompatibleNeighbourhood(BufferedImage Original, int x, int y, int Num) {
        WritableRaster wr = Original.getRaster();
        for (int i2 = -1; i2 < 2; ++i2) {
            block6: for (int j = -1; j < 2; ++j) {
                switch (this.Neighbourhood[Num][i2 + 1][j + 1]) {
                    case 1: {
                        if (wr.getSample(x, y, 0) <= wr.getSample(x + j, y + i2, 0)) continue block6;
                        return false;
                    }
                    case 0: {
                        if (wr.getSample(x + j, y + i2, 0) < wr.getSample(x, y, 0)) continue block6;
                        return false;
                    }
                    case -1: {
                        continue block6;
                    }
                    default: {
                        throw new Error("Must not occured.");
                    }
                }
            }
        }
        wr = null;
        return true;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.Neighbourhood = (int[][][])parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.Neighbourhood);
        return params;
    }
}

