/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import imageTiTi.ImageConverter;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;

public class Skeleton_Gray {
    private int Step = 0;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.Step == 0) {
            throw new IllegalArgumentException("Paramter Step not defined.");
        }
        this.Filter(Original, Result, this.Step, nbCPU);
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int step, int nbCPU) {
        if (Original.getType() != 10) {
            throw new IllegalArgumentException("Only type BYTE_GRAY supported.");
        }
        int[][] gray = ImageConverter.ImageToInt((BufferedImage)Original);
        int[][] res = this.multipleThresholdThinning(gray, Original.getHeight(), Original.getWidth(), step);
        ImageConverter.ArrayToImage((int[][])res, (BufferedImage)Result);
    }

    public int[][] multipleThresholdThinning(int[][] image, int width, int height, int step) {
        int x;
        int y;
        int[] grayhisto = new int[256];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                int n = image[x][y];
                grayhisto[n] = grayhisto[n] + 1;
            }
        }
        int[] graycdf = new int[256];
        graycdf[0] = 0;
        for (int i2 = 1; i2 < 256; ++i2) {
            graycdf[i2] = graycdf[i2 - 1] + grayhisto[i2];
        }
        int[][] accumulator = new int[width][height];
        byte[][] work = new byte[width][height];
        int plevel = 0;
        int level = 0;
        int EQStep = (int)((double)graycdf[255] / (double)step + 0.5);
        while (true) {
            if (level < 256 && graycdf[level] - graycdf[plevel] < EQStep) {
                ++level;
                continue;
            }
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (work[x][y] != 1) continue;
                    int[] nArray = accumulator[x];
                    int n = y;
                    nArray[n] = nArray[n] + (level - plevel);
                }
            }
            if (level >= 256) break;
            plevel = level;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    work[x][y] = image[x][y] >= level ? (byte)1 : 0;
                }
            }
            new SkeletonBinary().thinning(work, width, height);
        }
        int max = 0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                max = Math.max(max, accumulator[x][y]);
            }
        }
        if (max > 0) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    accumulator[x][y] = (int)((double)accumulator[x][y] * 255.0 / (double)max + 0.5);
                }
            }
        }
        return accumulator;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Only 1 parameter required.");
        }
        this.Step = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        Vector<Object> params = new Vector<Object>(1);
        params.add(this.Step);
        return params;
    }

    private class SkeletonBinary {
        private byte[] pattern1 = new byte[]{-1, 1, 0, 1, 0, 0, 0, 0};
        private byte[] pattern2 = new byte[]{0, 1, 0, 1, -1, 0, 0, 0};
        private byte[] pattern3 = new byte[]{0, 0, -1, 1, 0, 1, 0, 0};
        private byte[] pattern4 = new byte[]{0, 0, 0, 1, 0, 1, -1, 0};
        private byte[] pattern5 = new byte[]{0, 0, 0, 0, -1, 1, 0, 1};
        private byte[] pattern6 = new byte[]{-1, 0, 0, 0, 0, 1, 0, 1};
        private byte[] pattern7 = new byte[]{0, 1, 0, 0, 0, 0, -1, 1};
        private byte[] pattern8 = new byte[]{0, 1, -1, 0, 0, 0, 0, 1};

        private SkeletonBinary() {
        }

        private int neighbourhood(byte[][] c, int x, int y) {
            int neighbourhood = 0;
            if (c[x - 1][y - 1] == 1) {
                ++neighbourhood;
            }
            if (c[x - 1][y] == 1) {
                ++neighbourhood;
            }
            if (c[x - 1][y + 1] == 1) {
                ++neighbourhood;
            }
            if (c[x][y + 1] == 1) {
                ++neighbourhood;
            }
            if (c[x + 1][y + 1] == 1) {
                ++neighbourhood;
            }
            if (c[x + 1][y] == 1) {
                ++neighbourhood;
            }
            if (c[x + 1][y - 1] == 1) {
                ++neighbourhood;
            }
            if (c[x][y - 1] == 1) {
                ++neighbourhood;
            }
            return neighbourhood;
        }

        private int transitions(byte[][] c, int x, int y) {
            int transitions = 0;
            if (c[x - 1][y - 1] == 0 && c[x - 1][y] == 1) {
                ++transitions;
            }
            if (c[x - 1][y] == 0 && c[x - 1][y + 1] == 1) {
                ++transitions;
            }
            if (c[x - 1][y + 1] == 0 && c[x][y + 1] == 1) {
                ++transitions;
            }
            if (c[x][y + 1] == 0 && c[x + 1][y + 1] == 1) {
                ++transitions;
            }
            if (c[x + 1][y + 1] == 0 && c[x + 1][y] == 1) {
                ++transitions;
            }
            if (c[x + 1][y] == 0 && c[x + 1][y - 1] == 1) {
                ++transitions;
            }
            if (c[x + 1][y - 1] == 0 && c[x][y - 1] == 1) {
                ++transitions;
            }
            if (c[x][y - 1] == 0 && c[x - 1][y - 1] == 1) {
                ++transitions;
            }
            return transitions;
        }

        private boolean matchPattern(byte[][] c, int x, int y, byte[] pattern) {
            if (pattern[0] != -1 && pattern[0] != c[x - 1][y - 1]) {
                return false;
            }
            if (pattern[1] != -1 && pattern[1] != c[x - 1][y]) {
                return false;
            }
            if (pattern[2] != -1 && pattern[2] != c[x - 1][y + 1]) {
                return false;
            }
            if (pattern[3] != -1 && pattern[3] != c[x][y + 1]) {
                return false;
            }
            if (pattern[4] != -1 && pattern[4] != c[x + 1][y + 1]) {
                return false;
            }
            if (pattern[5] != -1 && pattern[5] != c[x + 1][y]) {
                return false;
            }
            if (pattern[6] != -1 && pattern[6] != c[x + 1][y - 1]) {
                return false;
            }
            return pattern[7] == -1 || pattern[7] == c[x][y - 1];
        }

        private boolean matchOneOfPatterns(byte[][] c, int x, int y) {
            if (this.matchPattern(c, x, y, this.pattern1)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern2)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern3)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern4)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern5)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern6)) {
                return true;
            }
            if (this.matchPattern(c, x, y, this.pattern7)) {
                return true;
            }
            return this.matchPattern(c, x, y, this.pattern8);
        }

        public void thinning(byte[][] image, int width, int height) {
            boolean changed;
            byte[][] buffer = new byte[3][height];
            for (int y = 0; y < height; ++y) {
                buffer[0][y] = 0;
                buffer[1][y] = image[0][y];
                buffer[2][y] = image[1][y];
            }
            do {
                changed = false;
                for (int x = 1; x < width - 1; ++x) {
                    byte[] swp0 = buffer[0];
                    buffer[0] = buffer[1];
                    buffer[1] = buffer[2];
                    buffer[2] = swp0;
                    System.arraycopy(image[x + 1], 0, buffer[2], 0, height);
                    for (int y = 1; y < height - 1; ++y) {
                        int transitionsCount;
                        int currentNeighbourhood;
                        byte v = image[x][y];
                        if (v == 0 || (currentNeighbourhood = this.neighbourhood(buffer, 1, y)) <= 1 || currentNeighbourhood >= 6 || (transitionsCount = this.transitions(image, x, y)) == 1 && currentNeighbourhood <= 3) continue;
                        if (transitionsCount == 1) {
                            changed = true;
                            image[x][y] = 0;
                            continue;
                        }
                        boolean matchOne = this.matchOneOfPatterns(image, x, y);
                        if (!matchOne) continue;
                        changed = true;
                        image[x][y] = 0;
                    }
                }
            } while (changed);
        }
    }
}

