/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import arrayTiTi.ArrayOperations;
import java.awt.image.BufferedImage;
import java.util.Vector;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.cclh.UnionFindCcl;

public class SkeletonTools {
    public static int CountNeighbor(BufferedImage skel, int x, int y, boolean eightconnex) {
        int nb = 0;
        if (skel.getRaster().getSample(x + 1, y, 0) != 0) {
            ++nb;
        }
        if (skel.getRaster().getSample(x - 1, y, 0) != 0) {
            ++nb;
        }
        if (skel.getRaster().getSample(x, y + 1, 0) != 0) {
            ++nb;
        }
        if (skel.getRaster().getSample(x, y - 1, 0) != 0) {
            ++nb;
        }
        if (eightconnex) {
            if (skel.getRaster().getSample(x + 1, y + 1, 0) != 0) {
                ++nb;
            }
            if (skel.getRaster().getSample(x + 1, y - 1, 0) != 0) {
                ++nb;
            }
            if (skel.getRaster().getSample(x - 1, y + 1, 0) != 0) {
                ++nb;
            }
            if (skel.getRaster().getSample(x - 1, y - 1, 0) != 0) {
                ++nb;
            }
        }
        return nb;
    }

    public static int CountNeighbor(BufferedImage skel, boolean[][] forbiden, int x, int y, boolean eightconnex) {
        int nb = 0;
        if (skel.getRaster().getSample(x + 1, y, 0) != 0 && !forbiden[y][x + 1]) {
            ++nb;
        }
        if (skel.getRaster().getSample(x - 1, y, 0) != 0 && !forbiden[y][x - 1]) {
            ++nb;
        }
        if (skel.getRaster().getSample(x, y + 1, 0) != 0 && !forbiden[y + 1][x]) {
            ++nb;
        }
        if (skel.getRaster().getSample(x, y - 1, 0) != 0 && !forbiden[y - 1][x]) {
            ++nb;
        }
        if (eightconnex) {
            if (skel.getRaster().getSample(x + 1, y + 1, 0) != 0 && !forbiden[y + 1][x + 1]) {
                ++nb;
            }
            if (skel.getRaster().getSample(x + 1, y - 1, 0) != 0 && !forbiden[y - 1][x + 1]) {
                ++nb;
            }
            if (skel.getRaster().getSample(x - 1, y + 1, 0) != 0 && !forbiden[y + 1][x - 1]) {
                ++nb;
            }
            if (skel.getRaster().getSample(x - 1, y - 1, 0) != 0 && !forbiden[y - 1][x - 1]) {
                ++nb;
            }
        }
        return nb;
    }

    public static int CountNeighbor(int[][] skel, int x, int y, boolean eightconnex) {
        int nb = 0;
        if (skel[y][x + 1] != 0) {
            ++nb;
        }
        if (skel[y][x - 1] != 0) {
            ++nb;
        }
        if (skel[y + 1][x] != 0) {
            ++nb;
        }
        if (skel[y - 1][x] != 0) {
            ++nb;
        }
        if (eightconnex) {
            if (skel[y + 1][x + 1] != 0) {
                ++nb;
            }
            if (skel[y - 1][x + 1] != 0) {
                ++nb;
            }
            if (skel[y + 1][x - 1] != 0) {
                ++nb;
            }
            if (skel[y - 1][x - 1] != 0) {
                ++nb;
            }
        }
        return nb;
    }

    public static BufferedImage ExtractFinalBranches(BufferedImage skel) {
        int nb;
        int x;
        int y;
        int width = skel.getWidth();
        int height = skel.getHeight();
        Vector<Coordinates> list = new Vector<Coordinates>(113);
        Coordinates c = null;
        for (y = 1; y < height - 1; ++y) {
            for (x = 1; x < width - 1; ++x) {
                if (skel.getRaster().getSample(x, y, 0) == 0 || (nb = SkeletonTools.CountNeighbor(skel, x, y, true)) != 2) continue;
                list.add(new Coordinates(x, y));
            }
        }
        BufferedImage result = new BufferedImage(width, height, 12);
        boolean[][] forbiden = new boolean[height][width];
        for (int l = 0; l < list.size(); ++l) {
            boolean ok;
            ArrayOperations.Fill((boolean[][])forbiden, (boolean)false);
            c = (Coordinates)list.get(l);
            x = c.X;
            y = c.Y;
            result.getRaster().setSample(x, y, 0, 1);
            forbiden[y][x] = true;
            do {
                ok = true;
                nb = 0;
                for (int i2 = -1; i2 <= 1; ++i2) {
                    for (int j = -1; j <= 1 && ok; ++j) {
                        if (skel.getRaster().getSample(x + j, y + i2, 0) == 0 || forbiden[y + i2][x + j]) continue;
                        forbiden[y += i2][x += j] = true;
                        nb = SkeletonTools.CountNeighbor(skel, forbiden, x, y, true);
                        ok = false;
                    }
                }
                if (ok) continue;
                if (nb == 1) {
                    result.getRaster().setSample(x, y, 0, 1);
                    continue;
                }
                ok = true;
            } while (!ok);
        }
        return result;
    }

    private static void DeleteBranch(BufferedImage branches, int x, int y) {
        branches.getRaster().setSample(x, y, 0, 0);
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j = -1; j <= 1; ++j) {
                if (branches.getRaster().getSample(x + j, y + i2, 0) == 0) continue;
                SkeletonTools.DeleteBranch(branches, x + j, y + i2);
            }
        }
    }

    public static void CleanBranchesSpecial(BufferedImage branches, double[][] map, double coef) {
        UnionFindCcl ccl = new UnionFindCcl();
        ccl.Label(branches, 0, true);
        int[] sizes = ccl.Sizes();
        int[] labels = ccl.Labels1D();
        int width = branches.getWidth();
        int height = branches.getHeight();
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                if (branches.getRaster().getSample(x, y, 0) == 0 || SkeletonTools.CountNeighbor(branches, x, y, true) != 1) continue;
                double max = 0.0;
                for (int i2 = -1; i2 <= 1; ++i2) {
                    for (int j = -1; j <= 1; ++j) {
                        if (!(max < map[y + i2][x + j])) continue;
                        max = map[y + i2][x + j];
                    }
                }
                if (!((double)sizes[labels[y * width + x]] < coef * max + 0.5)) continue;
                SkeletonTools.DeleteBranch(branches, x, y);
            }
        }
    }
}

