/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import arrayTiTi.ArrayFeatures;
import characterization.shapes.skeletons.ISkeleton;
import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.histogram.Histogram;
import processing.thresholding.Binary;

public class SkeletonGray
implements ISkeleton {
    private ISkeleton skeleton = null;
    private int maxiter = -1;
    private double percent = -1.0;
    private BufferedImage bin;
    private BufferedImage skel;
    private BufferedImage skelnew;
    private BufferedImage resbin;
    private final Histogram histogram = new Histogram();
    private final Binary binary = new Binary();
    private final List<Coordinates> anchors = new ArrayList<Coordinates>(113);
    private final ArrayFeatures AF = new ArrayFeatures();

    public SkeletonGray(ISkeleton skeleton) {
        this.skeleton = skeleton;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, null, result, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage image, List<Coordinates> anchors, int nbCPU) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        this.Filter(image, anchors, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage source, List<Coordinates> anchors, BufferedImage result, int nbCPU) {
        if (0.0 < this.percent) {
            this.Filter(source, anchors, this.percent, result, nbCPU);
        } else if (0 < this.maxiter) {
            this.Filter(source, anchors, this.maxiter, result, nbCPU);
        } else {
            throw new IllegalArgumentException("Iteration max and percentage not defined => must define at least one.");
        }
    }

    public void Filter(BufferedImage source, List<Coordinates> list, int itermax, BufferedImage result, int nbCPU) {
        int x;
        int y;
        int i2;
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different type or dimension.");
        }
        this.Parameters(itermax);
        if (this.bin == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.bin, (BufferedImage)source)) {
            this.bin = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.resbin = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.skel = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.skelnew = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int neighboors = 3;
        this.histogram.Fill(source);
        int[] hist = this.histogram.getValues(0);
        int maxthreshold = 0;
        int nbthreshold = 0;
        int minthreshold = hist.length;
        for (i2 = 1; i2 < hist.length; ++i2) {
            if (0 >= hist[i2]) continue;
            ++nbthreshold;
            if (i2 < minthreshold) {
                minthreshold = i2;
            }
            if (maxthreshold >= i2) continue;
            maxthreshold = i2;
        }
        int nb = nbthreshold / itermax;
        ImageOperations.Fill((BufferedImage)this.resbin, (int)0);
        int n = nb;
        for (int t = maxthreshold; minthreshold <= t; --t) {
            if (hist[t] <= 0) continue;
            if (n == nb || t == minthreshold) {
                this.binary.Filter(source, t, this.bin, nbCPU);
                this.AddAnchors(this.anchors, list, this.bin);
                this.skeleton.Filter(this.bin, this.anchors, this.skel, nbCPU);
                ImageNew.Copy((BufferedImage)this.skel, (BufferedImage)this.skelnew);
                for (y = 1; y < height - 1; ++y) {
                    for (x = 1; x < width - 1; ++x) {
                        if (this.skel.getRaster().getSample(x, y, 0) == 0) continue;
                        int count = 0;
                        for (i2 = -1; i2 <= 1; ++i2) {
                            for (int j = -1; j <= 1; ++j) {
                                if (i2 == 0 || j == 0 || this.skel.getRaster().getSample(x + i2, y + j, 0) == 0) continue;
                                ++count;
                            }
                        }
                        if (neighboors >= count || this.resbin.getRaster().getSample(x, y, 0) != 0) continue;
                        this.skelnew.getRaster().setSample(x, y, 0, 0);
                    }
                }
                ImageNew.Copy((BufferedImage)this.skelnew, (BufferedImage)this.resbin);
                this.anchors.clear();
                ImageConverter.ImageToListOfPoints((BufferedImage)this.resbin, this.anchors);
                n = nb;
            }
            n = --n == 0 ? nb : n;
        }
        ImageNew.Copy((BufferedImage)source, (BufferedImage)result);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (this.resbin.getRaster().getSample(x, y, 0) != 0) continue;
                result.getRaster().setSample(x, y, 0, 0);
            }
        }
    }

    public void Filter(BufferedImage source, List<Coordinates> list, double percentage, BufferedImage result, int nbCPU) {
        int x;
        int y;
        int i2;
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different type or dimension.");
        }
        this.Parameters(percentage);
        if (this.bin == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.bin, (BufferedImage)source)) {
            this.bin = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.resbin = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.skel = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            this.skelnew = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        }
        int width = source.getWidth();
        int height = source.getHeight();
        this.histogram.Fill(source, 0);
        int[] hist = this.histogram.getValues(0);
        int integral = (int)this.AF.Integral(hist);
        int maxthreshold = 0;
        int minthreshold = hist.length;
        for (i2 = 1; i2 < hist.length; ++i2) {
            if (0 >= hist[i2]) continue;
            if (i2 < minthreshold) {
                minthreshold = i2;
            }
            if (maxthreshold >= i2) continue;
            maxthreshold = i2;
        }
        ImageOperations.Fill((BufferedImage)this.resbin, (int)0);
        int sum = 0;
        double nb = percentage;
        int neighboors = 3;
        for (int t = maxthreshold; minthreshold <= t; --t) {
            if (hist[t] <= 0 || !((double)(sum += hist[t]) / (double)integral * 100.0 >= nb) && t != minthreshold) continue;
            this.binary.Filter(source, t, this.bin, nbCPU);
            this.AddAnchors(this.anchors, list, this.bin);
            this.skeleton.Filter(this.bin, this.anchors, this.skel, nbCPU);
            ImageNew.Copy((BufferedImage)this.skel, (BufferedImage)this.skelnew);
            for (y = 1; y < height - 1; ++y) {
                for (x = 1; x < width - 1; ++x) {
                    if (this.skel.getRaster().getSample(x, y, 0) == 0) continue;
                    int count = 0;
                    for (i2 = -1; i2 <= 1; ++i2) {
                        for (int j = -1; j <= 1; ++j) {
                            if (i2 == 0 || j == 0 || this.skel.getRaster().getSample(x + i2, y + j, 0) == 0) continue;
                            ++count;
                        }
                    }
                    if (neighboors >= count || this.resbin.getRaster().getSample(x, y, 0) != 0) continue;
                    this.skelnew.getRaster().setSample(x, y, 0, 0);
                }
            }
            ImageNew.Copy((BufferedImage)this.skelnew, (BufferedImage)this.resbin);
            this.anchors.clear();
            ImageConverter.ImageToListOfPoints((BufferedImage)this.resbin, this.anchors);
            nb += percentage;
        }
        ImageNew.Copy((BufferedImage)source, (BufferedImage)result);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (this.resbin.getRaster().getSample(x, y, 0) != 0) continue;
                result.getRaster().setSample(x, y, 0, 0);
            }
        }
    }

    private void AddAnchors(List<Coordinates> anchors, List<Coordinates> list, BufferedImage bin) {
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Coordinates p = list.get(i2);
            if (bin.getRaster().getSample(p.X, p.Y, 0) == 0) continue;
            anchors.add(p);
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ISkeleton Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        if (parameters[0] instanceof Integer) {
            this.maxiter = (Integer)parameters[0];
        } else if (parameters[0] instanceof Double) {
            this.percent = (Double)parameters[0];
        } else {
            throw new IllegalArgumentException("Second parameter must be Integer (define iteration max) or Double (define percentage).");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.maxiter);
        list.add(this.percent);
        return list;
    }
}

