/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import arrayTiTi.ArrayOperations;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import processing.filters.SignalFilter;

public class PruneRough
implements SignalFilter {
    private static final int HIGHER = 1;
    private static final int LOWER = 0;
    private static final int OTHER = -1;
    private int[][][] Neighbourhood = new int[8][3][3];
    private int height;
    private int width;
    private BufferedImage[] temp = new BufferedImage[2];
    private BufferedImage[] tampon = new BufferedImage[2];

    public PruneRough() {
        this.CreateNeighbourhood();
    }

    public BufferedImage Filter(BufferedImage source, int nbIterations, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, nbIterations, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, int nbIterations, BufferedImage Result, int nbCPU) {
        if (this.tampon[0] == null || !ImageTools.areDimensionsEqual((BufferedImage)this.tampon[0], (BufferedImage)source)) {
            this.tampon[0] = ImageNew.Same((BufferedImage)source);
            this.tampon[1] = ImageNew.Same((BufferedImage)source);
        }
        if (nbIterations == 1) {
            this.Filter(source, Result, 0);
            return;
        }
        this.Filter(source, this.tampon[0], 0);
        for (int i2 = 1; i2 < nbIterations - 1; ++i2) {
            this.Filter(this.tampon[(i2 + 1) % 2], this.tampon[i2 % 2], 0);
        }
        this.Filter(this.tampon[nbIterations % 2], Result, 0);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)Original)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.width = Original.getWidth();
        this.height = Original.getHeight();
        if (this.temp[0] == null || !ImageTools.areDimensionsEqual((BufferedImage)this.temp[0], (BufferedImage)Original)) {
            this.temp[0] = ImageNew.Same((BufferedImage)Original);
            this.temp[1] = ImageNew.Same((BufferedImage)Original);
        }
        this.Thin(Original, this.temp[0], 0);
        for (int i2 = 1; i2 < 7; ++i2) {
            this.Thin(this.temp[(i2 + 1) % 2], this.temp[i2 % 2], i2);
        }
        this.Thin(this.temp[0], Result, 7);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private void Thin(BufferedImage source, BufferedImage result, int Num) {
        WritableRaster wr = source.getRaster();
        WritableRaster wrres = result.getRaster();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (wr.getSample(x, y, 0) > 0) {
                    if (this.CompatibleNeighbourhood(source, x, y, Num)) {
                        wrres.setSample(x, y, 0, 0);
                        continue;
                    }
                    wrres.setSample(x, y, 0, wr.getSample(x, y, 0));
                    continue;
                }
                wrres.setSample(x, y, 0, 0);
            }
        }
        wrres = null;
        wr = null;
    }

    private boolean CompatibleNeighbourhood(BufferedImage Original, int x, int y, int Num) {
        WritableRaster wr = Original.getRaster();
        for (int i2 = -1; i2 < 2; ++i2) {
            block5: for (int j = -1; j < 2; ++j) {
                if (this.Neighbourhood[Num][i2 + 1][j + 1] == -1 || y + i2 < 0 || y + i2 >= this.height || x + j < 0 || x + j >= this.width) continue;
                switch (this.Neighbourhood[Num][i2 + 1][j + 1]) {
                    case 1: {
                        if (wr.getSample(x, y, 0) <= wr.getSample(x + j, y + i2, 0)) continue block5;
                        return false;
                    }
                    case 0: {
                        if (wr.getSample(x + j, y + i2, 0) < wr.getSample(x, y, 0)) continue block5;
                        return false;
                    }
                    default: {
                        throw new Error("Must not occured.");
                    }
                }
            }
        }
        wr = null;
        return true;
    }

    private void CreateNeighbourhood() {
        for (int i2 = 0; i2 < 8; ++i2) {
            ArrayOperations.Fill((int[][])this.Neighbourhood[i2], (int)0);
            this.Neighbourhood[i2][1][1] = 1;
        }
        this.Neighbourhood[0][0][1] = 1;
        this.Neighbourhood[1][0][2] = 1;
        this.Neighbourhood[2][1][2] = 1;
        this.Neighbourhood[3][2][2] = 1;
        this.Neighbourhood[4][2][1] = 1;
        this.Neighbourhood[5][2][0] = 1;
        this.Neighbourhood[6][1][0] = 1;
        this.Neighbourhood[7][0][0] = 1;
        this.Neighbourhood[0][0][2] = -1;
        this.Neighbourhood[1][1][2] = -1;
        this.Neighbourhood[2][2][2] = -1;
        this.Neighbourhood[3][2][1] = -1;
        this.Neighbourhood[4][2][0] = -1;
        this.Neighbourhood[5][1][0] = -1;
        this.Neighbourhood[6][0][0] = -1;
        this.Neighbourhood[7][0][1] = -1;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }
}

