/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.skeletons;

import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import utils.pointers.IntPointer;

public class BezerraSkel {
    private int NDG_MIN = 0;
    public static final int SYMMETRIC = 0;
    public static final int ASYMMETRIC = 1;
    private int nsteps = -1;
    private int processing = 0;
    private int[] F;
    private int[] D;
    private int[] A;
    private int[] G;
    private int[][] TopoTab = new int[][]{{1, 0}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {3, 3}, {3, 3}, {3, 3}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {3, 3}, {2, 2}, {3, 3}, {2, 2}, {3, 3}, {3, 3}, {4, 4}, {3, 3}, {3, 3}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {2, 2}, {2, 2}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}};
    private int _nnw55 = 1;
    private int _nn55 = 2;
    private int _nne55 = 3;
    private int _nww55 = 5;
    private int _nw55 = 6;
    private int _n55 = 7;
    private int _ne55 = 8;
    private int _nee55 = 9;
    private int _ww55 = 10;
    private int _w55 = 11;
    private int _center55 = 12;
    private int _e55 = 13;
    private int _ee55 = 14;
    private int _sww55 = 15;
    private int _sw55 = 16;
    private int _s55 = 17;
    private int _se55 = 18;
    private int _see55 = 19;
    private int _ssw55 = 21;
    private int _ss55 = 22;
    private int _sse55 = 23;
    private int IN_SET = 1;
    private int NON_DESTRUCTIBLE = 0;
    private int DESTRUCTIBLE = 1;
    private int CRUCIAL = 3;
    private int CRUCIAL_C = 9;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.nsteps, this.processing, result, nbCPU);
    }

    public void Filter(BufferedImage source, int nsteps, int processing, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        this.Parameters(nsteps, processing);
        switch (processing) {
            case 1: {
                this.Asymmetric(source, nsteps, result);
                break;
            }
            case 0: {
                this.Symmetric(source, nsteps, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown processing.");
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.nsteps = (Integer)parameters[0];
        this.processing = (Integer)parameters[1];
    }

    public List<Object> Parameters() {
        Vector<Object> params = new Vector<Object>(2);
        params.add(this.nsteps);
        params.add(this.processing);
        return params;
    }

    private void Symmetric(BufferedImage image, int nsteps, BufferedImage result) {
        boolean nonstab;
        int rs = image.getWidth();
        int cs = image.getHeight();
        int N = rs * cs;
        switch (image.getType()) {
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.F == null || this.F.length != N) {
            this.G = null;
            this.A = null;
            this.D = null;
            this.F = null;
            this.F = new int[N];
            this.D = new int[N];
            this.A = new int[N];
            this.G = new int[N];
        }
        ImageConverter.ImageToArray1D((BufferedImage)image, (int[])this.F);
        if (nsteps == -1) {
            nsteps = 1000000000;
        }
        int step = 0;
        do {
            int p;
            nonstab = false;
            for (p = 0; p < N; ++p) {
                this.A[p] = this.alpha8m(this.F, p, rs, N);
                this.D[p] = 0 != this.pdestr4(this.F, p, rs, N) ? this.DESTRUCTIBLE : this.NON_DESTRUCTIBLE;
            }
            this.match_C(this.F, this.D, this.A, rs, N);
            this.match_C1(this.F, this.D, this.A, rs, N);
            this.match_C2(this.F, this.D, this.A, rs, N);
            this.match_C3(this.F, this.D, this.A, rs, N);
            this.match_C4(this.F, this.D, this.A, rs, N);
            for (p = 0; p < N; ++p) {
                if (this.D[p] == this.DESTRUCTIBLE) {
                    this.G[p] = this.A[p];
                    nonstab = true;
                    continue;
                }
                this.G[p] = this.F[p];
            }
            System.arraycopy(this.G, 0, this.F, 0, this.G.length);
        } while (nonstab && ++step < nsteps);
        ImageConverter.ArrayToImage((int[])this.F, (BufferedImage)result);
    }

    private void Asymmetric(BufferedImage image, int nsteps, BufferedImage result) {
        boolean nonstab;
        int rs = image.getWidth();
        int cs = image.getHeight();
        int N = rs * cs;
        switch (image.getType()) {
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.F == null || this.F.length != N) {
            this.G = null;
            this.A = null;
            this.D = null;
            this.F = null;
            this.F = new int[N];
            this.D = new int[N];
            this.A = new int[N];
            this.G = new int[N];
        }
        ImageConverter.ImageToArray1D((BufferedImage)image, (int[])this.F);
        if (nsteps == -1) {
            nsteps = 1000000000;
        }
        int step = 0;
        do {
            int p;
            nonstab = false;
            for (p = 0; p < N; ++p) {
                this.A[p] = this.alpha8m(this.F, p, rs, N);
                this.D[p] = 0 != this.pdestr4(this.F, p, rs, N) ? this.DESTRUCTIBLE : this.NON_DESTRUCTIBLE;
            }
            this.match_C_asymmetric(this.F, this.D, this.A, rs, N);
            this.match_C1_asymmetric(this.F, this.D, this.A, rs, N);
            this.match_C2_asymmetric(this.F, this.D, this.A, rs, N);
            this.match_C3_asymmetric(this.F, this.D, this.A, rs, N);
            this.match_C4_asymmetric(this.F, this.D, this.A, rs, N);
            for (p = 0; p < N; ++p) {
                if (this.D[p] == this.DESTRUCTIBLE) {
                    this.G[p] = this.A[p];
                    nonstab = true;
                    continue;
                }
                this.G[p] = this.F[p];
            }
            System.arraycopy(this.G, 0, this.F, 0, this.G.length);
        } while (nonstab && ++step < nsteps);
        ImageConverter.ArrayToImage((int[])this.F, (BufferedImage)result);
    }

    private int alpha8m(int[] img, int p, int rs, int N) {
        int v;
        int val = img[p];
        int ptr = p;
        int alpha = this.NDG_MIN - 1;
        int n = v = p % rs != rs - 1 ? img[ptr + 1] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n2 = v = p % rs != rs - 1 && p >= rs ? img[ptr + 1 - rs] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n3 = v = p >= rs ? img[ptr - rs] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n4 = v = p >= rs && p % rs != 0 ? img[ptr - rs - 1] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n5 = v = p % rs != 0 ? img[ptr - 1] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n6 = v = p % rs != 0 && p < N - rs ? img[ptr - 1 + rs] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n7 = v = p < N - rs ? img[ptr + rs] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        int n8 = v = p < N - rs && p % rs != rs - 1 ? img[ptr + rs + 1] : val;
        if (v < val && v > alpha) {
            alpha = v;
        }
        if (alpha == this.NDG_MIN - 1) {
            return val;
        }
        return alpha;
    }

    private int pdestr4(int[] img, int p, int rs, int N) {
        IntPointer t4mm = new IntPointer();
        IntPointer t8p = new IntPointer();
        IntPointer b = new IntPointer();
        IntPointer n = new IntPointer();
        if (p % rs == rs - 1 || p < rs || p % rs == 0 || p >= N - rs) {
            return 0;
        }
        this.nbtopo(img, p, rs, N, t4mm, b, t8p, n);
        if (t4mm.value == 1 && t8p.value == 1) {
            return 1;
        }
        return 0;
    }

    private void nbtopo(int[] img, int p, int rs, int N, IntPointer t4mm, IntPointer t4m, IntPointer t8p, IntPointer t8pp) {
        int val = img[p];
        int ptr = p;
        assert (!this.is_on_frame(p, rs, N));
        int v0 = img[ptr + 1];
        int v1 = img[ptr + 1 - rs];
        int v2 = img[ptr - rs];
        int v3 = img[ptr - rs - 1];
        int v4 = img[ptr - 1];
        int v5 = img[ptr - 1 + rs];
        int v6 = img[ptr + rs];
        int v7 = img[ptr + rs + 1];
        int t = v0 >= val ? 1 : 0;
        if (v1 >= val) {
            t |= 2;
        }
        if (v2 >= val) {
            t |= 4;
        }
        if (v3 >= val) {
            t |= 8;
        }
        if (v4 >= val) {
            t |= 0x10;
        }
        if (v5 >= val) {
            t |= 0x20;
        }
        if (v6 >= val) {
            t |= 0x40;
        }
        if (v7 >= val) {
            t |= 0x80;
        }
        t4mm.value = this.TopoTab[t][0];
        t8p.value = this.TopoTab[t][1];
        t = v0 > val ? 1 : 0;
        if (v1 > val) {
            t |= 2;
        }
        if (v2 > val) {
            t |= 4;
        }
        if (v3 > val) {
            t |= 8;
        }
        if (v4 > val) {
            t |= 0x10;
        }
        if (v5 > val) {
            t |= 0x20;
        }
        if (v6 > val) {
            t |= 0x40;
        }
        if (v7 > val) {
            t |= 0x80;
        }
        t4m.value = this.TopoTab[t][0];
        t8pp.value = this.TopoTab[t][1];
    }

    public boolean is_on_frame(int p, int rs, int N) {
        return p % rs == rs - 1 || p < rs || p % rs == 0 || p >= N - rs;
    }

    private boolean MATCH_C1(int[] D, int p, int ne, int n, int e) {
        return 0 != D[p] && 0 != D[ne] && 0 == D[n] && 0 == D[e];
    }

    private boolean MATCH_C2(int[] D, int p, int n, int e, int s, int ne, int se) {
        return 0 != D[p] && 0 != D[e] && 0 == D[s] && 0 == D[n] && 0 == D[ne] && 0 == D[se];
    }

    private boolean MATCH_C3(int[] D, int p, int n, int e, int s, int w, int ne, int se, int sw) {
        return 0 != D[p] && 0 != D[e] && 0 != D[s] && 0 == D[n] && 0 == D[ne] && 0 == D[se] && 0 == D[sw] && 0 == D[w];
    }

    private boolean MATCH_C4(int[] D, int p, int n, int e, int s, int w, int ne, int se, int sw, int ee, int see, int sse, int ss) {
        return 0 != D[p] && 0 != D[e] && 0 != D[s] && 0 != D[se] && 0 == D[n] && 0 == D[ne] && 0 == D[ee] && 0 == D[see] && 0 == D[sse] && 0 == D[ss] && 0 == D[sw] && 0 == D[w];
    }

    private boolean MATCH_C(int[] D, int p, int n, int e, int s, int ne, int se) {
        return !(0 == D[p] || 0 == D[e] || 0 == D[n] && 0 == D[ne] || 0 == D[s] && 0 == D[se]);
    }

    private int E(int _p, int _rs) {
        return _p + 1;
    }

    private int NE(int _p, int _rs) {
        return _p + 1 - _rs;
    }

    private int S(int _p, int _rs) {
        return _p + _rs;
    }

    private int SW(int _p, int _rs) {
        return _p + _rs - 1;
    }

    private int W(int _p, int _rs) {
        return _p - 1;
    }

    private int NW(int _p, int _rs) {
        return _p - 1 - _rs;
    }

    private int N(int _p, int _rs) {
        return _p - _rs;
    }

    private int SE(int _p, int _rs) {
        return _p + _rs + 1;
    }

    private int NN(int _p, int _rs) {
        return this.N(_p, _rs) - _rs;
    }

    private int SS(int _p, int _rs) {
        return this.S(_p, _rs) + _rs;
    }

    private int WW(int _p, int _rs) {
        return this.W(_p, _rs) - 1;
    }

    private int EE(int _p, int _rs) {
        return this.E(_p, _rs) + 1;
    }

    private int NEE(int _p, int _rs) {
        return this.EE(_p, _rs) - _rs;
    }

    private int NWW(int _p, int _rs) {
        return this.WW(_p, _rs) - _rs;
    }

    private int SEE(int _p, int _rs) {
        return this.EE(_p, _rs) + _rs;
    }

    private int SWW(int _p, int _rs) {
        return this.WW(_p, _rs) + _rs;
    }

    private int NNE(int _p, int _rs) {
        return this.NN(_p, _rs) + 1;
    }

    private int NNW(int _p, int _rs) {
        return this.NN(_p, _rs) - 1;
    }

    private int SSE(int _p, int _rs) {
        return this.SS(_p, _rs) + 1;
    }

    private int SSW(int _p, int _rs) {
        return this.SS(_p, _rs) - 1;
    }

    void getNeighborhood(int[] F, int rs, int N, int p, int k, int[] neighborhood) {
        neighborhood[1] = F[this.NNW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[2] = F[this.NN(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[3] = F[this.NNE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[5] = F[this.NWW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[6] = F[this.NW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[7] = F[this.N(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[8] = F[this.NE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[9] = F[this.NEE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[10] = F[this.WW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[11] = F[this.W(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[12] = F[p] >= k ? this.IN_SET : 0;
        neighborhood[13] = F[this.E(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[14] = F[this.EE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[15] = F[this.SWW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[16] = F[this.SW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[17] = F[this.S(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[18] = F[this.SE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[19] = F[this.SEE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[21] = F[this.SSW(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[22] = F[this.SS(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[23] = F[this.SSE(p, rs)] >= k ? this.IN_SET : 0;
        neighborhood[24] = 0;
        neighborhood[20] = 0;
        neighborhood[4] = 0;
        neighborhood[0] = 0;
    }

    private void match_C1(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (D[p] == 0) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.NE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._ne55, this._n55, this._e55) && A[this.NE(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.NE((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.SE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._se55, this._s55, this._e55) && A[this.SE(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.SE((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.NW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._nw55, this._n55, this._w55) && A[this.NW(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.NW((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.SW(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C1(Fk, this._center55, this._sw55, this._s55, this._w55) || A[this.SW(p, rs)] >= k) continue;
            int n = this.CRUCIAL;
            D[this.SW((int)p, (int)rs)] = n;
            D[p] = n;
        }
    }

    private void match_C1_asymmetric(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (0 == D[p]) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.NE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._ne55, this._n55, this._e55) && A[this.NE(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.SE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._se55, this._s55, this._e55) && A[this.SE(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.NW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C1(Fk, this._center55, this._nw55, this._n55, this._w55) && A[this.NW(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.SW(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C1(Fk, this._center55, this._sw55, this._s55, this._w55) || A[this.SW(p, rs)] >= k) continue;
            D[p] = this.CRUCIAL;
        }
    }

    private void match_C2(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (0 == D[p]) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._n55, this._e55, this._s55, this._ne55, this._se55) && A[this.E(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.E((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._e55, this._s55, this._w55, this._se55, this._sw55) && A[this.S(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.S((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._s55, this._w55, this._n55, this._sw55, this._nw55) && A[this.W(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.W((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C2(Fk, this._center55, this._w55, this._n55, this._e55, this._nw55, this._ne55) || A[this.N(p, rs)] >= k) continue;
            int n = this.CRUCIAL;
            D[this.N((int)p, (int)rs)] = n;
            D[p] = n;
        }
    }

    private void match_C2_asymmetric(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (0 == D[p]) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._n55, this._e55, this._s55, this._ne55, this._se55) && A[this.E(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._e55, this._s55, this._w55, this._se55, this._sw55) && A[this.S(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C2(Fk, this._center55, this._s55, this._w55, this._n55, this._sw55, this._nw55) && A[this.W(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C2(Fk, this._center55, this._w55, this._n55, this._e55, this._nw55, this._ne55) || A[this.N(p, rs)] >= k) continue;
            D[p] = this.CRUCIAL;
        }
    }

    private void match_C3(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (0 == D[p]) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._n55, this._e55, this._s55, this._w55, this._ne55, this._se55, this._sw55) && A[this.E(p, rs)] < k && A[this.S(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.S((int)p, (int)rs)] = n;
                D[this.E((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._e55, this._s55, this._w55, this._n55, this._se55, this._sw55, this._nw55) && A[this.S(p, rs)] < k && A[this.W(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.W((int)p, (int)rs)] = n;
                D[this.S((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.N(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._s55, this._w55, this._n55, this._e55, this._sw55, this._nw55, this._ne55) && A[this.W(p, rs)] < k && A[this.N(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.N((int)p, (int)rs)] = n;
                D[this.W((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || D[this.E(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C3(Fk, this._center55, this._w55, this._n55, this._e55, this._s55, this._nw55, this._ne55, this._se55) || A[this.N(p, rs)] >= k || A[this.E(p, rs)] >= k) continue;
            int n = this.CRUCIAL;
            D[this.E((int)p, (int)rs)] = n;
            D[this.N((int)p, (int)rs)] = n;
            D[p] = n;
        }
    }

    private void match_C3_asymmetric(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (0 == D[p]) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._n55, this._e55, this._s55, this._w55, this._ne55, this._se55, this._sw55) && A[this.E(p, rs)] < k && A[this.S(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._e55, this._s55, this._w55, this._n55, this._se55, this._sw55, this._nw55) && A[this.S(p, rs)] < k && A[this.W(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.N(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C3(Fk, this._center55, this._s55, this._w55, this._n55, this._e55, this._sw55, this._nw55, this._ne55) && A[this.W(p, rs)] < k && A[this.N(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || D[this.E(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C3(Fk, this._center55, this._w55, this._n55, this._e55, this._s55, this._nw55, this._ne55, this._se55) || A[this.N(p, rs)] >= k || A[this.E(p, rs)] >= k) continue;
            D[p] = this.CRUCIAL;
        }
    }

    private void match_C4(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (D[p] != this.DESTRUCTIBLE) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.SE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._n55, this._e55, this._s55, this._w55, this._ne55, this._se55, this._sw55, this._ee55, this._see55, this._sse55, this._ss55) && A[this.E(p, rs)] < k && A[this.S(p, rs)] < k && A[this.SE(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.SE((int)p, (int)rs)] = n;
                D[this.S((int)p, (int)rs)] = n;
                D[this.E((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.SW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._e55, this._s55, this._w55, this._n55, this._se55, this._sw55, this._nw55, this._ss55, this._ssw55, this._sww55, this._ww55) && A[this.S(p, rs)] < k && A[this.W(p, rs)] < k && A[this.SW(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.SW((int)p, (int)rs)] = n;
                D[this.W((int)p, (int)rs)] = n;
                D[this.S((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.N(p, rs)] == this.DESTRUCTIBLE && D[this.NW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._s55, this._w55, this._n55, this._e55, this._sw55, this._nw55, this._ne55, this._ww55, this._nww55, this._nnw55, this._nn55) && A[this.W(p, rs)] < k && A[this.N(p, rs)] < k && A[this.NW(p, rs)] < k) {
                int n = this.CRUCIAL;
                D[this.NW((int)p, (int)rs)] = n;
                D[this.N((int)p, (int)rs)] = n;
                D[this.W((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || D[this.E(p, rs)] != this.DESTRUCTIBLE || D[this.NE(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C4(Fk, this._center55, this._w55, this._n55, this._e55, this._s55, this._nw55, this._ne55, this._se55, this._nn55, this._nne55, this._nee55, this._ee55) || A[this.N(p, rs)] >= k || A[this.E(p, rs)] >= k || A[this.NE(p, rs)] >= k) continue;
            int n = this.CRUCIAL;
            D[this.NE((int)p, (int)rs)] = n;
            D[this.E((int)p, (int)rs)] = n;
            D[this.N((int)p, (int)rs)] = n;
            D[p] = n;
        }
    }

    private void match_C4_asymmetric(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (D[p] != this.DESTRUCTIBLE) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.SE(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._n55, this._e55, this._s55, this._w55, this._ne55, this._se55, this._sw55, this._ee55, this._see55, this._sse55, this._ss55) && A[this.E(p, rs)] < k && A[this.S(p, rs)] < k && A[this.SE(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.SW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._e55, this._s55, this._w55, this._n55, this._se55, this._sw55, this._nw55, this._ss55, this._ssw55, this._sww55, this._ww55) && A[this.S(p, rs)] < k && A[this.W(p, rs)] < k && A[this.SW(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && D[this.N(p, rs)] == this.DESTRUCTIBLE && D[this.NW(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C4(Fk, this._center55, this._s55, this._w55, this._n55, this._e55, this._sw55, this._nw55, this._ne55, this._ww55, this._nww55, this._nnw55, this._nn55) && A[this.W(p, rs)] < k && A[this.N(p, rs)] < k && A[this.NW(p, rs)] < k) {
                D[p] = this.CRUCIAL;
            }
            if (D[this.N(p, rs)] != this.DESTRUCTIBLE || D[this.E(p, rs)] != this.DESTRUCTIBLE || D[this.NE(p, rs)] != this.DESTRUCTIBLE || !this.MATCH_C4(Fk, this._center55, this._w55, this._n55, this._e55, this._s55, this._nw55, this._ne55, this._se55, this._nn55, this._nne55, this._nee55, this._ee55) || A[this.N(p, rs)] >= k || A[this.E(p, rs)] >= k || A[this.NE(p, rs)] >= k) continue;
            D[p] = this.CRUCIAL;
        }
    }

    private void match_C(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (D[p] != this.DESTRUCTIBLE) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._n55, this._e55, this._s55, this._ne55, this._se55) && A[this.E(p, rs)] < k) {
                int n = this.CRUCIAL_C;
                D[this.E((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._s55, this._w55, this._n55, this._sw55, this._nw55) && A[this.W(p, rs)] < k) {
                int n = this.CRUCIAL_C;
                D[this.W((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._e55, this._s55, this._w55, this._se55, this._sw55) && A[this.S(p, rs)] < k) {
                int n = this.CRUCIAL_C;
                D[this.S((int)p, (int)rs)] = n;
                D[p] = n;
            }
            if (!this.MATCH_C(Fk, this._center55, this._w55, this._n55, this._e55, this._nw55, this._ne55) || A[this.N(p, rs)] >= k) continue;
            int n = this.CRUCIAL_C;
            D[this.N((int)p, (int)rs)] = n;
            D[p] = n;
        }
    }

    private void match_C_asymmetric(int[] F, int[] D, int[] A, int rs, int N) {
        int[] Fk = new int[25];
        for (int p = 0; p < N; ++p) {
            if (D[p] != this.DESTRUCTIBLE) continue;
            int k = F[p];
            this.getNeighborhood(F, rs, N, p, k, Fk);
            if (D[this.E(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._n55, this._e55, this._s55, this._ne55, this._se55) && A[this.E(p, rs)] < k) {
                D[p] = this.CRUCIAL_C;
            }
            if (D[this.W(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._s55, this._w55, this._n55, this._sw55, this._nw55) && A[this.W(p, rs)] < k) {
                D[p] = this.CRUCIAL_C;
            }
            if (D[this.S(p, rs)] == this.DESTRUCTIBLE && this.MATCH_C(Fk, this._center55, this._e55, this._s55, this._w55, this._se55, this._sw55) && A[this.S(p, rs)] < k) {
                D[p] = this.CRUCIAL_C;
            }
            if (!this.MATCH_C(Fk, this._center55, this._w55, this._n55, this._e55, this._nw55, this._ne55) || A[this.N(p, rs)] >= k) continue;
            D[p] = this.CRUCIAL_C;
        }
    }
}

