/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.shapeIndexes;

import characterization.shapes.shapeIndexes.ShapeIndex;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import measures.Measures2D;
import measures.Measures3D;

public class TiTiSymmetry
implements ShapeIndex {
    private double Value = -1.0;

    @Override
    public double Compute(Measures2D measures) {
        BufferedImage image = measures.getImage();
        int height = image.getHeight();
        int width = image.getWidth();
        measures.MainAxes();
        double a = measures.MainAxis01.A();
        double b = measures.MainAxis01.B();
        int nb = 0;
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                if (Math.abs(measures.MainAxis01.vector.get(0)) < 0.001) {
                    double mx = measures.MainAxis01.point.getX();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            int X;
                            if (bb[pos] != 0 && 0 <= (X = (int)(2.0 * mx - (double)x + 0.5)) && X < width && bb[X + y * width] != 0) {
                                ++nb;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                } else if (Math.abs(measures.MainAxis01.vector.get(1)) < 0.001) {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            int Y;
                            if (bb[pos] != 0 && 0 <= (Y = (int)(2.0 * b - (double)y + 0.5)) && Y < height && bb[x + Y * width] != 0) {
                                ++nb;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                } else {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (bb[pos] != 0) {
                                double alpha = -1.0 / a;
                                double gamma = (double)y - (double)x * alpha;
                                double mx = (gamma - b) / (a - alpha);
                                double my = alpha * mx + gamma;
                                int X = (int)(2.0 * mx - (double)x + 0.5);
                                int Y = (int)(2.0 * my - (double)y + 0.5);
                                if (0 <= X && X < width && 0 <= Y && Y < height && bb[X + Y * width] != 0) {
                                    ++nb;
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                if (Math.abs(measures.MainAxis01.vector.get(0)) < 0.001) {
                    double mx = measures.MainAxis01.point.getX();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            int X;
                            if (sb[pos] != 0 && 0 <= (X = (int)(2.0 * mx - (double)x + 0.5)) && X < width && sb[X + y * width] != 0) {
                                ++nb;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                } else if (Math.abs(measures.MainAxis01.vector.get(1)) < 0.001) {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            int Y;
                            if (sb[pos] != 0 && 0 <= (Y = (int)(2.0 * b - (double)y + 0.5)) && Y < height && sb[x + Y * width] != 0) {
                                ++nb;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                } else {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (sb[pos] != 0) {
                                double alpha = -1.0 / a;
                                double gamma = (double)y - (double)x * alpha;
                                double mx = (gamma - b) / (a - alpha);
                                double my = alpha * mx + gamma;
                                int X = (int)(2.0 * mx - (double)x + 0.5);
                                int Y = (int)(2.0 * my - (double)y + 0.5);
                                if (0 <= X && X < width && 0 <= Y && Y < height && sb[X + Y * width] != 0) {
                                    ++nb;
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                Object bb = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Image type not supported (yet).");
            }
        }
        image = null;
        this.Value = (double)nb / (double)measures.getSurface();
        return this.Value;
    }

    @Override
    public double Compute(Measures3D measures) {
        throw new UnsupportedOperationException("Shape index not defined in 3D.");
    }

    @Override
    public double LastValue() {
        return this.Value;
    }
}

