/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.shapeIndexes;

import characterization.ComputableFeatures;
import characterization.shapes.shapeIndexes.BesicovitchSymmetry;
import characterization.shapes.shapeIndexes.CircularVariance;
import characterization.shapes.shapeIndexes.Circularity;
import characterization.shapes.shapeIndexes.ConvexityPerimeter;
import characterization.shapes.shapeIndexes.ConvexitySurface;
import characterization.shapes.shapeIndexes.Deficit;
import characterization.shapes.shapeIndexes.DiameterLengthning;
import characterization.shapes.shapeIndexes.GeodesicLengthning;
import characterization.shapes.shapeIndexes.InscribedDiskGap;
import characterization.shapes.shapeIndexes.Irregularity;
import characterization.shapes.shapeIndexes.IsoPerimeterDeficit;
import characterization.shapes.shapeIndexes.MainAxisLengthning;
import characterization.shapes.shapeIndexes.MortonSpreading;
import characterization.shapes.shapeIndexes.RadiusLengthning;
import characterization.shapes.shapeIndexes.ShapeIndex;
import characterization.shapes.shapeIndexes.TiTiCone;
import characterization.shapes.shapeIndexes.TiTiCone2;
import characterization.shapes.shapeIndexes.TiTiCurvature;
import characterization.shapes.shapeIndexes.TiTiCylinder;
import characterization.shapes.shapeIndexes.TiTiCylinder2;
import characterization.shapes.shapeIndexes.TiTiCylinderRadius;
import characterization.shapes.shapeIndexes.TiTiEllipseMainAxis;
import characterization.shapes.shapeIndexes.TiTiEllipseRadius;
import characterization.shapes.shapeIndexes.TiTiIsoPerimeterDeficit;
import characterization.shapes.shapeIndexes.TiTiNcce;
import characterization.shapes.shapeIndexes.TiTiParallelogramDiameter;
import characterization.shapes.shapeIndexes.TiTiParallelogramMainAxis;
import characterization.shapes.shapeIndexes.TiTiSymmetry;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import measures.Measures2D;
import measures.Measures3D;

public class ShapeIndexesComputer
implements ComputableFeatures {
    public ShapeIndex[] Indexes = null;
    private List<ShapeIndex> shortlist = null;

    public ShapeIndexesComputer() {
        this.Instanciations();
    }

    private void Instanciations() {
        this.Indexes = new ShapeIndex[27];
        this.Indexes[0] = new BesicovitchSymmetry();
        this.Indexes[1] = new CircularVariance();
        this.Indexes[2] = new Circularity();
        this.Indexes[3] = new ConvexityPerimeter();
        this.Indexes[4] = new ConvexitySurface();
        this.Indexes[5] = new Deficit();
        this.Indexes[6] = new DiameterLengthning();
        this.Indexes[7] = new GeodesicLengthning();
        this.Indexes[8] = new InscribedDiskGap();
        this.Indexes[9] = new Irregularity();
        this.Indexes[10] = new IsoPerimeterDeficit();
        this.Indexes[11] = new MainAxisLengthning();
        this.Indexes[12] = new MortonSpreading();
        this.Indexes[13] = new RadiusLengthning();
        this.Indexes[14] = new TiTiCone();
        this.Indexes[15] = new TiTiCone2();
        this.Indexes[16] = new TiTiCurvature();
        this.Indexes[17] = new TiTiCylinder();
        this.Indexes[18] = new TiTiCylinder2();
        this.Indexes[19] = new TiTiCylinderRadius();
        this.Indexes[20] = new TiTiEllipseMainAxis();
        this.Indexes[21] = new TiTiEllipseRadius();
        this.Indexes[22] = new TiTiIsoPerimeterDeficit();
        this.Indexes[23] = new TiTiNcce();
        this.Indexes[24] = new TiTiParallelogramMainAxis();
        this.Indexes[25] = new TiTiParallelogramDiameter();
        this.Indexes[26] = new TiTiSymmetry();
    }

    public void ComputeIndexes(Measures2D measures) {
        this.ComputeShortList();
        for (int i2 = 0; i2 < this.shortlist.size(); ++i2) {
            this.shortlist.get(i2).Compute(measures);
        }
    }

    public void ComputeIndexes(Measures3D measures) {
        this.ComputeShortList();
        for (int i2 = 0; i2 < this.shortlist.size(); ++i2) {
            this.shortlist.get(i2).Compute(measures);
        }
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.ComputeIndexes(new Measures2D(image));
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.ComputeIndexes(new Measures3D(dv));
    }

    public void DoNotCompute(String name) {
        for (int i2 = 0; i2 < this.Indexes.length; ++i2) {
            if (this.Indexes[i2] == null || !this.Indexes[i2].getClass().getSimpleName().equalsIgnoreCase(name)) continue;
            this.Exclude(i2);
            return;
        }
    }

    public void Exclude(String name) {
        this.DoNotCompute(name);
    }

    public void Exclude(int num) {
        if (this.shortlist != null) {
            throw new IllegalStateException("A computation already took place or a getter was already used.Consequently the lsit of shape indexes to compute is already sealed and cannot be modified.");
        }
        this.Indexes[num] = null;
    }

    public void Exclude_2DOnly_ShapeIndexes() {
        this.Indexes[6] = null;
        this.Indexes[21] = null;
        this.Indexes[24] = null;
        this.Indexes[25] = null;
    }

    public void Exclude_3DOnly_ShapeIndexes() {
        this.Indexes[14] = null;
        this.Indexes[15] = null;
        this.Indexes[17] = null;
        this.Indexes[18] = null;
        this.Indexes[19] = null;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("1 parameter required.");
        }
        this.Instanciations();
        Iterator iter = ((List)parameters[0]).iterator();
        while (iter.hasNext()) {
            this.DoNotCompute((String)iter.next());
        }
    }

    public void Display() {
        this.ComputeShortList();
        System.out.println("Shape indexes values:");
        for (int i2 = 0; i2 < this.shortlist.size(); ++i2) {
            System.out.println(this.shortlist.get(i2).getClass().getSimpleName() + ": " + this.shortlist.get(i2).LastValue());
        }
    }

    public ShapeIndex[] getIndexes() {
        this.ComputeShortList();
        return this.shortlist.toArray(this.Indexes);
    }

    @Override
    public double[] Features() {
        this.ComputeShortList();
        double[] Values2 = new double[this.shortlist.size()];
        for (int i2 = 0; i2 < this.shortlist.size(); ++i2) {
            Values2[i2] = this.shortlist.get(i2).LastValue();
        }
        return Values2;
    }

    public double Feature(String name) {
        for (ShapeIndex Indexe : this.Indexes) {
            if (Indexe == null || !Indexe.getClass().getSimpleName().equalsIgnoreCase(name)) continue;
            return Indexe.LastValue();
        }
        throw new IllegalArgumentException("Shape index name not found.");
    }

    @Override
    public double Feature(int i2) {
        return this.Indexes[i2].LastValue();
    }

    public int nbIndexesComputed() {
        this.ComputeShortList();
        return this.shortlist.size();
    }

    @Override
    public String[] FeaturesNames() {
        this.ComputeShortList();
        String[] names = new String[this.shortlist.size()];
        for (int i2 = 0; i2 < this.shortlist.size(); ++i2) {
            names[i2] = this.shortlist.get(i2).getClass().getSimpleName();
        }
        return names;
    }

    private void ComputeShortList() {
        if (this.shortlist != null) {
            return;
        }
        this.shortlist = new ArrayList<ShapeIndex>(13);
        for (ShapeIndex Indexe : this.Indexes) {
            if (Indexe == null) continue;
            this.shortlist.add(Indexe);
        }
    }

    @Override
    public void Kill() {
        Arrays.fill(this.Indexes, null);
        this.Indexes = null;
        this.shortlist.clear();
    }
}

