/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.shapeIndexes;

import characterization.shapes.shapeIndexes.ShapeIndex;
import java.util.Iterator;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import measures.Measures3D;

public class Irregularity
implements ShapeIndex {
    private double Value = -1.0;

    @Override
    public double Compute(Measures2D measures) {
        measures.Basics(true, false);
        double max = 0.0;
        double bx = measures.Barycentre.X;
        double by = measures.Barycentre.Y;
        Iterator<Coordinates> iter = measures.Contour.Iterator();
        while (iter.hasNext()) {
            Coordinates p = iter.next();
            double dist = ((double)p.X - bx) * ((double)p.X - bx) + ((double)p.Y - by) * ((double)p.Y - by);
            if (!(dist > max)) continue;
            max = dist;
        }
        iter = null;
        this.Value = ((double)measures.getSurface() + Math.sqrt(Math.PI) * Math.sqrt(max)) / Math.sqrt(measures.getSurface());
        return this.Value;
    }

    @Override
    public double Compute(Measures3D measures) {
        measures.Basics(26);
        double max = 0.0;
        double bx = measures.Barycentre.X;
        double by = measures.Barycentre.Y;
        double bz = measures.Barycentre.Z;
        Iterator<Coordinates> iter = measures.surface.Iterator();
        while (iter.hasNext()) {
            Coordinates p = iter.next();
            double dist = ((double)p.X - bx) * ((double)p.X - bx) + ((double)p.Y - by) * ((double)p.Y - by) + ((double)p.Z - bz) * ((double)p.Z - bz);
            if (!(dist > max)) continue;
            max = dist;
        }
        iter = null;
        this.Value = ((double)measures.getVolume() + Math.sqrt(Math.PI) * Math.sqrt(max)) / Math.sqrt(measures.getVolume());
        return this.Value;
    }

    @Override
    public double LastValue() {
        return this.Value;
    }
}

