/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.shapeIndexes;

import characterization.shapes.shapeIndexes.ShapeIndex;
import java.util.Iterator;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import measures.Measures3D;

public class CircularVariance
implements ShapeIndex {
    private double Value = -1.0;
    private final Metric dist = new Euclidian();

    @Override
    public double Compute(Measures2D measures) {
        measures.EuclidianRadii();
        this.Value = 0.0;
        Iterator<Coordinates> iter = measures.Contour.Iterator();
        Coordinate barycentre = measures.Barycentre;
        double radius = measures.getAverageRadius();
        while (iter.hasNext()) {
            double d = this.dist.Distance(iter.next(), barycentre);
            this.Value += (d - radius) * (d - radius);
        }
        this.Value /= (double)measures.getPerimetre() * radius * radius;
        this.Value = 1.0 - this.Value;
        iter = null;
        barycentre = null;
        return this.Value;
    }

    @Override
    public double Compute(Measures3D measures) {
        measures.EuclidianRadius();
        this.Value = 0.0;
        Iterator<Coordinates> iter = measures.surface.Iterator();
        Coordinate barycentre = measures.Barycentre;
        double radius = measures.getAverageRadius();
        while (iter.hasNext()) {
            double d = this.dist.Distance(iter.next(), barycentre);
            this.Value += (d - radius) * (d - radius);
        }
        this.Value /= (double)measures.getSurface() * radius * radius;
        this.Value = 1.0 - this.Value;
        iter = null;
        barycentre = null;
        return this.Value;
    }

    @Override
    public double LastValue() {
        return this.Value;
    }
}

