/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.shapeIndexes;

import characterization.shapes.shapeIndexes.ShapeIndex;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import mathematics.primitives.pointsTiTi.Point3DF;
import measures.Measures2D;
import measures.Measures3D;

public class BesicovitchSymmetry
implements ShapeIndex {
    private double Value = -1.0;

    @Override
    public double Compute(Measures2D measures) {
        measures.Basics(true, false);
        BufferedImage image = measures.getImage();
        int width = image.getWidth();
        int height = image.getHeight();
        Point3DF B = new Point3DF();
        double Surface = measures.getSurface();
        double Bx = measures.Barycentre.X;
        double By = measures.Barycentre.Y;
        this.Value = -1.0;
        for (double i2 = -5.0; i2 <= 5.0; i2 += 0.5) {
            for (double j = -5.0; j <= 5.0; j += 0.5) {
                B.setXY(Bx + i2, By + j);
                int Intersection2 = 0;
                switch (image.getType()) {
                    case 10: {
                        int Y;
                        int X;
                        int x;
                        int y;
                        byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                if (bb[pos] != 0) {
                                    X = (int)(2.0 * B.getX() - (double)x + 0.5);
                                    Y = (int)(2.0 * B.getY() - (double)y + 0.5);
                                    if (0 <= X && X < width && 0 <= Y && Y < height && bb[X + Y * width] != 0) {
                                        ++Intersection2;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        bb = null;
                        break;
                    }
                    case 11: {
                        int Y;
                        int X;
                        int x;
                        int y;
                        short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                if (sb[pos] != 0) {
                                    X = (int)(2.0 * B.getX() - (double)x + 0.5);
                                    Y = (int)(2.0 * B.getY() - (double)y + 0.5);
                                    if (0 <= X && X < width && 0 <= Y && Y < height && sb[X + Y * width] != 0) {
                                        ++Intersection2;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        sb = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                double Coef = (double)Intersection2 / Surface;
                if (!(this.Value < Coef)) continue;
                this.Value = Coef;
            }
        }
        image = null;
        B = null;
        return this.Value;
    }

    @Override
    public double Compute(Measures3D measures) {
        measures.Basics(26);
        DV dv = measures.getDV();
        Point3DF B = new Point3DF();
        double Surface = measures.getSurface();
        double Bx = measures.Barycentre.X;
        double By = measures.Barycentre.Y;
        double Bz = measures.Barycentre.Z;
        this.Value = -1.0;
        for (double i2 = -5.0; i2 <= 5.0; i2 += 0.5) {
            for (double j = -5.0; j <= 5.0; j += 0.5) {
                for (double k = -5.0; k <= 5.0; k += 0.5) {
                    B.setXYZ(Bx + i2, By + j, Bz + k);
                    int Intersection2 = 0;
                    switch (dv.Type) {
                        case 8: {
                            int Z;
                            int Y;
                            int X;
                            int x;
                            int y;
                            int z;
                            byte[] bb = dv.getDataBufferByte(0);
                            int pos = 0;
                            for (z = 0; z < dv.SizeZ; ++z) {
                                for (y = 0; y < dv.SizeY; ++y) {
                                    x = 0;
                                    while (x < dv.SizeX) {
                                        if (bb[pos] != 0) {
                                            X = (int)(2.0 * B.getX() - (double)x + 0.5);
                                            Y = (int)(2.0 * B.getY() - (double)y + 0.5);
                                            Z = (int)(2.0 * B.getZ() - (double)z + 0.5);
                                            if (0 <= X && X < dv.SizeX && 0 <= Y && Y < dv.SizeY && 0 <= Z && Z < dv.SizeZ && bb[dv.Position(X, Y, Z)] != 0) {
                                                ++Intersection2;
                                            }
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                }
                            }
                            bb = null;
                            break;
                        }
                        case 16: {
                            int Z;
                            int Y;
                            int X;
                            int x;
                            int y;
                            int z;
                            short[] sb = dv.getDataBufferShort(0);
                            int pos = 0;
                            for (z = 0; z < dv.SizeZ; ++z) {
                                for (y = 0; y < dv.SizeY; ++y) {
                                    x = 0;
                                    while (x < dv.SizeX) {
                                        if (sb[pos] != 0) {
                                            X = (int)(2.0 * B.getX() - (double)x + 0.5);
                                            Y = (int)(2.0 * B.getY() - (double)y + 0.5);
                                            Z = (int)(2.0 * B.getZ() - (double)z + 0.5);
                                            if (0 <= X && X < dv.SizeX && 0 <= Y && Y < dv.SizeY && 0 <= Z && Z < dv.SizeZ && sb[dv.Position(X, Y, Z)] != 0) {
                                                ++Intersection2;
                                            }
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                }
                            }
                            sb = null;
                            break;
                        }
                        case 32: {
                            int Z;
                            int Y;
                            int X;
                            int x;
                            int y;
                            int z;
                            int[] ib = dv.getDataBufferInt(0);
                            int pos = 0;
                            for (z = 0; z < dv.SizeZ; ++z) {
                                for (y = 0; y < dv.SizeY; ++y) {
                                    x = 0;
                                    while (x < dv.SizeX) {
                                        if (ib[pos] != 0) {
                                            X = (int)(2.0 * B.getX() - (double)x + 0.5);
                                            Y = (int)(2.0 * B.getY() - (double)y + 0.5);
                                            Z = (int)(2.0 * B.getZ() - (double)z + 0.5);
                                            if (0 <= X && X < dv.SizeX && 0 <= Y && Y < dv.SizeY && 0 <= Z && Z < dv.SizeZ && ib[dv.Position(X, Y, Z)] != 0) {
                                                ++Intersection2;
                                            }
                                        }
                                        ++x;
                                        ++pos;
                                    }
                                }
                            }
                            ib = null;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("DV type not supported (yet).");
                        }
                    }
                    double Coef = (double)Intersection2 / Surface;
                    if (!(this.Value < Coef)) continue;
                    this.Value = Coef;
                }
            }
        }
        dv = null;
        B = null;
        return this.Value;
    }

    @Override
    public double LastValue() {
        return this.Value;
    }
}

