/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.polarSignature;

import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;

public class PolarSignature {
    private int nbCercles = 0;
    private int[][] Signature;
    private Coordinate Centre;
    private String Nom = null;

    public PolarSignature() {
    }

    public PolarSignature(int nbCercles) {
        this.SetDimension(nbCercles);
    }

    private void SetDimension(int nbCercles) {
        if (nbCercles <= 0) {
            throw new Error("Nombre de cercles negatif ou nul dans SignaturePolaire2D : " + nbCercles);
        }
        this.nbCercles = nbCercles;
        this.Signature = null;
        this.Signature = new int[nbCercles][360];
    }

    public void Compute(BufferedImage image, int nbCercles) {
        int j;
        int i2;
        if (!ImageTools.isGrayLevel((BufferedImage)image) && image.getType() != 12) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int largeur = image.getWidth();
        int hauteur = image.getHeight();
        Euclidian distances = new Euclidian();
        WritableRaster wr = image.getRaster();
        this.SetDimension(nbCercles);
        double Rmax = 0.0;
        double y = 0.0;
        double x = 0.0;
        int nb = 0;
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                if (wr.getSample(j, i2, 0) <= 0) continue;
                x += (double)j;
                y += (double)i2;
                ++nb;
            }
        }
        Coordinate barycentre = new Coordinate(x / (double)nb, y / (double)nb);
        for (i2 = 0; i2 < hauteur; ++i2) {
            for (j = 0; j < largeur; ++j) {
                double dist;
                if (wr.getSample(j, i2, 0) <= 0 || !((dist = distances.Distance(barycentre.X, barycentre.Y, 0.0, (double)j, (double)i2, 0.0)) > Rmax)) continue;
                Rmax = dist;
            }
        }
        this.Compute(image, nbCercles, barycentre, Rmax);
        wr = null;
    }

    public void Compute(BufferedImage image, int nbCercles, Coordinate Barycentre, double RayonMax) {
        int hauteur = image.getHeight();
        int largeur = image.getWidth();
        double rayon = RayonMax / (double)nbCercles;
        WritableRaster wr = image.getRaster();
        this.SetDimension(nbCercles);
        this.Centre = Barycentre;
        for (int i2 = 0; i2 < nbCercles; ++i2) {
            for (int j = 0; j < 360; ++j) {
                int x = (int)(Barycentre.X + ((double)i2 + 0.5) * rayon * Math.cos((double)j * Math.PI / 180.0) + 0.5);
                int y = (int)(Barycentre.Y + ((double)i2 + 0.5) * rayon * Math.sin((double)j * Math.PI / 180.0) + 0.5);
                this.Signature[i2][j] = x >= 0 && y >= 0 && x < largeur && y < hauteur ? wr.getSample(x, y, 0) : 0;
            }
        }
        wr = null;
    }

    public int getNbCercles() {
        return this.nbCercles;
    }

    public int[][] getSignature() {
        return this.Signature;
    }

    public Coordinate getCentre() {
        return this.Centre;
    }

    public String toString() {
        return this.Nom;
    }
}

