/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import measures.BasicMeasures;

public class Zernike {
    protected int Surface = -1;
    protected int Order = -1;
    protected List<Polar> Liste = new Vector<Polar>(100);
    protected Coordinate centroid;
    protected double Epsilon = 0.001;
    protected Complex[][] ZernikeMoments = null;

    public void Compute(BufferedImage image, int Order2) {
        if (image.getType() != 12) {
            throw new IllegalArgumentException("Only binary image supported (shape index).");
        }
        if (Order2 < 1) {
            throw new Error("Order < 1.");
        }
        this.Order = Order2;
        this.PreComputation(image);
        this.Compute();
    }

    protected void Compute() {
        Iterator<Polar> iter;
        int q;
        int p;
        double max = -1.0;
        Polar polar2 = null;
        Point3DF point = new Point3DF();
        Euclidian distance = new Euclidian();
        for (Polar polar2 : this.Liste) {
            point.setXY(polar2.X, polar2.Y);
            polar2.R = distance.Distance((Point)point, this.centroid);
            if (max < polar2.R) {
                max = polar2.R;
            }
            if (polar2.R > this.Epsilon) {
                polar2.Theta = Math.asin((this.centroid.Y - (double)polar2.Y) / polar2.R);
                if ((double)polar2.X < this.centroid.X) {
                    polar2.Theta = Math.PI - polar2.Theta;
                    continue;
                }
                if (!((double)polar2.Y > this.centroid.Y)) continue;
                polar2.Theta = Math.PI * 2 + polar2.Theta;
                continue;
            }
            polar2.Theta = 0.0;
        }
        for (int i2 = 0; i2 < this.Liste.size(); ++i2) {
            this.Liste.get((int)i2).R /= max;
        }
        this.ZernikeMoments = null;
        this.ZernikeMoments = new Complex[this.Order + 1][this.Order + 1];
        for (p = 0; p <= this.Order; ++p) {
            for (q = p % 2; q <= p; q += 2) {
                this.ZernikeMoments[p][q] = new Complex();
                this.ZernikeMoments[p][q].Re = 0.0;
                this.ZernikeMoments[p][q].Im = 0.0;
                iter = null;
                for (Polar polar2 : this.Liste) {
                    double R = this.RadialPolynomial(p, q, polar2.R);
                    this.ZernikeMoments[p][q].Re += R * Math.cos((double)q * polar2.Theta);
                    this.ZernikeMoments[p][q].Im += R * Math.sin((double)q * polar2.Theta);
                }
                this.ZernikeMoments[p][q].Re *= ((double)p + 1.0) / Math.PI;
                this.ZernikeMoments[p][q].Im *= -((double)p + 1.0) / Math.PI;
                this.ZernikeMoments[p][q].R = Math.sqrt(Math.pow(this.ZernikeMoments[p][q].Re, 2.0) + Math.pow(this.ZernikeMoments[p][q].Im, 2.0));
            }
        }
        for (p = 0; p <= this.Order; ++p) {
            for (q = p % 2; q <= p; q += 2) {
                this.ZernikeMoments[p][q].R /= (double)this.Surface;
            }
        }
        polar2 = null;
        point = null;
        distance = null;
        iter = null;
    }

    protected double RadialPolynomial(int p, int q, double r) {
        double R = 0.0;
        for (int k = q; k <= p; k += 2) {
            double a = this.Factorial((p + k) / 2);
            double b = this.Factorial((p - k) / 2);
            double c = this.Factorial((k - q) / 2);
            double d = this.Factorial((k + q) / 2);
            R += Math.pow(-1.0, (int)((double)(p - k) / 2.0)) * Math.pow(r, k) * a / (b * c * d);
        }
        return R;
    }

    protected int Factorial(int x) {
        if (x < 0) {
            throw new Error("Nombre negatif (ah bravo)!");
        }
        if (x == 0) {
            return 1;
        }
        return x * this.Factorial(x - 1);
    }

    protected void PreComputation(BufferedImage image) {
        BasicMeasures bbcps = new BasicMeasures();
        bbcps.Compute(image, true);
        this.Surface = bbcps.getSurface();
        this.centroid = null;
        this.centroid = bbcps.Centroid;
        WritableRaster wr = image.getRaster();
        this.Liste.clear();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                this.Liste.add(new Polar(x, y));
            }
        }
        wr = null;
    }

    public Complex[][] getZernikeMoments() {
        return this.ZernikeMoments;
    }

    public double getZernikeMoments(int m, int n) {
        return this.ZernikeMoments[m][n].R;
    }

    public double[] getZernikeMoment() {
        int x;
        int y;
        int nb = 0;
        double[] res = null;
        for (y = 0; y <= this.Order; ++y) {
            for (x = 0; x <= this.Order; ++x) {
                if (this.ZernikeMoments[y][x] == null) continue;
                ++nb;
            }
        }
        res = new double[nb];
        nb = 0;
        for (y = 0; y <= this.Order; ++y) {
            for (x = 0; x <= this.Order; ++x) {
                if (this.ZernikeMoments[y][x] == null) continue;
                res[nb++] = this.ZernikeMoments[y][x].R;
            }
        }
        return res;
    }

    public String LastNames() {
        return this.LastNames(" ");
    }

    public String LastNames(String Separator2) {
        StringBuilder sb = new StringBuilder(this.ZernikeMoments.length * this.ZernikeMoments[0].length);
        for (int m = 0; m <= this.Order; ++m) {
            for (int n = 0; n <= this.Order; ++n) {
                if (this.ZernikeMoments[m][n] == null) continue;
                sb.append(m).append("-").append(n).append(Separator2);
            }
        }
        return sb.toString();
    }

    public void DisplayLastNames() {
        this.DisplayLastNames(" ");
    }

    public void DisplayLastNames(String Separator2) {
        System.out.println(this.LastNames(Separator2));
    }

    public void DisplayLast() {
        System.out.println(this.toString());
    }

    public void DisplayLast(String Separator2) {
        System.out.println(this.toString(Separator2));
    }

    public void appendTo(Appendable out) {
        this.appendTo(out, " ");
    }

    public void appendTo(Appendable out, String Separator2) {
        try {
            for (int m = 0; m <= this.Order; ++m) {
                for (int n = 0; n <= this.Order; ++n) {
                    if (this.ZernikeMoments[m][n] == null) continue;
                    out.append(String.valueOf(this.ZernikeMoments[m][n].R)).append(Separator2);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(this.ZernikeMoments.length * this.ZernikeMoments[0].length);
        this.appendTo(sb);
        return sb.toString();
    }

    protected class Complex {
        public double Im = 0.0;
        public double Re = 0.0;
        public double R = 0.0;

        protected Complex() {
        }
    }

    protected class Polar {
        public int X;
        public int Y;
        public double R;
        public double Theta;

        public Polar() {
        }

        public Polar(int X, int Y) {
            this.X = X;
            this.Y = Y;
        }
    }
}

