/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import characterization.shapes.moments.LegendrePolynomial;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class Legendre {
    protected int Order = -1;
    protected LegendrePolynomial[] Pm = null;
    protected LegendrePolynomial[] Pn = null;
    protected double[][] LegendreMoments = null;

    public void Compute(BufferedImage image, int Order2) {
        int n;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only binary or gray level image supported.");
        }
        if (Order2 < 1) {
            throw new IllegalArgumentException("Order < 1.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster wr = image.getRaster();
        if (Order2 != this.Order) {
            this.Order = Order2;
            this.Pm = null;
            this.Pn = null;
            this.Pm = new LegendrePolynomial[Order2 + 1];
            this.Pn = new LegendrePolynomial[Order2 + 1];
            for (n = 0; n <= Order2; ++n) {
                this.Pm[n] = new LegendrePolynomial(n);
                this.Pn[n] = new LegendrePolynomial(n);
            }
            this.LegendreMoments = null;
            this.LegendreMoments = new double[Order2 + 1][Order2 + 1];
        }
        int Surface = 0;
        for (int m = 0; m <= Order2; ++m) {
            for (n = 0; n <= Order2; ++n) {
                if (m + n > Order2) continue;
                double Value = 0.0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) <= 0) continue;
                        Value += (double)(this.Pm[m].Compute(x) * this.Pn[n].Compute(y));
                        ++Surface;
                    }
                }
                this.LegendreMoments[m][n] = (2.0 * (double)m + 1.0) * (2.0 * (double)n + 1.0) / (double)Surface * Value;
            }
        }
        wr = null;
    }

    public double[][] getLegendreMoments() {
        return this.LegendreMoments;
    }

    public double getLegendreMoments(int m, int n) {
        return this.LegendreMoments[m][n];
    }

    public String LastNames() {
        return this.LastNames(" ");
    }

    public String LastNames(String Separator2) {
        StringBuilder sb = new StringBuilder(this.LegendreMoments.length * this.LegendreMoments[0].length);
        for (int m = 0; m <= this.Order; ++m) {
            for (int n = 0; n <= this.Order; ++n) {
                if (m + n > this.Order) continue;
                sb.append(m).append("-").append(n).append(Separator2);
            }
        }
        return sb.toString();
    }

    public void DisplayLastNames() {
        this.DisplayLastNames(" ");
    }

    public void DisplayLastNames(String Separator2) {
        System.out.println(this.LastNames(Separator2));
    }

    public void DisplayLast() {
        System.out.println(this.toString());
    }

    public void DisplayLast(String Separator2) {
        System.out.println(this.toString(Separator2));
    }

    public void appendTo(Appendable out) {
        this.appendTo(out, " ");
    }

    public void appendTo(Appendable out, String Separator2) {
        try {
            for (int m = 0; m <= this.Order; ++m) {
                for (int n = 0; n <= this.Order; ++n) {
                    if (m + n > this.Order) continue;
                    out.append(String.valueOf(this.LegendreMoments[m][n])).append(Separator2);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(this.LegendreMoments.length * this.LegendreMoments[0].length);
        this.appendTo(sb);
        return sb.toString();
    }
}

