/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import mathematics.functions.Polynomial;

public class LaguerrePolynomialGeneralized
extends Polynomial {
    private double Alpha = -1.0;

    public LaguerrePolynomialGeneralized(int Degres) {
        super(Degres, (double[])null);
        if (Degres < 0) {
            throw new IllegalArgumentException("Bad value for Degres. Attemps [0...].");
        }
    }

    public LaguerrePolynomialGeneralized(int Degres, double Alpha) {
        super(Degres, (double[])null);
        if (Degres < 0) {
            throw new IllegalArgumentException("Bad value for Degres. Attemps [0...[.");
        }
        if (Alpha < -1.0) {
            throw new IllegalArgumentException("Bad value for Alpha. Attemps ]-1.0...[.");
        }
        this.Alpha = Alpha;
    }

    public double Value(double X) {
        double L1 = 0.0;
        double LaguerreL = 1.0;
        for (int i2 = 1; i2 <= this.Degree; ++i2) {
            double L0 = L1;
            L1 = LaguerreL;
            LaguerreL = ((2.0 * (double)i2 - 1.0 + this.Alpha - X) * L1 - ((double)i2 - 1.0 + this.Alpha) * L0) / (double)i2;
        }
        return LaguerreL;
    }
}

