/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import mathematics.functions.Polynomial;

public class LaguerrePolynomial
extends Polynomial {
    public LaguerrePolynomial(int Degres) {
        super(Degres, (double[])null);
        if (Degres > 6 || Degres < 0) {
            throw new IllegalArgumentException("Bad value for Degres. Attemps [0..6].");
        }
        this.FillCoefficients();
    }

    public void FillCoefficients() {
        this.CoefficientsDouble[0] = 1.0;
        if (this.Degree > 0) {
            this.CoefficientsDouble[1] = -this.Degree;
        }
        if (this.Degree > 1) {
            this.CoefficientsDouble[2] = (double)this.Degree * ((double)this.Degree - 1.0) / 4.0;
        }
        switch (this.Degree) {
            case 3: {
                this.CoefficientsDouble[3] = -0.16666666666666666;
                break;
            }
            case 4: {
                this.CoefficientsDouble[3] = -0.6666666666666666;
                this.CoefficientsDouble[4] = 0.041666666666666664;
                break;
            }
            case 5: {
                this.CoefficientsDouble[3] = -1.6666666666666667;
                this.CoefficientsDouble[4] = 0.20833333333333334;
                this.CoefficientsDouble[5] = -0.008333333333333333;
                break;
            }
            case 6: {
                this.CoefficientsDouble[3] = -3.3333333333333335;
                this.CoefficientsDouble[4] = 0.625;
                this.CoefficientsDouble[5] = -0.05;
                this.CoefficientsDouble[6] = 0.001388888888888889;
            }
        }
    }
}

