/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import characterization.shapes.moments.LaguerrePolynomialGeneralized;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class LaguerreGeneralized {
    protected int Order = -1;
    protected LaguerrePolynomialGeneralized[] L = null;
    protected double[] LaguerreMoments = null;

    public void ComputeAll(BufferedImage image, int Order2, double Alpha) {
        int n;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only binary or gray level image supported.");
        }
        if (Order2 < 1) {
            throw new Error("Order < 1.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster wr = image.getRaster();
        if (this.L != null) {
            for (n = 0; n < this.L.length; ++n) {
                this.L[n] = null;
            }
        }
        this.L = null;
        this.L = new LaguerrePolynomialGeneralized[Order2 + 1];
        for (n = 0; n <= Order2; ++n) {
            this.L[n] = new LaguerrePolynomialGeneralized(n, Alpha);
        }
        this.LaguerreMoments = null;
        this.LaguerreMoments = new double[Order2 + 1];
        for (n = 0; n <= Order2; ++n) {
            this.LaguerreMoments[n] = 0.0;
        }
        int Surface = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                for (n = 0; n <= Order2; ++n) {
                    int n2 = n;
                    this.LaguerreMoments[n2] = this.LaguerreMoments[n2] + this.L[n].Value(x) * this.L[n].Value(y);
                }
                ++Surface;
            }
        }
        n = 0;
        while (n <= Order2) {
            int n3 = n++;
            this.LaguerreMoments[n3] = this.LaguerreMoments[n3] / (double)Surface;
        }
        wr = null;
    }

    public void Compute(BufferedImage image, int Order2, double Alpha) {
        int n;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only binary or gray level image supported.");
        }
        if (Order2 < 1) {
            throw new Error("Order < 1.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster wr = image.getRaster();
        if (this.L != null) {
            for (n = 0; n < this.L.length; ++n) {
                this.L[n] = null;
            }
        }
        this.L = null;
        this.L = new LaguerrePolynomialGeneralized[1];
        this.L[0] = new LaguerrePolynomialGeneralized(Order2, Alpha);
        this.LaguerreMoments = null;
        this.LaguerreMoments = new double[1];
        this.LaguerreMoments[0] = 0.0;
        int Surface = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                this.LaguerreMoments[0] = this.LaguerreMoments[0] + this.L[0].Value(x) * this.L[0].Value(y);
                ++Surface;
            }
        }
        n = 0;
        while (n <= Order2) {
            int n2 = n++;
            this.LaguerreMoments[n2] = this.LaguerreMoments[n2] / (double)Surface;
        }
        wr = null;
    }

    public double[] getLaguerreMoments() {
        return this.LaguerreMoments;
    }

    public double getLaguerreMoments(int m) {
        return this.LaguerreMoments[m];
    }

    public void DisplayLast() {
        System.out.println(this.toString());
    }

    public void DisplayLast(String Separator2) {
        System.out.println(this.toString(Separator2));
    }

    public void appendTo(Appendable out) {
        this.appendTo(out, " ");
    }

    public void appendTo(Appendable out, String Separator2) {
        try {
            for (int m = 0; m <= this.Order; ++m) {
                out.append(String.valueOf(this.LaguerreMoments[m])).append(Separator2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(3);
        this.appendTo(sb);
        return sb.toString();
    }
}

