/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import characterization.shapes.moments.LaguerrePolynomial;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class Laguerre {
    protected int Order = 6;
    protected LaguerrePolynomial[] L = null;
    protected double[] LaguerreMoments = null;

    public void Compute(BufferedImage image) {
        int n;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only binary or gray level image supported.");
        }
        if (this.Order < 1) {
            throw new Error("Order < 1.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster wr = image.getRaster();
        if (this.L == null) {
            this.L = new LaguerrePolynomial[this.Order + 1];
            for (n = 0; n <= this.Order; ++n) {
                this.L[n] = new LaguerrePolynomial(n);
            }
            this.LaguerreMoments = new double[this.Order + 1];
        }
        for (n = 0; n <= this.Order; ++n) {
            this.LaguerreMoments[n] = 0.0;
        }
        int Surface = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                this.LaguerreMoments[0] = this.LaguerreMoments[0] + (double)(this.L[0].Compute(x) * this.L[0].Compute(y));
                this.LaguerreMoments[1] = this.LaguerreMoments[1] + (double)(this.L[1].Compute(x) * this.L[1].Compute(y));
                this.LaguerreMoments[2] = this.LaguerreMoments[2] + (double)(this.L[2].Compute(x) * this.L[2].Compute(y));
                this.LaguerreMoments[3] = this.LaguerreMoments[3] + (double)(this.L[3].Compute(x) * this.L[3].Compute(y));
                this.LaguerreMoments[4] = this.LaguerreMoments[4] + (double)(this.L[4].Compute(x) * this.L[4].Compute(y));
                this.LaguerreMoments[5] = this.LaguerreMoments[5] + (double)(this.L[5].Compute(x) * this.L[5].Compute(y));
                this.LaguerreMoments[6] = this.LaguerreMoments[6] + (double)(this.L[6].Compute(x) * this.L[6].Compute(y));
                ++Surface;
            }
        }
        n = 0;
        while (n <= this.Order) {
            int n2 = n++;
            this.LaguerreMoments[n2] = this.LaguerreMoments[n2] / (double)Surface;
        }
        wr = null;
    }

    public double[] getLaguerreMoments() {
        return this.LaguerreMoments;
    }

    public double getLaguerreMoments(int m) {
        return this.LaguerreMoments[m];
    }

    public void DisplayLast() {
        System.out.println(this.toString());
    }

    public void DisplayLast(String Separator2) {
        System.out.println(this.toString(Separator2));
    }

    public void appendTo(Appendable out) {
        this.appendTo(out, " ");
    }

    public void appendTo(Appendable out, String Separator2) {
        try {
            for (int m = 0; m <= this.Order; ++m) {
                out.append(String.valueOf(this.LaguerreMoments[m])).append(Separator2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(3);
        this.appendTo(sb);
        return sb.toString();
    }
}

