/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import mathematics.primitives.pointsTiTi.Coordinate;
import measures.BasicMeasures;

public class Hu {
    protected int Order = 3;
    protected double[][] Mu = new double[this.Order + 1][this.Order + 1];
    protected double[][] Nu = new double[this.Order + 1][this.Order + 1];
    protected double[] I = new double[8];

    public void Compute(BufferedImage image) {
        BasicMeasures bbcps = new BasicMeasures();
        bbcps.Compute(image, true);
        this.Compute(image, bbcps.Centroid);
        bbcps = null;
    }

    public void Compute(BufferedImage image, Coordinate Barycentre) {
        int q;
        int p;
        if (image.getType() != 12) {
            throw new IllegalArgumentException("Only binary image supported (shape index).");
        }
        double Bx = Barycentre.X;
        double By = Barycentre.Y;
        WritableRaster wr = image.getRaster();
        for (p = 0; p <= this.Order; ++p) {
            for (q = 0; q <= this.Order; ++q) {
                this.Nu[p][q] = 0.0;
                this.Mu[p][q] = 0.0;
            }
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                for (p = 0; p <= this.Order; ++p) {
                    for (q = 0; q <= this.Order; ++q) {
                        double[] dArray = this.Mu[p];
                        int n = q;
                        dArray[n] = dArray[n] + Math.pow((double)x - Bx, p) * Math.pow((double)y - By, q);
                    }
                }
            }
        }
        for (p = 0; p <= this.Order; ++p) {
            for (q = 0; q <= this.Order; ++q) {
                if (p + q < 2) continue;
                this.Nu[p][q] = this.Mu[p][q] / Math.pow(this.Mu[0][0], (int)((double)((p + q) / 2) + 1.0));
            }
        }
        this.I[0] = 0.0;
        this.I[1] = this.Nu[0][2] + this.Nu[2][0];
        this.I[2] = Math.pow(this.Nu[0][2] - this.Nu[2][0], 2.0) + 4.0 * this.Nu[1][1] * this.Nu[1][1];
        this.I[3] = Math.pow(this.Nu[3][0] - 3.0 * this.Nu[1][2], 2.0) + Math.pow(3.0 * this.Nu[2][1] - this.Nu[0][3], 2.0);
        this.I[4] = Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) + Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0);
        this.I[5] = (this.Nu[3][0] - 3.0 * this.Nu[1][2]) * (this.Nu[3][0] + this.Nu[1][2]) * (Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) - 3.0 * Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0)) + (3.0 * this.Nu[2][1] - this.Nu[0][3]) * (this.Nu[2][1] + this.Nu[0][3]) * (3.0 * Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) - Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0));
        this.I[6] = (this.Nu[2][0] - this.Nu[0][2]) * (Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) - Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0) + 4.0 * this.Nu[1][1] * (this.Nu[3][0] + this.Nu[1][2]) * (this.Nu[2][1] + this.Nu[0][3]));
        this.I[7] = (3.0 * this.Nu[2][1] - this.Nu[0][3]) * (this.Nu[3][0] + this.Nu[1][2]) * (Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) - 3.0 * Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0)) + (this.Nu[3][0] - 3.0 * this.Nu[1][2]) * (this.Nu[2][1] + this.Nu[0][3]) * (3.0 * Math.pow(this.Nu[3][0] + this.Nu[1][2], 2.0) - Math.pow(this.Nu[2][1] + this.Nu[0][3], 2.0));
    }

    public double getIx(int x) {
        return this.I[x];
    }

    public double[] getI() {
        return this.I;
    }

    public int getOrder() {
        return this.Order;
    }

    public void DisplayLast() {
        System.out.println(this.toString());
    }

    public void DisplayLast(String Separator2) {
        System.out.println(this.toString(Separator2));
    }

    public void appendTo(Appendable out) {
        this.appendTo(out, " ");
    }

    public void appendTo(Appendable out, String Separator2) {
        try {
            for (int i2 = 1; i2 <= 7; ++i2) {
                out.append(String.valueOf(this.I[i2])).append(Separator2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(1013);
        this.appendTo(sb);
        return sb.toString();
    }
}

