/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.moments;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import mathematics.primitives.pointsTiTi.Coordinate;
import measures.BasicMeasures;

public class Centralized {
    protected double[][] Mu = null;
    protected double[][] Nu = null;
    protected int Order = -1;

    public void Compute(BufferedImage image, int Order2) {
        BasicMeasures bbcps = new BasicMeasures();
        bbcps.Compute(image, true);
        this.Compute(image, bbcps.Centroid, Order2);
        bbcps = null;
    }

    public void Compute(BufferedImage image, Coordinate Barycentre, int Order2) {
        int q;
        int p;
        if (image.getType() != 12) {
            throw new IllegalArgumentException("Only binary image supported (shape index).");
        }
        if (Order2 < 0) {
            throw new Error("Order < 0");
        }
        double Bx = Barycentre.X;
        double By = Barycentre.Y;
        this.Order = Order2;
        this.Mu = null;
        this.Nu = null;
        this.Mu = new double[Order2 + 1][Order2 + 1];
        this.Nu = new double[Order2 + 1][Order2 + 1];
        WritableRaster wr = image.getRaster();
        for (p = 0; p <= Order2; ++p) {
            for (q = 0; q <= Order2; ++q) {
                this.Nu[p][q] = 0.0;
                this.Mu[p][q] = 0.0;
            }
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                for (p = 0; p <= Order2; ++p) {
                    for (q = 0; q <= Order2; ++q) {
                        double[] dArray = this.Mu[p];
                        int n = q;
                        dArray[n] = dArray[n] + Math.pow((double)x - Bx, p) * Math.pow((double)y - By, q);
                    }
                }
            }
        }
        for (p = 0; p <= Order2; ++p) {
            for (q = 0; q <= Order2; ++q) {
                this.Nu[p][q] = p + q >= 2 ? this.Mu[p][q] / Math.pow(this.Mu[0][0], p + q >> 2) : this.Mu[p][q] / this.Mu[0][0];
            }
        }
        wr = null;
    }

    public double[][] getMu() {
        return this.Mu;
    }

    public double[][] getNu() {
        return this.Nu;
    }

    public int getOrder() {
        return this.Order;
    }
}

