/*
 * Decompiled with CFR 0.152.
 */
package characterization.shapes.fourier;

import java.awt.image.BufferedImage;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.BasicMeasures;

public class FourierDescriptors {
    protected double[] S = null;
    protected FD[] Descriptors = null;
    private int nbDescriptors = -1;
    private String[] FeaturesNames = null;

    public FourierDescriptors(int nbDescriptors) {
        this.nbDescriptors = nbDescriptors;
        if (nbDescriptors <= 0) {
            return;
        }
        this.FeaturesNames = new String[nbDescriptors];
        for (int i2 = 0; i2 < nbDescriptors; ++i2) {
            this.FeaturesNames[i2] = nbDescriptors < 10 ? "Fourier_0" + i2 : "Fourier_" + i2;
        }
    }

    public void Compute(BufferedImage source, Metric distance, double DistanceMin) {
        BasicMeasures Bbcps = new BasicMeasures();
        Bbcps.Compute(source, true);
        Bbcps.ComputeClockWiseBoundary();
        List<Coordinates> Liste = Bbcps.ClockWiseBoundary.Points();
        for (int i2 = 0; i2 < Liste.size(); ++i2) {
            double dist = 0.0;
            while (i2 + 1 < Liste.size() && dist < DistanceMin) {
                if (!((dist += distance.Distance(Liste.get(i2), Liste.get(i2 + 1))) < DistanceMin)) continue;
                Liste.remove(i2 + 1);
            }
        }
        this.Compute(Liste, Bbcps.Centroid, (Metric)new Euclidian());
        Bbcps = null;
        Liste = null;
    }

    public void Compute(BufferedImage source, Metric distance) {
        int i2;
        if (this.nbDescriptors <= 0) {
            throw new IllegalArgumentException("Illegal number of descriptors:" + this.nbDescriptors);
        }
        int nbDesc = this.nbDescriptors;
        BasicMeasures Bbcps = new BasicMeasures();
        Bbcps.Compute(source, true);
        Bbcps.ComputeClockWiseBoundary();
        List<Coordinates> Liste = Bbcps.ClockWiseBoundary.Points();
        double dist = 0.0;
        for (i2 = 0; i2 < Liste.size() - 1; ++i2) {
            dist += distance.Distance(Liste.get(i2), Liste.get(i2 + 1));
        }
        double DistanceMin = (int)(dist / (2.0 * (double)nbDesc));
        for (i2 = 0; i2 < Liste.size(); ++i2) {
            dist = 0.0;
            while (i2 + 1 < Liste.size() && dist < DistanceMin) {
                if (!((dist += distance.Distance(Liste.get(i2), Liste.get(i2 + 1))) < DistanceMin)) continue;
                Liste.remove(i2 + 1);
            }
        }
        this.Compute(Liste, Bbcps.Centroid, (Metric)new Euclidian());
        Bbcps = null;
        Liste.clear();
        Liste = null;
    }

    public void Compute(List<Coordinates> Liste, Coordinate Centroid, Metric distance) {
        int n;
        double max = 0.0;
        int Size = Liste.size();
        int nbDesc = this.nbDescriptors <= 0 ? (this.nbDescriptors = Liste.size() / 2) : this.nbDescriptors;
        this.S = null;
        this.S = new double[Size];
        this.Descriptors = null;
        this.Descriptors = new FD[nbDesc];
        for (n = 0; n < nbDesc; ++n) {
            this.Descriptors[n] = new FD();
        }
        for (n = 0; n < Size; ++n) {
            this.S[n] = distance.Distance(Liste.get(n), Centroid);
            if (!(max < this.S[n])) continue;
            max = this.S[n];
        }
        n = 0;
        while (n < Size) {
            int n2 = n++;
            this.S[n2] = this.S[n2] / max;
        }
        for (n = 0; n < nbDesc; ++n) {
            for (int t = 0; t < Size; ++t) {
                this.Descriptors[n].Re += this.S[t] * Math.cos(Math.PI * 2 * (double)n * (double)t / (double)Size);
                this.Descriptors[n].Im -= this.S[t] * Math.sin(Math.PI * 2 * (double)n * (double)t / (double)Size);
            }
            this.Descriptors[n].Re /= (double)Size;
            this.Descriptors[n].Im /= (double)Size;
            this.Descriptors[n].R = Math.sqrt(Math.pow(this.Descriptors[n].Re, 2.0) + Math.pow(this.Descriptors[n].Im, 2.0));
        }
        for (n = 0; n < nbDesc; ++n) {
            this.Descriptors[n].R /= this.Descriptors[0].R;
        }
    }

    public FD[] Descriptors() {
        return this.Descriptors;
    }

    public double[] Feature() {
        double[] features = new double[this.Descriptors.length];
        for (int i2 = 0; i2 < features.length; ++i2) {
            features[i2] = this.Descriptors[i2].R;
        }
        return features;
    }

    public double Feature(int i2) {
        return this.Descriptors[i2].R;
    }

    public String[] FeaturesNames() {
        if (this.FeaturesNames != null) {
            return this.FeaturesNames;
        }
        String[] names = new String[this.Descriptors.length];
        for (int i2 = 0; i2 < this.nbDescriptors; ++i2) {
            names[i2] = this.Descriptors.length < 10 ? "Fourier_0" + i2 : "Fourier_" + i2;
        }
        return names;
    }

    protected class FD {
        public double Re = 0.0;
        public double Im = 0.0;
        public double R = 0.0;

        protected FD() {
        }
    }
}

